/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.Text;

public class ScannerOptions
implements ScannerBase {
    protected List<IterInfo> serverSideIteratorList = Collections.emptyList();
    protected Map<String, Map<String, String>> serverSideIteratorOptions = Collections.emptyMap();
    protected SortedSet<Column> fetchedColumns = new TreeSet<Column>();
    protected long timeOut = Long.MAX_VALUE;
    private String regexIterName = null;

    protected ScannerOptions() {
    }

    public ScannerOptions(ScannerOptions so) {
        ScannerOptions.setOptions(this, so);
    }

    @Override
    public synchronized void addScanIterator(IteratorSetting si) {
        Map<String, String> opts;
        ArgumentChecker.notNull(si);
        if (this.serverSideIteratorList.size() == 0) {
            this.serverSideIteratorList = new ArrayList<IterInfo>();
        }
        for (IterInfo ii : this.serverSideIteratorList) {
            if (ii.iterName.equals(si.getName())) {
                throw new IllegalArgumentException("Iterator name is already in use " + si.getName());
            }
            if (ii.getPriority() != si.getPriority()) continue;
            throw new IllegalArgumentException("Iterator priority is already in use " + si.getPriority());
        }
        this.serverSideIteratorList.add(new IterInfo(si.getPriority(), si.getIteratorClass(), si.getName()));
        if (this.serverSideIteratorOptions.size() == 0) {
            this.serverSideIteratorOptions = new HashMap<String, Map<String, String>>();
        }
        if ((opts = this.serverSideIteratorOptions.get(si.getName())) == null) {
            opts = new HashMap<String, String>();
            this.serverSideIteratorOptions.put(si.getName(), opts);
        }
        opts.putAll(si.getOptions());
    }

    @Override
    public synchronized void removeScanIterator(String iteratorName) {
        ArgumentChecker.notNull(iteratorName);
        if (this.serverSideIteratorList.size() == 0) {
            return;
        }
        for (IterInfo ii : this.serverSideIteratorList) {
            if (!ii.iterName.equals(iteratorName)) continue;
            this.serverSideIteratorList.remove(ii);
            break;
        }
        this.serverSideIteratorOptions.remove(iteratorName);
    }

    @Override
    public synchronized void updateScanIteratorOption(String iteratorName, String key, String value) {
        Map<String, String> opts;
        ArgumentChecker.notNull(iteratorName, key, value);
        if (this.serverSideIteratorOptions.size() == 0) {
            this.serverSideIteratorOptions = new HashMap<String, Map<String, String>>();
        }
        if ((opts = this.serverSideIteratorOptions.get(iteratorName)) == null) {
            opts = new HashMap<String, String>();
            this.serverSideIteratorOptions.put(iteratorName, opts);
        }
        opts.put(key, value);
    }

    @Override
    public synchronized void fetchColumnFamily(Text col) {
        ArgumentChecker.notNull(col);
        Column c = new Column(TextUtil.getBytes(col), null, null);
        this.fetchedColumns.add(c);
    }

    @Override
    public synchronized void fetchColumn(Text colFam, Text colQual) {
        ArgumentChecker.notNull(colFam, colQual);
        Column c = new Column(TextUtil.getBytes(colFam), TextUtil.getBytes(colQual), null);
        this.fetchedColumns.add(c);
    }

    public synchronized void fetchColumn(Column column) {
        ArgumentChecker.notNull(column);
        this.fetchedColumns.add(column);
    }

    @Override
    public synchronized void clearColumns() {
        this.fetchedColumns.clear();
    }

    public synchronized SortedSet<Column> getFetchedColumns() {
        return this.fetchedColumns;
    }

    @Override
    public synchronized void clearScanIterators() {
        this.serverSideIteratorList = Collections.emptyList();
        this.serverSideIteratorOptions = Collections.emptyMap();
        this.regexIterName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setOptions(ScannerOptions dst, ScannerOptions src) {
        ScannerOptions scannerOptions = dst;
        synchronized (scannerOptions) {
            ScannerOptions scannerOptions2 = src;
            synchronized (scannerOptions2) {
                dst.regexIterName = src.regexIterName;
                dst.fetchedColumns = new TreeSet<Column>(src.fetchedColumns);
                dst.serverSideIteratorList = new ArrayList<IterInfo>(src.serverSideIteratorList);
                dst.serverSideIteratorOptions = new HashMap<String, Map<String, String>>();
                Set<Map.Entry<String, Map<String, String>>> es = src.serverSideIteratorOptions.entrySet();
                for (Map.Entry<String, Map<String, String>> entry : es) {
                    dst.serverSideIteratorOptions.put(entry.getKey(), new HashMap<String, String>(entry.getValue()));
                }
            }
        }
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimeout(long timeout, TimeUnit timeUnit) {
        if (this.timeOut < 0L) {
            throw new IllegalArgumentException("TimeOut must be positive : " + this.timeOut);
        }
        this.timeOut = timeout == 0L ? Long.MAX_VALUE : timeUnit.toMillis(timeout);
    }

    @Override
    public long getTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.timeOut, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
    }
}

