/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.parameters;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Shell;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.tools.parameters.ParamLoader;
import org.apache.pig.tools.parameters.ParameterSubstitutionException;
import org.apache.pig.tools.parameters.ParseException;
import org.apache.pig.validator.BlackAndWhitelistFilter;
import org.apache.pig.validator.PigCommandFilter;

public class PreprocessorContext {
    private int tableinitsize = 10;
    private Deque<Map<String, String>> param_val_stack;
    private PigContext pigContext;
    private final Log log = LogFactory.getLog(this.getClass());
    private Pattern bracketIdPattern = Pattern.compile("\\$\\{([_]*[a-zA-Z][a-zA-Z_0-9]*)\\}");
    private Pattern id_pattern = Pattern.compile("\\$([_]*[a-zA-Z][a-zA-Z_0-9]*)");

    public Map<String, String> getParamVal() {
        Hashtable<String, String> ret = new Hashtable<String, String>(this.tableinitsize);
        for (Map<String, String> map : this.param_val_stack) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (ret.containsKey(entry.getKey())) continue;
                ret.put(entry.getKey(), entry.getValue());
            }
        }
        return ret;
    }

    public PreprocessorContext(int limit) {
        this.tableinitsize = limit;
        this.param_val_stack = new ArrayDeque<Map<String, String>>();
        this.param_val_stack.push(new Hashtable(this.tableinitsize));
    }

    public void setPigContext(PigContext context) {
        this.pigContext = context;
    }

    public void processShellCmd(String key, String val) throws ParameterSubstitutionException, FrontendException {
        this.processShellCmd(key, val, true);
    }

    public void processOrdLine(String key, String val) throws ParameterSubstitutionException {
        this.processOrdLine(key, val, true);
    }

    public void paramScopePush() {
        this.param_val_stack.push(new Hashtable(this.tableinitsize));
    }

    public void paramScopePop() {
        this.param_val_stack.pop();
    }

    public boolean paramval_containsKey(String key) {
        for (Map<String, String> map : this.param_val_stack) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public String paramval_get(String key) {
        for (Map<String, String> map : this.param_val_stack) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }

    public void paramval_put(String key, String value) {
        this.param_val_stack.peek().put(key, value);
    }

    public void processShellCmd(String key, String val, Boolean overwrite) throws ParameterSubstitutionException, FrontendException {
        if (this.pigContext != null) {
            BlackAndWhitelistFilter filter = new BlackAndWhitelistFilter(this.pigContext);
            filter.validate(PigCommandFilter.Command.SH);
        }
        if (this.paramval_containsKey(key) && !overwrite.booleanValue()) {
            return;
        }
        val = val.substring(1, val.length() - 1);
        String sub_val = this.substitute(val);
        sub_val = this.executeShellCommand(sub_val);
        if (this.paramval_containsKey(key) && !this.paramval_get(key).equals(sub_val)) {
            this.log.warn((Object)("Warning : Multiple values found for " + key + " command `" + val + "`. Previous value " + this.paramval_get(key) + ", now using value " + sub_val));
        }
        this.paramval_put(key, sub_val);
    }

    public void validate(String preprocessorCmd) throws FrontendException {
        if (this.pigContext == null) {
            return;
        }
        BlackAndWhitelistFilter filter = new BlackAndWhitelistFilter(this.pigContext);
        String declareToken = "%declare";
        String defaultToken = "%default";
        if (preprocessorCmd.toLowerCase().equals("%declare")) {
            filter.validate(PigCommandFilter.Command.DECLARE);
        } else if (preprocessorCmd.toLowerCase().equals("%default")) {
            filter.validate(PigCommandFilter.Command.DEFAULT);
        } else {
            throw new IllegalArgumentException("Pig Internal Error. Invalid preprocessor command specified : " + preprocessorCmd);
        }
    }

    public void processOrdLine(String key, String val, Boolean overwrite) throws ParameterSubstitutionException {
        String sub_val = this.substitute(val, key);
        if (this.paramval_containsKey(key)) {
            if (this.paramval_get(key).equals(sub_val) || !overwrite.booleanValue()) {
                return;
            }
            this.log.warn((Object)("Warning : Multiple values found for " + key + ". Previous value " + this.paramval_get(key) + ", now using value " + sub_val));
        }
        this.paramval_put(key, sub_val);
    }

    private String executeShellCommand(String cmd) {
        int exitVal;
        Process p;
        String streamData = "";
        String streamError = "";
        try {
            String[] cmdArgs;
            this.log.info((Object)("Executing command : " + cmd));
            StringBuffer sb = new StringBuffer("");
            if (Shell.WINDOWS) {
                cmd = cmd.replaceAll("/", "\\\\");
                sb.append(cmd);
                cmdArgs = new String[]{"cmd", "/c", sb.toString()};
            } else {
                sb.append("exec ");
                sb.append(cmd);
                cmdArgs = new String[]{"bash", "-c", sb.toString()};
            }
            p = Runtime.getRuntime().exec(cmdArgs);
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException("IO Exception while executing shell command : " + e.getMessage(), e);
            throw rte;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<String> futureOut = executorService.submit(new CallableStreamReader(p.getInputStream()));
        Future<String> futureErr = executorService.submit(new CallableStreamReader(p.getErrorStream()));
        try {
            streamData = futureOut.get();
            streamError = futureErr.get();
            this.log.debug((Object)("Error stream while executing shell command : " + streamError));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("InterruptedException while executing shell command : " + e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("ExecutionException while executing shell command : " + e.getMessage(), e);
        }
        finally {
            executorService.shutdownNow();
        }
        try {
            exitVal = p.waitFor();
        }
        catch (InterruptedException e) {
            RuntimeException rte = new RuntimeException("Interrupted Thread Exception while waiting for command to get over" + e.getMessage(), e);
            throw rte;
        }
        if (exitVal != 0) {
            RuntimeException rte = new RuntimeException("Error executing shell command: " + cmd + ". Command exit with exit code of " + exitVal);
            throw rte;
        }
        return streamData.trim();
    }

    public void loadParamVal(List<String> params, List<String> paramFiles) throws IOException, ParseException {
        Reader dummyReader = null;
        ParamLoader paramLoader = new ParamLoader(dummyReader);
        paramLoader.setContext(this);
        if (paramFiles != null) {
            for (String path : paramFiles) {
                BufferedReader in = new BufferedReader(new FileReader(path));
                paramLoader.ReInit(in);
                while (paramLoader.Parse()) {
                }
                in.close();
            }
        }
        if (params != null) {
            for (String param : params) {
                paramLoader.ReInit(new StringReader(param));
                paramLoader.Parse();
            }
        }
    }

    public String substitute(String line) throws ParameterSubstitutionException {
        return this.substitute(line, null);
    }

    public String substitute(String line, String parentKey) throws ParameterSubstitutionException {
        int index = line.indexOf(36);
        if (index == -1) {
            return line;
        }
        String replaced_line = line;
        Matcher bracketKeyMatcher = this.bracketIdPattern.matcher(line);
        String key = "";
        String val = "";
        while (bracketKeyMatcher.find()) {
            if (bracketKeyMatcher.start() != 0 && line.charAt(bracketKeyMatcher.start() - 1) == '\\') continue;
            key = bracketKeyMatcher.group(1);
            if (!this.paramval_containsKey(key)) {
                String message = parentKey == null ? "Undefined parameter : " + key : "Undefined parameter : " + key + " found when trying to find the value of " + parentKey + ".";
                throw new ParameterSubstitutionException(message);
            }
            val = this.paramval_get(key);
            if (val.contains("$")) {
                val = val.replaceAll("(?<!\\\\)\\$", "\\\\\\$");
            }
            replaced_line = replaced_line.replaceFirst("\\$\\{" + key + "\\}", val);
        }
        Matcher keyMatcher = this.id_pattern.matcher(replaced_line);
        key = "";
        val = "";
        while (keyMatcher.find()) {
            if (keyMatcher.start() != 0 && line.charAt(keyMatcher.start() - 1) == '\\') continue;
            key = keyMatcher.group(1);
            if (!this.paramval_containsKey(key)) {
                String message = parentKey == null ? "Undefined parameter : " + key : "Undefined parameter : " + key + " found when trying to find the value of " + parentKey + ".";
                throw new ParameterSubstitutionException(message);
            }
            val = this.paramval_get(key);
            if (val.contains("$")) {
                val = val.replaceAll("(?<!\\\\)\\$", "\\\\\\$");
            }
            replaced_line = replaced_line.replaceFirst("\\$" + key, val);
        }
        replaced_line = replaced_line.replaceAll("\\\\\\$", "\\$");
        return replaced_line;
    }

    public static class CallableStreamReader
    implements Callable<String> {
        private final InputStream inputStream;

        public CallableStreamReader(InputStream stream) {
            this.inputStream = stream;
        }

        @Override
        public String call() {
            try {
                String string = IOUtils.toString((InputStream)this.inputStream);
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("IO Exception while executing shell command: " + e.getMessage(), e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.inputStream);
            }
        }
    }
}

