/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPigContext;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.IndexedKey;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.IteratorTransform;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.SecondaryKeySortUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POGlobalRearrangeSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POJoinGroupSpark;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.CoGroupedRDD;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.runtime.AbstractFunction1;

public class JoinGroupSparkConverter
implements RDDConverter<Tuple, Tuple, POJoinGroupSpark> {
    private static final Log LOG = LogFactory.getLog(JoinGroupSparkConverter.class);

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POJoinGroupSpark op) throws IOException {
        RDD rdd;
        SparkUtil.assertPredecessorSizeGreaterThan(predecessors, op, 0);
        List<POLocalRearrange> lraOps = op.getLROps();
        POGlobalRearrangeSpark glaOp = op.getGROp();
        POPackage pkgOp = op.getPkgOp();
        SparkPigContext.get();
        int parallelism = SparkPigContext.getParallelism(predecessors, glaOp);
        ArrayList<RDD> rddAfterLRA = new ArrayList<RDD>();
        boolean useSecondaryKey = glaOp.isUseSecondaryKey();
        for (int i = 0; i < predecessors.size(); ++i) {
            rdd = predecessors.get(i);
            rddAfterLRA.add(rdd.map((Function1)new LocalRearrangeFunction(lraOps.get(i), glaOp), SparkUtil.getTuple2Manifest()));
        }
        if (rddAfterLRA.size() == 1 && useSecondaryKey) {
            return SecondaryKeySortUtil.handleSecondarySort((RDD<Tuple2<IndexedKey, Tuple>>)((RDD)rddAfterLRA.get(0)), pkgOp);
        }
        CoGroupedRDD coGroupedRDD = new CoGroupedRDD(JavaConversions.asScalaBuffer(rddAfterLRA).toSeq(), SparkUtil.getPartitioner(glaOp.getCustomPartitioner(), parallelism), SparkUtil.getManifest(Object.class));
        rdd = (RDD)coGroupedRDD;
        return rdd.toJavaRDD().map((Function)new GroupPkgFunction(pkgOp)).rdd();
    }

    private static class IteratorUnion<T>
    implements Iterator<T> {
        private final Iterator<Iterator<T>> iterators;
        private Iterator<T> current;

        public IteratorUnion(Iterator<Iterator<T>> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            if (this.current != null && this.current.hasNext()) {
                return true;
            }
            if (this.iterators.hasNext()) {
                this.current = this.iterators.next();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            return this.current.next();
        }

        @Override
        public void remove() {
            this.current.remove();
        }
    }

    private static class GroupPkgFunction
    implements Function<Tuple2<IndexedKey, Seq<Seq<Tuple>>>, Tuple>,
    Serializable {
        private final POPackage pkgOp;

        public GroupPkgFunction(POPackage pkgOp) {
            this.pkgOp = pkgOp;
        }

        public Tuple call(final Tuple2<IndexedKey, Seq<Seq<Tuple>>> input) {
            try {
                Tuple out;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("GroupPkgFunction in " + input));
                }
                PigNullableWritable key = new PigNullableWritable(){

                    @Override
                    public Object getValueAsPigType() {
                        IndexedKey keyTuple = (IndexedKey)input._1();
                        return keyTuple.getKey();
                    }
                };
                Object obj = input._2();
                Seq[] bags = (Seq[])obj;
                int i = 0;
                ArrayList<2> tupleIterators = new ArrayList<2>();
                for (int j = 0; j < bags.length; ++j) {
                    Seq bag = bags[j];
                    Iterator iterator = JavaConversions.asJavaCollection((Iterable)bag).iterator();
                    final int index = i++;
                    tupleIterators.add(new IteratorTransform<Tuple, NullableTuple>(iterator){

                        @Override
                        protected NullableTuple transform(Tuple next) {
                            NullableTuple nullableTuple = new NullableTuple(next);
                            nullableTuple.setIndex((byte)index);
                            return nullableTuple;
                        }
                    });
                }
                this.pkgOp.setInputs(null);
                this.pkgOp.attachInput(key, new IteratorUnion<NullableTuple>(tupleIterators.iterator()));
                Result result = this.pkgOp.getNextTuple();
                if (result == null) {
                    throw new RuntimeException("Null response found for Package on key: " + key);
                }
                switch (result.returnStatus) {
                    case 0: {
                        out = (Tuple)result.result;
                        break;
                    }
                    case 1: {
                        out = null;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected response code from operator " + this.pkgOp + " : " + result + " " + result.returnStatus);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("GroupPkgFunction out " + out));
                }
                return out;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class LocalRearrangeFunction
    extends AbstractFunction1<Tuple, Tuple2<IndexedKey, Tuple>>
    implements Serializable {
        private final POLocalRearrange lra;
        private boolean useSecondaryKey;
        private boolean[] secondarySortOrder;

        public LocalRearrangeFunction(POLocalRearrange lra, POGlobalRearrangeSpark glaOp) {
            if (glaOp.isUseSecondaryKey()) {
                this.useSecondaryKey = glaOp.isUseSecondaryKey();
                this.secondarySortOrder = glaOp.getSecondarySortOrder();
            }
            this.lra = lra;
        }

        public Tuple2<IndexedKey, Tuple> apply(Tuple t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("LocalRearrangeFunction in " + t));
            }
            try {
                this.lra.setInputs(null);
                this.lra.attachInput(t);
                Result result = this.lra.getNextTuple();
                if (result == null) {
                    throw new RuntimeException("Null response found for LocalRearange on tuple: " + t);
                }
                switch (result.returnStatus) {
                    case 0: {
                        Tuple resultTuple = (Tuple)result.result;
                        Object key = resultTuple.get(1);
                        IndexedKey indexedKey = new IndexedKey((Byte)resultTuple.get(0), key);
                        if (this.useSecondaryKey) {
                            indexedKey.setUseSecondaryKey(this.useSecondaryKey);
                            indexedKey.setSecondarySortOrder(this.secondarySortOrder);
                        }
                        Tuple2 out = new Tuple2((Object)indexedKey, (Object)((Tuple)resultTuple.get(2)));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("LocalRearrangeFunction out " + out));
                        }
                        return out;
                    }
                }
                throw new RuntimeException("Unexpected response code from operator " + this.lra + " : " + result);
            }
            catch (ExecException e) {
                throw new RuntimeException("Couldn't do LocalRearange on tuple: " + t, e);
            }
        }
    }
}

