/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoinSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPigContext;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.OutputConsumerIterator;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.rdd.RDD;

public class FRJoinConverter
implements RDDConverter<Tuple, Tuple, POFRJoin> {
    private static final Log LOG = LogFactory.getLog(FRJoinConverter.class);
    private Set<String> replicatedInputs;

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POFRJoin poFRJoin) throws IOException {
        SparkUtil.assertPredecessorSizeGreaterThan(predecessors, poFRJoin, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        this.attachReplicatedInputs((POFRJoinSpark)poFRJoin);
        FRJoinFunction frJoinFunction = new FRJoinFunction(poFRJoin);
        return rdd.toJavaRDD().mapPartitions((FlatMapFunction)frJoinFunction, true).rdd();
    }

    private void attachReplicatedInputs(POFRJoinSpark poFRJoin) {
        HashMap<String, List<Tuple>> replicatedInputMap = new HashMap<String, List<Tuple>>();
        for (String replicatedInput : this.replicatedInputs) {
            SparkPigContext.get();
            replicatedInputMap.put(replicatedInput, (List<Tuple>)SparkPigContext.getBroadcastedVars().get(replicatedInput).value());
        }
        poFRJoin.attachInputs(replicatedInputMap);
    }

    public void setReplicatedInputs(Set<String> replicatedInputs) {
        this.replicatedInputs = replicatedInputs;
    }

    private static class FRJoinFunction
    implements FlatMapFunction<Iterator<Tuple>, Tuple>,
    Serializable {
        private POFRJoin poFRJoin;

        private FRJoinFunction(POFRJoin poFRJoin) {
            this.poFRJoin = poFRJoin;
        }

        public Iterable<Tuple> call(final Iterator<Tuple> input) throws Exception {
            return new Iterable<Tuple>(){

                @Override
                public Iterator<Tuple> iterator() {
                    return new OutputConsumerIterator(input){

                        @Override
                        protected void attach(Tuple tuple) {
                            FRJoinFunction.this.poFRJoin.setInputs(null);
                            FRJoinFunction.this.poFRJoin.attachInput(tuple);
                        }

                        @Override
                        protected Result getNextResult() throws ExecException {
                            return FRJoinFunction.this.poFRJoin.getNextTuple();
                        }

                        @Override
                        protected void endOfInput() {
                        }
                    };
                }
            };
        }
    }
}

