/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class CompoundString
extends Operand {
    private final List<Operand> pieces;
    private final Encoding encoding;

    public CompoundString(List<Operand> pieces, Encoding encoding2) {
        this.pieces = pieces;
        this.encoding = encoding2;
    }

    public CompoundString(List<Operand> pieces) {
        this(pieces, null);
    }

    @Override
    public boolean hasKnownValue() {
        if (this.pieces != null) {
            for (Operand o : this.pieces) {
                if (o.hasKnownValue()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "CompoundString:" + (this.encoding == null ? "" : this.encoding) + (this.pieces == null ? "[]" : Arrays.toString(this.pieces.toArray()));
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        ArrayList<Operand> newPieces = new ArrayList<Operand>();
        for (Operand p2 : this.pieces) {
            newPieces.add(p2.getSimplifiedOperand(valueMap, force));
        }
        return new CompoundString(newPieces, this.encoding);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (Operand o : this.pieces) {
            o.addUsedVariables(l);
        }
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        if (this.hasKnownValue()) {
            return this;
        }
        ArrayList<Operand> newPieces = new ArrayList<Operand>();
        for (Operand p2 : this.pieces) {
            newPieces.add(p2.cloneForInlining(ii));
        }
        return new CompoundString(newPieces, this.encoding);
    }

    String retrieveJavaString(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, Object[] temp) {
        StringBuilder buf = new StringBuilder();
        for (Operand p2 : this.pieces) {
            buf.append(p2.retrieve(context, self2, currDynScope, temp));
        }
        return buf.toString();
    }

    public boolean isSameEncoding(StringLiteral str) {
        return str.bytelist.getEncoding() == this.encoding;
    }

    public RubyString[] retrievePieces(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, Object[] temp) {
        RubyString[] strings = new RubyString[this.pieces.size()];
        int i2 = 0;
        for (Operand p2 : this.pieces) {
            strings[i2++] = (RubyString)p2.retrieve(context, self2, currDynScope, temp);
        }
        return strings;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, Object[] temp) {
        boolean is1_9 = context.runtime.is1_9();
        ByteList bytes2 = new ByteList();
        if (is1_9) {
            bytes2.setEncoding(this.encoding);
        }
        RubyString str = RubyString.newStringShared(context.runtime, bytes2, 32);
        for (Operand p2 : this.pieces) {
            if (p2 instanceof StringLiteral && (!is1_9 || this.isSameEncoding((StringLiteral)p2))) {
                str.getByteList().append(((StringLiteral)p2).bytelist);
                continue;
            }
            IRubyObject pval = (IRubyObject)p2.retrieve(context, self2, currDynScope, temp);
            if (is1_9) {
                str.append19(pval);
                continue;
            }
            str.append(pval);
        }
        return str;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CompoundString(this);
    }
}

