/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNodeUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;

public class NodesListManager
extends AbstractService
implements EventHandler<NodesListManagerEvent> {
    private static final Log LOG = LogFactory.getLog(NodesListManager.class);
    private HostsFileReader hostsReader;
    private Configuration conf;
    private Set<RMNode> unusableRMNodesConcurrentSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final RMContext rmContext;
    private String includesFile;
    private String excludesFile;

    public NodesListManager(RMContext rmContext) {
        super(NodesListManager.class.getName());
        this.rmContext = rmContext;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        try {
            this.includesFile = conf.get("yarn.resourcemanager.nodes.include-path", "");
            this.excludesFile = conf.get("yarn.resourcemanager.nodes.exclude-path", "");
            this.hostsReader = this.createHostsFileReader(this.includesFile, this.excludesFile);
            this.setDecomissionedNMs();
            this.printConfiguredHosts();
        }
        catch (YarnException ex) {
            this.disableHostsFileReader((Exception)((Object)ex));
        }
        catch (IOException ioe) {
            this.disableHostsFileReader(ioe);
        }
        super.serviceInit(conf);
    }

    private void printConfiguredHosts() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)("hostsReader: in=" + this.conf.get("yarn.resourcemanager.nodes.include-path", "") + " out=" + this.conf.get("yarn.resourcemanager.nodes.exclude-path", "")));
        for (String include : this.hostsReader.getHosts()) {
            LOG.debug((Object)("include: " + include));
        }
        for (String exclude : this.hostsReader.getExcludedHosts()) {
            LOG.debug((Object)("exclude: " + exclude));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNodes(Configuration yarnConf) throws IOException, YarnException {
        HostsFileReader hostsFileReader = this.hostsReader;
        synchronized (hostsFileReader) {
            if (null == yarnConf) {
                yarnConf = new YarnConfiguration();
            }
            this.includesFile = yarnConf.get("yarn.resourcemanager.nodes.include-path", "");
            this.excludesFile = yarnConf.get("yarn.resourcemanager.nodes.exclude-path", "");
            this.hostsReader.updateFileNames(this.includesFile, this.excludesFile);
            this.hostsReader.refresh(this.includesFile.isEmpty() ? null : this.rmContext.getConfigurationProvider().getConfigurationInputStream(this.conf, this.includesFile), this.excludesFile.isEmpty() ? null : this.rmContext.getConfigurationProvider().getConfigurationInputStream(this.conf, this.excludesFile));
            this.printConfiguredHosts();
        }
        for (NodeId nodeId : this.rmContext.getRMNodes().keySet()) {
            if (this.isValidNode(nodeId.getHost())) continue;
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(nodeId, RMNodeEventType.DECOMMISSION));
        }
    }

    private void setDecomissionedNMs() {
        Set excludeList = this.hostsReader.getExcludedHosts();
        for (String host : excludeList) {
            NodeId nodeId = NodesListManager.createUnknownNodeId(host);
            RMNodeImpl rmNode = new RMNodeImpl(nodeId, this.rmContext, host, -1, -1, new UnknownNode(host), null, null);
            this.rmContext.getInactiveRMNodes().put(nodeId.getHost(), rmNode);
            rmNode.handle(new RMNodeEvent(nodeId, RMNodeEventType.DECOMMISSION));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidNode(String hostName) {
        HostsFileReader hostsFileReader = this.hostsReader;
        synchronized (hostsFileReader) {
            Set hostsList = this.hostsReader.getHosts();
            Set excludeList = this.hostsReader.getExcludedHosts();
            String ip = NetUtils.normalizeHostName((String)hostName);
            return (hostsList.isEmpty() || hostsList.contains(hostName) || hostsList.contains(ip)) && !excludeList.contains(hostName) && !excludeList.contains(ip);
        }
    }

    public int getUnusableNodes(Collection<RMNode> unUsableNodes) {
        unUsableNodes.addAll(this.unusableRMNodesConcurrentSet);
        return this.unusableRMNodesConcurrentSet.size();
    }

    public void handle(NodesListManagerEvent event) {
        RMNode eventNode = event.getNode();
        switch ((NodesListManagerEventType)event.getType()) {
            case NODE_UNUSABLE: {
                LOG.debug((Object)(eventNode + " reported unusable"));
                this.unusableRMNodesConcurrentSet.add(eventNode);
                for (RMApp app : this.rmContext.getRMApps().values()) {
                    if (app.isAppFinalStateStored()) continue;
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppNodeUpdateEvent(app.getApplicationId(), eventNode, RMAppNodeUpdateEvent.RMAppNodeUpdateType.NODE_UNUSABLE));
                }
                break;
            }
            case NODE_USABLE: {
                if (this.unusableRMNodesConcurrentSet.contains(eventNode)) {
                    LOG.debug((Object)(eventNode + " reported usable"));
                    this.unusableRMNodesConcurrentSet.remove(eventNode);
                }
                for (RMApp app : this.rmContext.getRMApps().values()) {
                    if (app.isAppFinalStateStored()) continue;
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppNodeUpdateEvent(app.getApplicationId(), eventNode, RMAppNodeUpdateEvent.RMAppNodeUpdateType.NODE_USABLE));
                }
                break;
            }
            default: {
                LOG.error((Object)("Ignoring invalid eventtype " + event.getType()));
            }
        }
    }

    private void disableHostsFileReader(Exception ex) {
        LOG.warn((Object)"Failed to init hostsReader, disabling", (Throwable)ex);
        try {
            this.includesFile = this.conf.get("");
            this.excludesFile = this.conf.get("");
            this.hostsReader = this.createHostsFileReader(this.includesFile, this.excludesFile);
            this.setDecomissionedNMs();
        }
        catch (IOException ioe2) {
            this.hostsReader = null;
            throw new YarnRuntimeException((Throwable)ioe2);
        }
        catch (YarnException e) {
            this.hostsReader = null;
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    @VisibleForTesting
    public HostsFileReader getHostsReader() {
        return this.hostsReader;
    }

    private HostsFileReader createHostsFileReader(String includesFile, String excludesFile) throws IOException, YarnException {
        HostsFileReader hostsReader = new HostsFileReader(includesFile, includesFile == null || includesFile.isEmpty() ? null : this.rmContext.getConfigurationProvider().getConfigurationInputStream(this.conf, includesFile), excludesFile, excludesFile == null || excludesFile.isEmpty() ? null : this.rmContext.getConfigurationProvider().getConfigurationInputStream(this.conf, excludesFile));
        return hostsReader;
    }

    public static NodeId createUnknownNodeId(String host) {
        return NodeId.newInstance((String)host, (int)-1);
    }

    private static class UnknownNode
    implements Node {
        private String host;

        public UnknownNode(String host) {
            this.host = host;
        }

        public String getNetworkLocation() {
            return null;
        }

        public void setNetworkLocation(String location) {
        }

        public String getName() {
            return this.host;
        }

        public Node getParent() {
            return null;
        }

        public void setParent(Node parent) {
        }

        public int getLevel() {
            return 0;
        }

        public void setLevel(int i) {
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String hst) {
            this.host = hst;
        }
    }
}

