/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.LoggingRunnable;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.core.util.TBufferedSocket;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.thrift.metrics.ThriftMetrics;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.TBufferedServerSocket;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TServerUtils {
    private static final Logger log = Logger.getLogger(TServerUtils.class);
    public static final ThreadLocal<String> clientAddress = new ThreadLocal();

    public static ServerPort startServer(AccumuloConfiguration conf, Property portHintProperty, TProcessor processor, String serverName, String threadName, Property portSearchProperty, Property minThreadProperty, Property timeBetweenThreadChecksProperty, Property maxMessageSizeProperty) throws UnknownHostException {
        int portHint = conf.getPort(portHintProperty);
        int minThreads = 2;
        if (minThreadProperty != null) {
            minThreads = conf.getCount(minThreadProperty);
        }
        long timeBetweenThreadChecks = 1000L;
        if (timeBetweenThreadChecksProperty != null) {
            timeBetweenThreadChecks = conf.getTimeInMillis(timeBetweenThreadChecksProperty);
        }
        long maxMessageSize = 10000000L;
        if (maxMessageSizeProperty != null) {
            maxMessageSize = conf.getMemoryInBytes(maxMessageSizeProperty);
        }
        boolean portSearch = false;
        if (portSearchProperty != null) {
            portSearch = conf.getBoolean(portSearchProperty);
        }
        Random random = new Random();
        for (int j = 0; j < 100; ++j) {
            int portsToSearch = 1;
            if (portSearch) {
                portsToSearch = 1000;
            }
            for (int i = 0; i < portsToSearch; ++i) {
                int port = portHint + i;
                if (portHint == 0) {
                    port = 1024 + random.nextInt(64511);
                }
                if (port > 65535) {
                    port = 1024 + port % 64511;
                }
                try {
                    return TServerUtils.startTServer(port, processor, serverName, threadName, minThreads, timeBetweenThreadChecks, maxMessageSize);
                }
                catch (Exception ex) {
                    log.info((Object)("Unable to use port " + port + ", retrying. (Thread Name = " + threadName + ")"));
                    UtilWaitThread.sleep((long)250L);
                    continue;
                }
            }
        }
        throw new UnknownHostException("Unable to find a listen port");
    }

    public static ServerPort startHsHaServer(int port, TProcessor processor, String serverName, String threadName, int numThreads, long timeBetweenThreadChecks, long maxMessageSize) throws TTransportException {
        TNonblockingServerSocket transport = new TNonblockingServerSocket(port);
        THsHaServer.Args options = new THsHaServer.Args((TNonblockingServerTransport)transport);
        options.protocolFactory(ThriftUtil.protocolFactory());
        options.transportFactory(ThriftUtil.transportFactory((long)maxMessageSize));
        options.stopTimeoutVal(5);
        SimpleThreadPool pool = new SimpleThreadPool(numThreads, "ClientPool");
        SimpleTimer.getInstance().schedule(new Runnable((ThreadPoolExecutor)pool, serverName, numThreads){
            final /* synthetic */ ThreadPoolExecutor val$pool;
            final /* synthetic */ String val$serverName;
            final /* synthetic */ int val$numThreads;
            {
                this.val$pool = threadPoolExecutor;
                this.val$serverName = string;
                this.val$numThreads = n;
            }

            @Override
            public void run() {
                int smaller;
                if (this.val$pool.getCorePoolSize() <= this.val$pool.getActiveCount()) {
                    int larger = this.val$pool.getCorePoolSize() + Math.min(this.val$pool.getQueue().size(), 2);
                    log.info((Object)("Increasing server thread pool size on " + this.val$serverName + " to " + larger));
                    this.val$pool.setMaximumPoolSize(larger);
                    this.val$pool.setCorePoolSize(larger);
                } else if (this.val$pool.getCorePoolSize() > this.val$pool.getActiveCount() + 3 && (smaller = Math.max(this.val$numThreads, this.val$pool.getCorePoolSize() - 1)) != this.val$pool.getCorePoolSize()) {
                    log.info((Object)("Decreasing server thread pool size on " + this.val$serverName + " to " + smaller));
                    this.val$pool.setCorePoolSize(smaller);
                }
            }
        }, timeBetweenThreadChecks, timeBetweenThreadChecks);
        options.executorService((ExecutorService)pool);
        processor = new TimedProcessor(processor, serverName, threadName);
        options.processorFactory(new TProcessorFactory(processor));
        return new ServerPort((TServer)new THsHaServer(options), port);
    }

    public static ServerPort startThreadPoolServer(int port, TProcessor processor, String serverName, String threadName, int numThreads) throws TTransportException {
        ServerSocket sock;
        try {
            sock = ServerSocketChannel.open().socket();
            sock.setReuseAddress(true);
            sock.bind(new InetSocketAddress(port));
            port = sock.getLocalPort();
        }
        catch (IOException ex) {
            throw new TTransportException((Throwable)ex);
        }
        TBufferedServerSocket transport = new TBufferedServerSocket(sock, 32768);
        TThreadPoolServer.Args options = new TThreadPoolServer.Args((TServerTransport)transport);
        options.protocolFactory(ThriftUtil.protocolFactory());
        options.transportFactory(ThriftUtil.transportFactory());
        processor = new TimedProcessor(processor, serverName, threadName);
        options.processorFactory((TProcessorFactory)new ClientInfoProcessorFactory(processor));
        return new ServerPort((TServer)new TThreadPoolServer(options), port);
    }

    public static ServerPort startTServer(int port, TProcessor processor, String serverName, String threadName, int numThreads, long timeBetweenThreadChecks, long maxMessageSize) throws TTransportException {
        ServerPort result = TServerUtils.startHsHaServer(port, processor, serverName, threadName, numThreads, timeBetweenThreadChecks, maxMessageSize);
        final TServer finalServer = result.server;
        Runnable serveTask = new Runnable(){

            @Override
            public void run() {
                try {
                    finalServer.serve();
                }
                catch (Error e) {
                    Halt.halt("Unexpected error in TThreadPoolServer " + e + ", halting.");
                }
            }
        };
        serveTask = new LoggingRunnable(log, serveTask);
        Daemon thread = new Daemon(serveTask, threadName);
        thread.start();
        return result;
    }

    public static void stopTServer(TServer s) {
        if (s == null) {
            return;
        }
        s.stop();
        try {
            Field f = s.getClass().getDeclaredField("executorService_");
            f.setAccessible(true);
            ExecutorService es = (ExecutorService)f.get(s);
            es.shutdownNow();
        }
        catch (Exception e) {
            log.error((Object)"Unable to call shutdownNow", (Throwable)e);
        }
    }

    public static class THsHaServer
    extends org.apache.thrift.server.THsHaServer {
        public THsHaServer(THsHaServer.Args args) {
            super(args);
        }

        protected Runnable getRunnable(AbstractNonblockingServer.FrameBuffer frameBuffer) {
            return new Invocation(frameBuffer);
        }

        private class Invocation
        implements Runnable {
            private final AbstractNonblockingServer.FrameBuffer frameBuffer;

            public Invocation(AbstractNonblockingServer.FrameBuffer frameBuffer) {
                this.frameBuffer = frameBuffer;
            }

            @Override
            public void run() {
                if (this.frameBuffer.trans_ instanceof TNonblockingSocket) {
                    TNonblockingSocket tsock = (TNonblockingSocket)this.frameBuffer.trans_;
                    Socket sock = tsock.getSocketChannel().socket();
                    clientAddress.set(sock.getInetAddress().getHostAddress() + ":" + sock.getPort());
                }
                this.frameBuffer.invoke();
            }
        }
    }

    public static class ClientInfoProcessorFactory
    extends TProcessorFactory {
        public ClientInfoProcessorFactory(TProcessor processor) {
            super(processor);
        }

        public TProcessor getProcessor(TTransport trans) {
            if (trans instanceof TBufferedSocket) {
                TBufferedSocket tsock = (TBufferedSocket)trans;
                clientAddress.set(tsock.getClientString());
            }
            return super.getProcessor(trans);
        }
    }

    public static class TimedProcessor
    implements TProcessor {
        final TProcessor other;
        ThriftMetrics metrics = null;
        long idleStart = 0L;

        TimedProcessor(TProcessor next, String serverName, String threadName) {
            this.other = next;
            try {
                this.metrics = new ThriftMetrics(serverName, threadName);
                this.metrics.register();
            }
            catch (Exception e) {
                log.error((Object)"Exception registering MBean with MBean Server", (Throwable)e);
            }
            this.idleStart = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(TProtocol in, TProtocol out) throws TException {
            long now = 0L;
            if (this.metrics.isEnabled()) {
                now = System.currentTimeMillis();
                this.metrics.add("idle", now - this.idleStart);
            }
            try {
                boolean bl = this.other.process(in, out);
                return bl;
            }
            catch (NullPointerException ex) {
                boolean bl = true;
                return bl;
            }
            finally {
                if (this.metrics.isEnabled()) {
                    this.idleStart = System.currentTimeMillis();
                    this.metrics.add("execute", this.idleStart - now);
                }
            }
        }
    }

    public static class ServerPort {
        public final TServer server;
        public final int port;

        public ServerPort(TServer server, int port) {
            this.server = server;
            this.port = port;
        }
    }
}

