/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.util.Formattable;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;

public class ListInstances {
    private static final Logger log = Logger.getLogger(ListInstances.class);
    private static final int NAME_WIDTH = 20;
    private static final int UUID_WIDTH = 37;
    private static final int MASTER_WIDTH = 30;
    static Opts opts = new Opts();
    static int errors = 0;

    public static void main(String[] args) {
        opts.parseArgs(ListInstances.class.getName(), args, new Object[0]);
        if (ListInstances.opts.keepers == null) {
            ListInstances.opts.keepers = ServerConfiguration.getSiteConfiguration().get(Property.INSTANCE_ZK_HOST);
        }
        System.out.println("INFO : Using ZooKeepers " + ListInstances.opts.keepers);
        TreeMap<String, UUID> instanceNames = ListInstances.getInstanceNames();
        System.out.println();
        ListInstances.printHeader();
        for (Map.Entry<String, UUID> entry : instanceNames.entrySet()) {
            ListInstances.printInstanceInfo(entry.getKey(), entry.getValue());
        }
        TreeSet<UUID> instancedIds = ListInstances.getInstanceIDs();
        instancedIds.removeAll(instanceNames.values());
        if (ListInstances.opts.printAll) {
            for (UUID uuid : instancedIds) {
                ListInstances.printInstanceInfo(null, uuid);
            }
        } else if (instancedIds.size() > 0) {
            System.out.println();
            System.out.println("INFO : " + instancedIds.size() + " unamed instances were not printed, run with --print-all to see all instances");
        } else {
            System.out.println();
        }
        if (!ListInstances.opts.printErrors && errors > 0) {
            System.err.println("WARN : There were " + errors + " errors, run with --print-errors to see more info");
        }
    }

    private static void printHeader() {
        System.out.printf(" %-20s| %-37s| %-30s%n", "Instance Name", "Instance ID", "Master");
        System.out.printf("%21s+%38s+%31s%n", new CharFiller('-'), new CharFiller('-'), new CharFiller('-'));
    }

    private static void printInstanceInfo(String instanceName, UUID iid) {
        String master = ListInstances.getMaster(iid);
        if (instanceName == null) {
            instanceName = "";
        }
        if (master == null) {
            master = "";
        }
        System.out.printf("%20s |%37s |%30s%n", "\"" + instanceName + "\"", iid, master);
    }

    private static String getMaster(UUID iid) {
        if (iid == null) {
            return null;
        }
        try {
            String masterLocPath = "/accumulo/" + iid + "/masters/lock";
            byte[] master = ZooLock.getLockData((String)masterLocPath);
            if (master == null) {
                return null;
            }
            return new String(master);
        }
        catch (Exception e) {
            ListInstances.handleException(e);
            return null;
        }
    }

    private static TreeMap<String, UUID> getInstanceNames() {
        List names;
        ZooReaderWriter zk = ZooReaderWriter.getInstance();
        String instancesPath = "/accumulo/instances";
        TreeMap<String, UUID> tm = new TreeMap<String, UUID>();
        try {
            names = zk.getChildren(instancesPath);
        }
        catch (Exception e) {
            ListInstances.handleException(e);
            return tm;
        }
        for (String name : names) {
            String instanceNamePath = "/accumulo/instances/" + name;
            try {
                UUID iid = UUID.fromString(new String(zk.getData(instanceNamePath, null)));
                tm.put(name, iid);
            }
            catch (Exception e) {
                ListInstances.handleException(e);
                tm.put(name, null);
            }
        }
        return tm;
    }

    private static TreeSet<UUID> getInstanceIDs() {
        TreeSet<UUID> ts = new TreeSet<UUID>();
        ZooReaderWriter zk = ZooReaderWriter.getInstance();
        try {
            List children = zk.getChildren("/accumulo");
            for (String iid : children) {
                if (iid.equals("instances")) continue;
                try {
                    ts.add(UUID.fromString(iid));
                }
                catch (Exception e) {
                    log.error((Object)("Exception: " + e));
                }
            }
        }
        catch (Exception e) {
            ListInstances.handleException(e);
        }
        return ts;
    }

    private static void handleException(Exception e) {
        if (ListInstances.opts.printErrors) {
            e.printStackTrace();
        }
        ++errors;
    }

    private static class CharFiller
    implements Formattable {
        char c;

        CharFiller(char c) {
            this.c = c;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < width; ++i) {
                sb.append(this.c);
            }
            formatter.format(sb.toString(), new Object[0]);
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"--print-errors"}, description="display errors while listing instances")
        boolean printErrors = false;
        @Parameter(names={"--print-all"}, description="print information for all instances, not just those with names")
        boolean printAll = false;
        @Parameter(names={"-z", "--zookeepers"}, description="the zookeepers to contact")
        String keepers = null;

        Opts() {
        }
    }
}

