/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import jline.ConsoleReader;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.security.SecurityUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.constraints.MetadataConstraints;
import org.apache.accumulo.server.iterators.MetadataBulkLoadFilter;
import org.apache.accumulo.server.master.state.tables.TableManager;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.util.ChangeSecret;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class Initialize {
    private static final Logger log = Logger.getLogger(Initialize.class);
    private static final String DEFAULT_ROOT_USER = "root";
    private static ConsoleReader reader = null;
    private static HashMap<String, String> initialMetadataConf = new HashMap();

    private static ConsoleReader getConsoleReader() throws IOException {
        if (reader == null) {
            reader = new ConsoleReader();
        }
        return reader;
    }

    public static boolean doInit(Opts opts, Configuration conf, FileSystem fs) throws IOException {
        String instanceNamePath;
        if (!ServerConfiguration.getSiteConfiguration().get(Property.INSTANCE_DFS_URI).equals("")) {
            log.info((Object)("Hadoop Filesystem is " + ServerConfiguration.getSiteConfiguration().get(Property.INSTANCE_DFS_URI)));
        } else {
            log.info((Object)("Hadoop Filesystem is " + FileSystem.getDefaultUri((Configuration)conf)));
        }
        log.info((Object)("Accumulo data dir is " + ServerConstants.getBaseDir()));
        log.info((Object)("Zookeeper server is " + ServerConfiguration.getSiteConfiguration().get(Property.INSTANCE_ZK_HOST)));
        log.info((Object)"Checking if Zookeeper is available. If this hangs, then you need to make sure zookeeper is running");
        if (!Initialize.zookeeperAvailable()) {
            log.fatal((Object)"Zookeeper needs to be up and running in order to init. Exiting ...");
            return false;
        }
        if (ServerConfiguration.getSiteConfiguration().get(Property.INSTANCE_SECRET).equals(Property.INSTANCE_SECRET.getDefaultValue())) {
            ConsoleReader c = Initialize.getConsoleReader();
            c.beep();
            c.printNewline();
            c.printNewline();
            c.printString("Warning!!! Your instance secret is still set to the default, this is not secure. We highly recommend you change it.");
            c.printNewline();
            c.printNewline();
            c.printNewline();
            c.printString("You can change the instance secret in accumulo by using:");
            c.printNewline();
            c.printString("   bin/accumulo " + ChangeSecret.class.getName() + " oldPassword newPassword.");
            c.printNewline();
            c.printString("You will also need to edit your secret in your configuration file by adding the property instance.secret to your conf/accumulo-site.xml. Without this accumulo will not operate correctly");
            c.printNewline();
        }
        try {
            if (Initialize.isInitialized(fs)) {
                log.fatal((Object)"It appears this location was previously initialized, exiting ... ");
                return false;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            instanceNamePath = Initialize.getInstanceNamePath(opts);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to talk to zookeeper", (Throwable)e);
            return false;
        }
        opts.rootpass = Initialize.getRootPassword(opts);
        return Initialize.initialize(opts, instanceNamePath, fs);
    }

    public static boolean initialize(Opts opts, String instanceNamePath, FileSystem fs) {
        UUID uuid = UUID.randomUUID();
        try {
            Initialize.initZooKeeper(opts, uuid.toString(), instanceNamePath);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to initialize zookeeper", (Throwable)e);
            return false;
        }
        try {
            Initialize.initFileSystem(opts, fs, fs.getConf(), uuid);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to initialize filesystem", (Throwable)e);
            return false;
        }
        try {
            Initialize.initSecurity(opts, uuid.toString());
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to initialize security", (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean zookeeperAvailable() {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            return zoo.exists("/");
        }
        catch (KeeperException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private static void initFileSystem(Opts opts, FileSystem fs, Configuration conf, UUID uuid) throws IOException {
        block15: {
            FileStatus fstat;
            Path defaultMetadataTablet;
            Path tableMetadataTablet;
            Path rootTablet;
            block13: {
                rootTablet = new Path(ServerConstants.getRootTabletDir());
                tableMetadataTablet = new Path(ServerConstants.getMetadataTableDir() + "/table_info");
                defaultMetadataTablet = new Path(ServerConstants.getMetadataTableDir() + "/default_tablet");
                Path metadataTableDir = new Path(ServerConstants.getMetadataTableDir());
                fs.mkdirs(new Path(ServerConstants.getDataVersionLocation(), "5"));
                fs.mkdirs(ServerConstants.getInstanceIdLocation());
                fs.createNewFile(new Path(ServerConstants.getInstanceIdLocation(), uuid.toString()));
                Initialize.initMetadataConfig();
                try {
                    fstat = fs.getFileStatus(metadataTableDir);
                    if (!fstat.isDir()) {
                        log.fatal((Object)("location " + metadataTableDir.toString() + " exists but is not a directory"));
                        return;
                    }
                }
                catch (FileNotFoundException fnfe) {
                    if (fs.mkdirs(metadataTableDir)) break block13;
                    log.fatal((Object)("unable to create directory " + metadataTableDir.toString()));
                    return;
                }
            }
            try {
                fstat = fs.getFileStatus(rootTablet);
                if (!fstat.isDir()) {
                    log.fatal((Object)("location " + rootTablet.toString() + " exists but is not a directory"));
                    return;
                }
            }
            catch (FileNotFoundException fnfe) {
                if (!fs.mkdirs(rootTablet)) {
                    log.fatal((Object)("unable to create directory " + rootTablet.toString()));
                    return;
                }
                String initRootTabFile = ServerConstants.getMetadataTableDir() + "/root_tablet/00000_00000." + FileOperations.getNewFileExtension((AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration());
                FileSKVWriter mfw = FileOperations.getInstance().openWriter(initRootTabFile, fs, conf, (AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration());
                mfw.startDefaultLocalityGroup();
                Text rootExtent = Constants.ROOT_TABLET_EXTENT.getMetadataEntry();
                Key rootDirKey = new Key(rootExtent, Constants.METADATA_DIRECTORY_COLUMN.getColumnFamily(), Constants.METADATA_DIRECTORY_COLUMN.getColumnQualifier(), 0L);
                mfw.append(rootDirKey, new Value("/root_tablet".getBytes()));
                Key rootPrevRowKey = new Key(rootExtent, Constants.METADATA_PREV_ROW_COLUMN.getColumnFamily(), Constants.METADATA_PREV_ROW_COLUMN.getColumnQualifier(), 0L);
                mfw.append(rootPrevRowKey, new Value(new byte[]{0}));
                Text tableExtent = new Text(KeyExtent.getMetadataEntry((Text)new Text("!0"), (Text)Constants.METADATA_RESERVED_KEYSPACE_START_KEY.getRow()));
                Key tableDirKey = new Key(tableExtent, Constants.METADATA_DIRECTORY_COLUMN.getColumnFamily(), Constants.METADATA_DIRECTORY_COLUMN.getColumnQualifier(), 0L);
                mfw.append(tableDirKey, new Value("/table_info".getBytes()));
                Key tableTimeKey = new Key(tableExtent, Constants.METADATA_TIME_COLUMN.getColumnFamily(), Constants.METADATA_TIME_COLUMN.getColumnQualifier(), 0L);
                mfw.append(tableTimeKey, new Value("L0".getBytes()));
                Key tablePrevRowKey = new Key(tableExtent, Constants.METADATA_PREV_ROW_COLUMN.getColumnFamily(), Constants.METADATA_PREV_ROW_COLUMN.getColumnQualifier(), 0L);
                mfw.append(tablePrevRowKey, KeyExtent.encodePrevEndRow((Text)new Text(KeyExtent.getMetadataEntry((Text)new Text("!0"), null))));
                Text defaultExtent = new Text(KeyExtent.getMetadataEntry((Text)new Text("!0"), null));
                Key defaultDirKey = new Key(defaultExtent, Constants.METADATA_DIRECTORY_COLUMN.getColumnFamily(), Constants.METADATA_DIRECTORY_COLUMN.getColumnQualifier(), 0L);
                mfw.append(defaultDirKey, new Value("/default_tablet".getBytes()));
                Key defaultTimeKey = new Key(defaultExtent, Constants.METADATA_TIME_COLUMN.getColumnFamily(), Constants.METADATA_TIME_COLUMN.getColumnQualifier(), 0L);
                mfw.append(defaultTimeKey, new Value("L0".getBytes()));
                Key defaultPrevRowKey = new Key(defaultExtent, Constants.METADATA_PREV_ROW_COLUMN.getColumnFamily(), Constants.METADATA_PREV_ROW_COLUMN.getColumnQualifier(), 0L);
                mfw.append(defaultPrevRowKey, KeyExtent.encodePrevEndRow((Text)Constants.METADATA_RESERVED_KEYSPACE_START_KEY.getRow()));
                mfw.close();
            }
            try {
                fstat = fs.getFileStatus(defaultMetadataTablet);
                if (!fstat.isDir()) {
                    log.fatal((Object)("location " + defaultMetadataTablet.toString() + " exists but is not a directory"));
                    return;
                }
            }
            catch (FileNotFoundException fnfe) {
                block14: {
                    try {
                        fstat = fs.getFileStatus(tableMetadataTablet);
                        if (!fstat.isDir()) {
                            log.fatal((Object)("location " + tableMetadataTablet.toString() + " exists but is not a directory"));
                            return;
                        }
                    }
                    catch (FileNotFoundException fnfe2) {
                        if (fs.mkdirs(tableMetadataTablet)) break block14;
                        log.fatal((Object)("unable to create directory " + tableMetadataTablet.toString()));
                        return;
                    }
                }
                if (fs.mkdirs(defaultMetadataTablet)) break block15;
                log.fatal((Object)("unable to create directory " + defaultMetadataTablet.toString()));
                return;
            }
        }
    }

    private static void initZooKeeper(Opts opts, String uuid, String instanceNamePath) throws KeeperException, InterruptedException {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        ZooUtil.putPersistentData((ZooKeeper)zoo.getZooKeeper(), (String)"/accumulo", (byte[])new byte[0], (int)-1, (ZooUtil.NodeExistsPolicy)ZooUtil.NodeExistsPolicy.SKIP, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        ZooUtil.putPersistentData((ZooKeeper)zoo.getZooKeeper(), (String)"/accumulo/instances", (byte[])new byte[0], (int)-1, (ZooUtil.NodeExistsPolicy)ZooUtil.NodeExistsPolicy.SKIP, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        if (opts.clearInstanceName) {
            zoo.recursiveDelete(instanceNamePath, ZooUtil.NodeMissingPolicy.SKIP);
        }
        zoo.putPersistentData(instanceNamePath, uuid.getBytes(), ZooUtil.NodeExistsPolicy.FAIL);
        String zkInstanceRoot = "/accumulo/" + uuid;
        zoo.putPersistentData(zkInstanceRoot, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tables", Constants.ZTABLES_INITIAL_ID, ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState(uuid, "!0", "!METADATA", TableState.ONLINE, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tservers", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/problems", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet/walogs", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tracers", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters/lock", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters/goal_state", MasterGoalState.NORMAL.toString().getBytes(), ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/gc", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/gc/lock", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/config", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/table_locks", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/hdfs_reservations", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/next_file", new byte[]{48}, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/recovery", new byte[]{48}, ZooUtil.NodeExistsPolicy.FAIL);
    }

    private static String getInstanceNamePath(Opts opts) throws IOException, KeeperException, InterruptedException {
        String instanceNamePath = null;
        boolean exists = true;
        do {
            String instanceName;
            if ((instanceName = opts.cliInstanceName == null ? Initialize.getConsoleReader().readLine("Instance name : ") : opts.cliInstanceName) == null) {
                System.exit(0);
            }
            if ((instanceName = instanceName.trim()).length() == 0) continue;
            instanceNamePath = "/accumulo/instances/" + instanceName;
            if (opts.clearInstanceName) {
                exists = false;
                break;
            }
            exists = ZooReaderWriter.getInstance().exists(instanceNamePath);
            if (!exists) continue;
            String decision = Initialize.getConsoleReader().readLine("Instance name \"" + instanceName + "\" exists. Delete existing entry from zookeeper? [Y/N] : ");
            if (decision == null) {
                System.exit(0);
            }
            if (decision.length() != 1 || decision.toLowerCase(Locale.ENGLISH).charAt(0) != 'y') continue;
            opts.clearInstanceName = true;
            exists = false;
        } while (exists);
        return instanceNamePath;
    }

    private static byte[] getRootPassword(Opts opts) throws IOException {
        String confirmpass;
        String rootpass;
        if (opts.cliPassword != null) {
            return opts.cliPassword.getBytes();
        }
        do {
            if ((rootpass = Initialize.getConsoleReader().readLine("Enter initial password for root (this may not be applicable for your security setup): ", Character.valueOf('*'))) == null) {
                System.exit(0);
            }
            if ((confirmpass = Initialize.getConsoleReader().readLine("Confirm initial password for root: ", Character.valueOf('*'))) == null) {
                System.exit(0);
            }
            if (rootpass.equals(confirmpass)) continue;
            log.error((Object)"Passwords do not match");
        } while (!rootpass.equals(confirmpass));
        return rootpass.getBytes();
    }

    private static void initSecurity(Opts opts, String iid) throws AccumuloSecurityException, ThriftSecurityException {
        AuditedSecurityOperation.getInstance(iid, true).initializeSecurity(SecurityConstants.getSystemCredentials(), DEFAULT_ROOT_USER, opts.rootpass);
    }

    protected static void initMetadataConfig() throws IOException {
        try {
            Configuration conf = CachedConfiguration.getInstance();
            int max = conf.getInt("dfs.replication.max", 512);
            int min = Math.max(conf.getInt("dfs.replication.min", 1), conf.getInt("dfs.namenode.replication.min", 1));
            if (max < 5) {
                Initialize.setMetadataReplication(max, "max");
            }
            if (min > 5) {
                Initialize.setMetadataReplication(min, "min");
            }
            for (Map.Entry<String, String> entry : initialMetadataConf.entrySet()) {
                if (TablePropUtil.setTableProperty("!0", entry.getKey(), entry.getValue())) continue;
                throw new IOException("Cannot create per-table property " + entry.getKey());
            }
        }
        catch (Exception e) {
            log.fatal((Object)"error talking to zookeeper", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static void setMetadataReplication(int replication, String reason) throws IOException {
        String rep = Initialize.getConsoleReader().readLine("Your HDFS replication " + reason + " is not compatible with our default !METADATA replication of 5. What do you want to set your !METADATA replication to? (" + replication + ") ");
        if (rep == null || rep.length() == 0) {
            rep = Integer.toString(replication);
        } else {
            Integer.parseInt(rep);
        }
        initialMetadataConf.put(Property.TABLE_FILE_REPLICATION.getKey(), rep);
    }

    public static boolean isInitialized(FileSystem fs) throws IOException {
        return fs.exists(ServerConstants.getInstanceIdLocation()) || fs.exists(ServerConstants.getDataVersionLocation());
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(Initialize.class.getName(), args, new Object[0]);
        try {
            SecurityUtil.serverLogin();
            Configuration conf = CachedConfiguration.getInstance();
            FileSystem fs = FileUtil.getFileSystem((Configuration)conf, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
            if (opts.resetSecurity) {
                if (Initialize.isInitialized(fs)) {
                    opts.rootpass = Initialize.getRootPassword(opts);
                    Initialize.initSecurity(opts, HdfsZooInstance.getInstance().getInstanceID());
                } else {
                    log.fatal((Object)"Attempted to reset security on accumulo before it was initialized");
                }
            } else if (!Initialize.doInit(opts, conf, fs)) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            log.fatal((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        initialMetadataConf.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "32K");
        initialMetadataConf.put(Property.TABLE_FILE_REPLICATION.getKey(), "5");
        initialMetadataConf.put(Property.TABLE_WALOG_ENABLED.getKey(), "true");
        initialMetadataConf.put(Property.TABLE_MAJC_RATIO.getKey(), "1");
        initialMetadataConf.put(Property.TABLE_SPLIT_THRESHOLD.getKey(), "64M");
        initialMetadataConf.put(Property.TABLE_CONSTRAINT_PREFIX.getKey() + "1", MetadataConstraints.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.bulkLoadFilter", "20," + MetadataBulkLoadFilter.class.getName());
        initialMetadataConf.put(Property.TABLE_FAILURES_IGNORE.getKey(), "false");
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "tablet", String.format("%s,%s", Constants.METADATA_TABLET_COLUMN_FAMILY.toString(), Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY.toString()));
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "server", String.format("%s,%s,%s,%s", Constants.METADATA_DATAFILE_COLUMN_FAMILY.toString(), Constants.METADATA_LOG_COLUMN_FAMILY.toString(), Constants.METADATA_SERVER_COLUMN_FAMILY.toString(), Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY.toString()));
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUPS.getKey(), "tablet,server");
        initialMetadataConf.put(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey(), "");
        initialMetadataConf.put(Property.TABLE_INDEXCACHE_ENABLED.getKey(), "true");
        initialMetadataConf.put(Property.TABLE_BLOCKCACHE_ENABLED.getKey(), "true");
    }

    static class Opts
    extends Help {
        @Parameter(names={"--reset-security"}, description="just update the security information")
        boolean resetSecurity = false;
        @Parameter(names={"--clear-instance-name"}, description="delete any existing instance name without prompting")
        boolean clearInstanceName = false;
        @Parameter(names={"--instance-name"}, description="the instance name, if not provided, will prompt")
        String cliInstanceName;
        @Parameter(names={"--password"}, description="set the password on the command line")
        String cliPassword;
        @Parameter(names={"--username"}, description="set the root username on the command line")
        String cliUser;
        byte[] rootpass = null;

        Opts() {
        }
    }
}

