/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.problems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.Encoding;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.io.Text;

public class ProblemReport {
    private String tableName;
    private ProblemType problemType;
    private String resource;
    private String exception;
    private String server;
    private long creationTime;

    public ProblemReport(String table, ProblemType problemType, String resource, String server, Throwable e) {
        this.tableName = table;
        this.problemType = problemType;
        this.resource = resource;
        if (e != null) {
            this.exception = e.getMessage();
        }
        if (server == null) {
            try {
                server = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e1) {
                // empty catch block
            }
        }
        this.server = server;
        this.creationTime = System.currentTimeMillis();
    }

    public ProblemReport(String table, ProblemType problemType, String resource, Throwable e) {
        this(table, problemType, resource, null, e);
    }

    private ProblemReport(String table, ProblemType problemType, String resource, byte[] enc) throws IOException {
        this.tableName = table;
        this.problemType = problemType;
        this.resource = resource;
        this.decode(enc);
    }

    private byte[] encode() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeLong(this.creationTime);
        dos.writeBoolean(this.server != null);
        if (this.server != null) {
            dos.writeUTF(this.server);
        }
        dos.writeBoolean(this.exception != null);
        if (this.exception != null) {
            dos.writeUTF(this.exception);
        }
        dos.close();
        baos.close();
        return baos.toByteArray();
    }

    private void decode(byte[] enc) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(enc);
        DataInputStream dis = new DataInputStream(bais);
        this.creationTime = dis.readLong();
        this.server = dis.readBoolean() ? dis.readUTF() : null;
        this.exception = dis.readBoolean() ? dis.readUTF() : null;
    }

    void removeFromMetadataTable() throws Exception {
        Mutation m = new Mutation(new Text("~err_" + this.tableName));
        m.putDelete(new Text(this.problemType.name()), new Text(this.resource));
        MetadataTable.getMetadataTable(SecurityConstants.getSystemCredentials()).update(m);
    }

    void saveToMetadataTable() throws Exception {
        Mutation m = new Mutation(new Text("~err_" + this.tableName));
        m.put(new Text(this.problemType.name()), new Text(this.resource), new Value(this.encode()));
        MetadataTable.getMetadataTable(SecurityConstants.getSystemCredentials()).update(m);
    }

    void removeFromZooKeeper() throws Exception {
        String zpath = this.getZPath();
        ZooReaderWriter.getInstance().recursiveDelete(zpath, ZooUtil.NodeMissingPolicy.SKIP);
    }

    void saveToZooKeeper() throws Exception {
        ZooReaderWriter.getInstance().putPersistentData(this.getZPath(), this.encode(), ZooUtil.NodeExistsPolicy.OVERWRITE);
    }

    private String getZPath() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(this.getTableName());
        dos.writeUTF(this.getProblemType().name());
        dos.writeUTF(this.getResource());
        dos.close();
        baos.close();
        String zpath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/problems" + "/" + Encoding.encodeAsBase64FileName((Text)new Text(baos.toByteArray()));
        return zpath;
    }

    static ProblemReport decodeZooKeeperEntry(String node) throws Exception {
        byte[] bytes = Encoding.decodeBase64FileName((String)node);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        String tableName = dis.readUTF();
        String problemType = dis.readUTF();
        String resource = dis.readUTF();
        String zpath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/problems" + "/" + node;
        byte[] enc = ZooReaderWriter.getInstance().getData(zpath, null);
        return new ProblemReport(tableName, ProblemType.valueOf(problemType), resource, enc);
    }

    public static ProblemReport decodeMetadataEntry(Map.Entry<Key, Value> entry) throws IOException {
        String tableName = entry.getKey().getRow().toString().substring("~err_".length());
        String problemType = entry.getKey().getColumnFamily().toString();
        String resource = entry.getKey().getColumnQualifier().toString();
        return new ProblemReport(tableName, ProblemType.valueOf(problemType), resource, entry.getValue().get());
    }

    public String getTableName() {
        return this.tableName;
    }

    public ProblemType getProblemType() {
        return this.problemType;
    }

    public String getResource() {
        return this.resource;
    }

    public String getException() {
        return this.exception;
    }

    public String getServer() {
        return this.server;
    }

    public long getTime() {
        return this.creationTime;
    }

    public int hashCode() {
        return this.tableName.hashCode() + this.problemType.hashCode() + this.resource.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ProblemReport) {
            ProblemReport opr = (ProblemReport)o;
            return this.tableName.equals(opr.tableName) && this.problemType.equals((Object)opr.problemType) && this.resource.equals(opr.resource);
        }
        return false;
    }
}

