/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSnapshotMetrics {
    private static final long seed = 0L;
    private static final short REPLICATION = 3;
    private static final String NN_METRICS = "NameNodeActivity";
    private static final String NS_METRICS = "FSNamesystem";
    private final Path dir = new Path("/TestSnapshot");
    private final Path sub1 = new Path(this.dir, "sub1");
    private final Path file1 = new Path(this.sub1, "file1");
    private final Path file2 = new Path(this.sub1, "file2");
    private Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem hdfs;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.hdfs = this.cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file2, 1024L, (short)3, 0L);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testSnapshottableDirs() throws Exception {
        this.cluster.getNamesystem().getSnapshotManager().setAllowNestedSnapshots(true);
        MetricsAsserts.assertGauge((String)"SnapshottableDirectories", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"AllowSnapshotOps", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        MetricsAsserts.assertCounter((String)"DisallowSnapshotOps", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.hdfs.allowSnapshot(this.sub1);
        MetricsAsserts.assertGauge((String)"SnapshottableDirectories", (int)1, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"AllowSnapshotOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        Path sub2 = new Path(this.dir, "sub2");
        Path file = new Path(sub2, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file, 1024L, (short)3, 0L);
        this.hdfs.allowSnapshot(sub2);
        MetricsAsserts.assertGauge((String)"SnapshottableDirectories", (int)2, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"AllowSnapshotOps", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        Path subsub1 = new Path(this.sub1, "sub1sub1");
        Path subfile = new Path(subsub1, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, subfile, 1024L, (short)3, 0L);
        this.hdfs.allowSnapshot(subsub1);
        MetricsAsserts.assertGauge((String)"SnapshottableDirectories", (int)3, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"AllowSnapshotOps", (long)3L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.hdfs.allowSnapshot(this.sub1);
        MetricsAsserts.assertGauge((String)"SnapshottableDirectories", (int)3, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"AllowSnapshotOps", (long)4L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.hdfs.disallowSnapshot(this.sub1);
        MetricsAsserts.assertGauge((String)"SnapshottableDirectories", (int)2, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"DisallowSnapshotOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.hdfs.delete(subsub1, true);
        MetricsAsserts.assertGauge((String)"SnapshottableDirectories", (int)1, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        SnapshottableDirectoryStatus[] status = this.hdfs.getSnapshottableDirListing();
        Assert.assertEquals((long)1L, (long)status.length);
        MetricsAsserts.assertCounter((String)"ListSnapshottableDirOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
    }

    @Test
    public void testSnapshots() throws Exception {
        this.cluster.getNamesystem().getSnapshotManager().setAllowNestedSnapshots(true);
        MetricsAsserts.assertGauge((String)"Snapshots", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"CreateSnapshotOps", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        try {
            this.hdfs.createSnapshot(this.sub1, "s1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MetricsAsserts.assertGauge((String)"Snapshots", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"CreateSnapshotOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.hdfs.allowSnapshot(this.sub1);
        this.hdfs.createSnapshot(this.sub1, "s1");
        MetricsAsserts.assertGauge((String)"Snapshots", (int)1, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"CreateSnapshotOps", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.hdfs.createSnapshot(this.sub1, "s2");
        MetricsAsserts.assertGauge((String)"Snapshots", (int)2, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"CreateSnapshotOps", (long)3L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.hdfs.getSnapshotDiffReport(this.sub1, "s1", "s2");
        MetricsAsserts.assertCounter((String)"SnapshotDiffReportOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        Path subsub1 = new Path(this.sub1, "sub1sub1");
        Path subfile = new Path(subsub1, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, subfile, 1024L, (short)3, 0L);
        this.hdfs.allowSnapshot(subsub1);
        this.hdfs.createSnapshot(subsub1, "s11");
        MetricsAsserts.assertGauge((String)"Snapshots", (int)3, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"CreateSnapshotOps", (long)4L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.hdfs.deleteSnapshot(this.sub1, "s2");
        MetricsAsserts.assertGauge((String)"Snapshots", (int)2, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"DeleteSnapshotOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.hdfs.renameSnapshot(this.sub1, "s1", "NewS1");
        MetricsAsserts.assertGauge((String)"Snapshots", (int)2, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertCounter((String)"RenameSnapshotOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
    }
}

