/*
 * Decompiled with CFR 0.152.
 */
package py4j.model;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import py4j.model.Py4JField;
import py4j.model.Py4JMember;
import py4j.model.Py4JMethod;
import py4j.reflection.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Py4JClass
extends Py4JMember {
    private final String extendType;
    private final String[] implementTypes;
    private final Py4JMethod[] methods;
    private final Py4JField[] fields;
    private final Py4JClass[] classes;

    public static final Py4JClass buildClass(Class<?> clazz) {
        return Py4JClass.buildClass(clazz, true);
    }

    public static final Py4JClass buildClass(Class<?> clazz, boolean sort) {
        Class<?>[] interfaces;
        String[] stringArray;
        ArrayList<Py4JClass> classes = new ArrayList<Py4JClass>();
        ArrayList<Py4JMethod> methods = new ArrayList<Py4JMethod>();
        ArrayList<Py4JField> fields = new ArrayList<Py4JField>();
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            if (!Modifier.isPublic(clazz2.getModifiers())) continue;
            classes.add(Py4JClass.buildClass(clazz2, sort));
        }
        for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(((Method)genericDeclaration).getModifiers())) continue;
            methods.add(Py4JMethod.buildMethod((Method)genericDeclaration));
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            if (!Modifier.isPublic(((Field)annotatedElement).getModifiers())) continue;
            fields.add(Py4JField.buildField((Field)annotatedElement));
        }
        Class<?> superClass = clazz.getSuperclass();
        String extend = null;
        if (superClass != null && superClass != Object.class) {
            extend = superClass.getCanonicalName();
        }
        String[] stringArray2 = stringArray = (interfaces = clazz.getInterfaces()) != null && interfaces.length > 0 ? TypeUtil.getNames(interfaces) : null;
        if (sort) {
            Collections.sort(classes);
            Collections.sort(methods);
            Collections.sort(fields);
        }
        return new Py4JClass(clazz.getCanonicalName(), null, extend, stringArray, methods.toArray(new Py4JMethod[0]), fields.toArray(new Py4JField[0]), classes.toArray(new Py4JClass[0]));
    }

    public Py4JClass(String name, String javadoc, String extendType, String[] implementTypes, Py4JMethod[] methods, Py4JField[] fields, Py4JClass[] classes) {
        super(name, javadoc);
        this.extendType = extendType;
        this.implementTypes = implementTypes;
        this.methods = methods;
        this.fields = fields;
        this.classes = classes;
    }

    public Py4JClass[] getClasses() {
        return this.classes;
    }

    public String getExtendType() {
        return this.extendType;
    }

    public Py4JField[] getFields() {
        return this.fields;
    }

    public String[] getImplementTypes() {
        return this.implementTypes;
    }

    public Py4JMethod[] getMethods() {
        return this.methods;
    }

    @Override
    public String getSignature(boolean shortName) {
        StringBuilder builder = new StringBuilder();
        builder.append(TypeUtil.getName(this.getName(), shortName));
        if (this.extendType != null) {
            builder.append(" extends ");
            builder.append(this.extendType);
        }
        if (this.implementTypes != null) {
            builder.append(" implements ");
            int length = this.implementTypes.length;
            for (int i = 0; i < length - 1; ++i) {
                builder.append(this.implementTypes[i]);
                builder.append(", ");
            }
            builder.append(this.implementTypes[length - 1]);
        }
        return builder.toString();
    }
}

