/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.annotations.VisibleForTesting;
import org.spark-project.guava.collect.Lists;

public class ExternalShuffleBlockHandler
extends RpcHandler {
    private final Logger logger = LoggerFactory.getLogger(ExternalShuffleBlockHandler.class);
    @VisibleForTesting
    final ExternalShuffleBlockResolver blockManager;
    private final OneForOneStreamManager streamManager;

    public ExternalShuffleBlockHandler(TransportConf conf, File registeredExecutorFile) throws IOException {
        this(new OneForOneStreamManager(), new ExternalShuffleBlockResolver(conf, registeredExecutorFile));
    }

    @VisibleForTesting
    public ExternalShuffleBlockHandler(OneForOneStreamManager streamManager, ExternalShuffleBlockResolver blockManager) {
        this.streamManager = streamManager;
        this.blockManager = blockManager;
    }

    public void receive(TransportClient client, ByteBuffer message, RpcResponseCallback callback) {
        BlockTransferMessage msgObj = BlockTransferMessage.Decoder.fromByteBuffer(message);
        this.handleMessage(msgObj, client, callback);
    }

    protected void handleMessage(BlockTransferMessage msgObj, TransportClient client, RpcResponseCallback callback) {
        if (msgObj instanceof OpenBlocks) {
            OpenBlocks msg = (OpenBlocks)msgObj;
            this.checkAuth(client, msg.appId);
            ArrayList blocks = Lists.newArrayList();
            for (String blockId : msg.blockIds) {
                blocks.add(this.blockManager.getBlockData(msg.appId, msg.execId, blockId));
            }
            long streamId = this.streamManager.registerStream(client.getClientId(), blocks.iterator());
            this.logger.trace("Registered streamId {} with {} buffers", (Object)streamId, (Object)msg.blockIds.length);
            callback.onSuccess(new StreamHandle(streamId, msg.blockIds.length).toByteBuffer());
        } else if (msgObj instanceof RegisterExecutor) {
            RegisterExecutor msg = (RegisterExecutor)msgObj;
            this.checkAuth(client, msg.appId);
            this.blockManager.registerExecutor(msg.appId, msg.execId, msg.executorInfo);
            callback.onSuccess(ByteBuffer.wrap(new byte[0]));
        } else {
            throw new UnsupportedOperationException("Unexpected message: " + msgObj);
        }
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    public void applicationRemoved(String appId, boolean cleanupLocalDirs) {
        this.blockManager.applicationRemoved(appId, cleanupLocalDirs);
    }

    public void reregisterExecutor(ExternalShuffleBlockResolver.AppExecId appExecId, ExecutorShuffleInfo executorInfo) {
        this.blockManager.registerExecutor(appExecId.appId, appExecId.execId, executorInfo);
    }

    public void close() {
        this.blockManager.close();
    }

    private void checkAuth(TransportClient client, String appId) {
        if (client.getClientId() != null && !client.getClientId().equals(appId)) {
            throw new SecurityException(String.format("Client for %s not authorized for application %s.", client.getClientId(), appId));
        }
    }
}

