/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.Vertex;

@InterfaceAudience.Public
public class Edge {
    private final Vertex inputVertex;
    private final Vertex outputVertex;
    private final EdgeProperty edgeProperty;

    private Edge(Vertex inputVertex, Vertex outputVertex, EdgeProperty edgeProperty) {
        this.inputVertex = inputVertex;
        this.outputVertex = outputVertex;
        this.edgeProperty = edgeProperty;
    }

    public static Edge create(Vertex inputVertex, Vertex outputVertex, EdgeProperty edgeProperty) {
        return new Edge(inputVertex, outputVertex, edgeProperty);
    }

    public Vertex getInputVertex() {
        return this.inputVertex;
    }

    public Vertex getOutputVertex() {
        return this.outputVertex;
    }

    public EdgeProperty getEdgeProperty() {
        return this.edgeProperty;
    }

    @InterfaceAudience.Private
    public String getId() {
        return String.valueOf(System.identityHashCode(this));
    }

    public String toString() {
        return this.inputVertex + " -> " + this.outputVertex + " (" + this.edgeProperty + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inputVertex == null ? 0 : this.inputVertex.hashCode());
        result = 31 * result + (this.outputVertex == null ? 0 : this.outputVertex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this.inputVertex == null ? other.inputVertex != null : !this.inputVertex.equals(other.inputVertex)) {
            return false;
        }
        return !(this.outputVertex == null ? other.outputVertex != null : !this.outputVertex.equals(other.outputVertex));
    }
}

