/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListener$class;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockUIData;
import org.apache.spark.storage.ExecutorStreamBlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00054Q!\u0001\u0002\u0001\t)\u00111C\u00117pG.\u001cF/\u0019;vg2K7\u000f^3oKJT!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003%\u00198\r[3ek2,'/\u0003\u0002\u0017'\ti1\u000b]1sW2K7\u000f^3oKJDQ\u0001\u0007\u0001\u0005\u0002i\ta\u0001P5oSRt4\u0001\u0001\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001b\u0001\n\u0013y\u0012!\u00042m_\u000e\\W*\u00198bO\u0016\u00148/F\u0001!!\u0011\tc\u0005K\u0016\u000e\u0003\tR!a\t\u0013\u0002\u000f5,H/\u00192mK*\u0011Q%D\u0001\u000bG>dG.Z2uS>t\u0017BA\u0014#\u0005\u001dA\u0015m\u001d5NCB\u0004\"\u0001H\u0015\n\u0005)\u0012!A\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\t\u0005C\u0019bs\u0006\u0005\u0002\u001d[%\u0011aF\u0001\u0002\b\u00052|7m[%e!\ta\u0002'\u0003\u00022\u0005\tY!\t\\8dWVKE)\u0019;b\u0011\u0019\u0019\u0004\u0001)A\u0005A\u0005q!\r\\8dW6\u000bg.Y4feN\u0004\u0003\"B\u001b\u0001\t\u00032\u0014AD8o\u00052|7m[+qI\u0006$X\r\u001a\u000b\u0003oi\u0002\"\u0001\u0004\u001d\n\u0005ej!\u0001B+oSRDQa\u000f\u001bA\u0002q\nAB\u00197pG.,\u0006\u000fZ1uK\u0012\u0004\"AE\u001f\n\u0005y\u001a\"!G*qCJ\\G*[:uK:,'O\u00117pG.,\u0006\u000fZ1uK\u0012DQ\u0001\u0011\u0001\u0005B\u0005\u000b1c\u001c8CY>\u001c7.T1oC\u001e,'/\u00113eK\u0012$\"a\u000e\"\t\u000b\r{\u0004\u0019\u0001#\u0002#\tdwnY6NC:\fw-\u001a:BI\u0012,G\r\u0005\u0002\u0013\u000b&\u0011ai\u0005\u0002\u001f'B\f'o\u001b'jgR,g.\u001a:CY>\u001c7.T1oC\u001e,'/\u00113eK\u0012DQ\u0001\u0013\u0001\u0005B%\u000bQc\u001c8CY>\u001c7.T1oC\u001e,'OU3n_Z,G\r\u0006\u00028\u0015\")1j\u0012a\u0001\u0019\u0006\u0019\"\r\\8dW6\u000bg.Y4feJ+Wn\u001c<fIB\u0011!#T\u0005\u0003\u001dN\u0011\u0001e\u00159be.d\u0015n\u001d;f]\u0016\u0014(\t\\8dW6\u000bg.Y4feJ+Wn\u001c<fI\")\u0001\u000b\u0001C\u0001#\u0006a\u0012\r\u001c7Fq\u0016\u001cW\u000f^8s'R\u0014X-Y7CY>\u001c7n\u0015;biV\u001cX#\u0001*\u0011\u0007M[fL\u0004\u0002U3:\u0011Q\u000bW\u0007\u0002-*\u0011q+G\u0001\u0007yI|w\u000e\u001e \n\u00039I!AW\u0007\u0002\u000fA\f7m[1hK&\u0011A,\u0018\u0002\u0004'\u0016\f(B\u0001.\u000e!\tar,\u0003\u0002a\u0005\tIR\t_3dkR|'o\u0015;sK\u0006l'\t\\8dWN#\u0018\r^;t\u0001")
public class BlockStatusListener
implements SparkListener {
    private final HashMap<BlockManagerId, HashMap<BlockId, BlockUIData>> blockManagers;

    @Override
    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        SparkListener$class.onStageCompleted(this, stageCompleted);
    }

    @Override
    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        SparkListener$class.onStageSubmitted(this, stageSubmitted);
    }

    @Override
    public void onTaskStart(SparkListenerTaskStart taskStart) {
        SparkListener$class.onTaskStart(this, taskStart);
    }

    @Override
    public void onTaskGettingResult(SparkListenerTaskGettingResult taskGettingResult) {
        SparkListener$class.onTaskGettingResult(this, taskGettingResult);
    }

    @Override
    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        SparkListener$class.onTaskEnd(this, taskEnd);
    }

    @Override
    public void onJobStart(SparkListenerJobStart jobStart) {
        SparkListener$class.onJobStart(this, jobStart);
    }

    @Override
    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        SparkListener$class.onJobEnd(this, jobEnd);
    }

    @Override
    public void onEnvironmentUpdate(SparkListenerEnvironmentUpdate environmentUpdate) {
        SparkListener$class.onEnvironmentUpdate(this, environmentUpdate);
    }

    @Override
    public void onUnpersistRDD(SparkListenerUnpersistRDD unpersistRDD) {
        SparkListener$class.onUnpersistRDD(this, unpersistRDD);
    }

    @Override
    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
        SparkListener$class.onApplicationStart(this, applicationStart);
    }

    @Override
    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        SparkListener$class.onApplicationEnd(this, applicationEnd);
    }

    @Override
    public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate executorMetricsUpdate) {
        SparkListener$class.onExecutorMetricsUpdate(this, executorMetricsUpdate);
    }

    @Override
    public void onExecutorAdded(SparkListenerExecutorAdded executorAdded2) {
        SparkListener$class.onExecutorAdded(this, executorAdded2);
    }

    @Override
    public void onExecutorRemoved(SparkListenerExecutorRemoved executorRemoved2) {
        SparkListener$class.onExecutorRemoved(this, executorRemoved2);
    }

    private HashMap<BlockManagerId, HashMap<BlockId, BlockUIData>> blockManagers() {
        return this.blockManagers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onBlockUpdated(SparkListenerBlockUpdated blockUpdated) {
        BlockId blockId = blockUpdated.blockUpdatedInfo().blockId();
        if (!(blockId instanceof StreamBlockId)) return;
        BlockManagerId blockManagerId = blockUpdated.blockUpdatedInfo().blockManagerId();
        StorageLevel storageLevel = blockUpdated.blockUpdatedInfo().storageLevel();
        long memSize = blockUpdated.blockUpdatedInfo().memSize();
        long diskSize = blockUpdated.blockUpdatedInfo().diskSize();
        long externalBlockStoreSize = blockUpdated.blockUpdatedInfo().externalBlockStoreSize();
        BlockStatusListener blockStatusListener = this;
        synchronized (blockStatusListener) {
            this.blockManagers().get((Object)blockManagerId).foreach((Function1)new Serializable(this, blockId, blockManagerId, storageLevel, memSize, diskSize, externalBlockStoreSize){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$1;
                private final BlockManagerId blockManagerId$1;
                private final StorageLevel storageLevel$1;
                private final long memSize$1;
                private final long diskSize$1;
                private final long externalBlockStoreSize$1;

                public final Serializable apply(HashMap<BlockId, BlockUIData> blocksInBlockManager) {
                    return this.storageLevel$1.isValid() ? blocksInBlockManager.put((Object)this.blockId$1, (Object)new BlockUIData(this.blockId$1, this.blockManagerId$1.hostPort(), this.storageLevel$1, this.memSize$1, this.diskSize$1, this.externalBlockStoreSize$1)) : blocksInBlockManager.$minus$eq((Object)this.blockId$1);
                }
                {
                    this.blockId$1 = blockId$1;
                    this.blockManagerId$1 = blockManagerId$1;
                    this.storageLevel$1 = storageLevel$1;
                    this.memSize$1 = memSize$1;
                    this.diskSize$1 = diskSize$1;
                    this.externalBlockStoreSize$1 = externalBlockStoreSize$1;
                }
            });
            return;
        }
    }

    @Override
    public void onBlockManagerAdded(SparkListenerBlockManagerAdded blockManagerAdded) {
        BlockStatusListener blockStatusListener = this;
        synchronized (blockStatusListener) {
            this.blockManagers().put((Object)blockManagerAdded.blockManagerId(), (Object)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
            return;
        }
    }

    @Override
    public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved blockManagerRemoved) {
        BlockStatusListener blockStatusListener = this;
        synchronized (blockStatusListener) {
            this.blockManagers().$minus$eq((Object)blockManagerRemoved.blockManagerId());
            return;
        }
    }

    public synchronized Seq<ExecutorStreamBlockStatus> allExecutorStreamBlockStatus() {
        return ((TraversableOnce)this.blockManagers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ExecutorStreamBlockStatus apply(Tuple2<BlockManagerId, HashMap<BlockId, BlockUIData>> x0$1) {
                Tuple2<BlockManagerId, HashMap<BlockId, BlockUIData>> tuple2 = x0$1;
                if (tuple2 != null) {
                    BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                    HashMap blocks = (HashMap)tuple2._2();
                    ExecutorStreamBlockStatus executorStreamBlockStatus = new ExecutorStreamBlockStatus(blockManagerId.executorId(), blockManagerId.hostPort(), (Seq<BlockUIData>)blocks.values().toSeq());
                    return executorStreamBlockStatus;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public BlockStatusListener() {
        SparkListener$class.$init$(this);
        this.blockManagers = new HashMap();
    }
}

