/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import org.apache.spark.shuffle.sort.PackedRecordPointer;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.collection.SortDataFormat;

final class ShuffleSortDataFormat
extends SortDataFormat<PackedRecordPointer, LongArray> {
    public static final ShuffleSortDataFormat INSTANCE = new ShuffleSortDataFormat();

    private ShuffleSortDataFormat() {
    }

    @Override
    public PackedRecordPointer getKey(LongArray data, int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PackedRecordPointer newKey() {
        return new PackedRecordPointer();
    }

    @Override
    public PackedRecordPointer getKey(LongArray data, int pos, PackedRecordPointer reuse) {
        reuse.set(data.get(pos));
        return reuse;
    }

    @Override
    public void swap(LongArray data, int pos0, int pos1) {
        long temp = data.get(pos0);
        data.set(pos0, data.get(pos1));
        data.set(pos1, temp);
    }

    @Override
    public void copyElement(LongArray src, int srcPos, LongArray dst, int dstPos) {
        dst.set(dstPos, src.get(srcPos));
    }

    @Override
    public void copyRange(LongArray src, int srcPos, LongArray dst, int dstPos, int length) {
        Platform.copyMemory((Object)src.getBaseObject(), (long)(src.getBaseOffset() + (long)(srcPos * 8)), (Object)dst.getBaseObject(), (long)(dst.getBaseOffset() + (long)(dstPos * 8)), (long)(length * 8));
    }

    @Override
    public LongArray allocate(int length) {
        return new LongArray(MemoryBlock.fromLongArray((long[])new long[length]));
    }
}

