/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.nio.ByteBuffer;
import org.apache.spark.Accumulator;
import org.apache.spark.Partition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.Task;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.serializer.SerializerInstance;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea!B\u0001\u0003\u0001\u0011Q!A\u0003*fgVdG\u000fV1tW*\u00111\u0001B\u0001\ng\u000eDW\rZ;mKJT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u000b\u0004\u0017!\u00142c\u0001\u0001\r?A\u0019QB\u0004\t\u000e\u0003\tI!a\u0004\u0002\u0003\tQ\u000b7o\u001b\t\u0003#Ia\u0001\u0001B\u0003\u0014\u0001\t\u0007QCA\u0001V\u0007\u0001\t\"A\u0006\u000f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u000f9{G\u000f[5oOB\u0011q#H\u0005\u0003=a\u00111!\u00118z!\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0002j_*\tA%\u0001\u0003kCZ\f\u0017B\u0001\u0014\"\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011%A\u0003A!A!\u0002\u0013IC&A\u0004ti\u0006<W-\u00133\u0011\u0005]Q\u0013BA\u0016\u0019\u0005\rIe\u000e^\u0005\u0003Q9A\u0011B\f\u0001\u0003\u0002\u0003\u0006I!K\u0018\u0002\u001dM$\u0018mZ3BiR,W\u000e\u001d;JI&\u0011aF\u0004\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005QA/Y:l\u0005&t\u0017M]=\u0011\u0007M2\u0004(D\u00015\u0015\t)D!A\u0005ce>\fGmY1ti&\u0011q\u0007\u000e\u0002\n\u0005J|\u0017\rZ2bgR\u00042aF\u001d<\u0013\tQ\u0004DA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0018y%\u0011Q\b\u0007\u0002\u0005\u0005f$X\r\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0002B\u00056\tA!\u0003\u0002D\t\tI\u0001+\u0019:uSRLwN\u001c\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\u0006!An\\2t!\r9uJ\u0015\b\u0003\u00116s!!\u0013'\u000e\u0003)S!a\u0013\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012B\u0001(\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001U)\u0003\u0007M+\u0017O\u0003\u0002O1A\u0011QbU\u0005\u0003)\n\u0011A\u0002V1tW2{7-\u0019;j_:D\u0001B\u0016\u0001\u0003\u0006\u0004%\taV\u0001\t_V$\b/\u001e;JIV\t\u0011\u0006\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003*\u0003%yW\u000f\u001e9vi&#\u0007\u0005\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u0003QIg\u000e^3s]\u0006d\u0017iY2v[Vd\u0017\r^8sgB\u0019qiT/\u0011\u0007\u0005s\u0006-\u0003\u0002`\t\tY\u0011iY2v[Vd\u0017\r^8s!\t9\u0012-\u0003\u0002c1\t!Aj\u001c8h\u0011\u0015!\u0007\u0001\"\u0001f\u0003\u0019a\u0014N\\5u}QAaM[6m[:|\u0007\u000f\u0005\u0003\u000e\u0001\u001d\u0004\u0002CA\ti\t\u0015I\u0007A1\u0001\u0016\u0005\u0005!\u0006\"\u0002\u0015d\u0001\u0004I\u0003\"\u0002\u0018d\u0001\u0004I\u0003\"B\u0019d\u0001\u0004\u0011\u0004\"B d\u0001\u0004\u0001\u0005\"B#d\u0001\u00041\u0005\"\u0002,d\u0001\u0004I\u0003\"B.d\u0001\u0004a\u0006B\u0002:\u0001A\u0003%a)A\u0007qe\u00164WM\u001d:fI2{7m\u001d\u0015\u0003cR\u0004\"aF;\n\u0005YD\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u0015A\b\u0001\"\u0011z\u0003\u001d\u0011XO\u001c+bg.$\"\u0001\u0005>\t\u000bm<\b\u0019\u0001?\u0002\u000f\r|g\u000e^3yiB\u0011\u0011)`\u0005\u0003}\u0012\u00111\u0002V1tW\u000e{g\u000e^3yi\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0011A\u00059sK\u001a,'O]3e\u0019>\u001c\u0017\r^5p]N,\u0012A\u0012\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0003!!xn\u0015;sS:<GCAA\u0006!\u0011\ti!a\u0005\u000f\u0007]\ty!C\u0002\u0002\u0012a\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u000b\u0003/\u0011aa\u0015;sS:<'bAA\t1\u0001")
public class ResultTask<T, U>
extends Task<U> {
    private final Broadcast<byte[]> taskBinary;
    private final Partition partition;
    private final int outputId;
    private final transient Seq<TaskLocation> preferredLocs;

    public int outputId() {
        return this.outputId;
    }

    @Override
    public U runTask(TaskContext context) {
        long deserializeStartTime = System.currentTimeMillis();
        SerializerInstance ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
        Tuple2 tuple2 = (Tuple2)ser.deserialize(ByteBuffer.wrap(this.taskBinary.value()), Thread.currentThread().getContextClassLoader(), ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple2 tuple22;
            RDD rdd = (RDD)tuple2._1();
            Function2 func = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rdd, (Object)func);
            RDD rdd2 = (RDD)tuple23._1();
            Function2 func2 = (Function2)tuple23._2();
            this._executorDeserializeTime_$eq(System.currentTimeMillis() - deserializeStartTime);
            this.metrics_$eq((Option<TaskMetrics>)new Some((Object)context.taskMetrics()));
            return (U)func2.apply((Object)context, rdd2.iterator(this.partition, context));
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Seq<TaskLocation> preferredLocations() {
        return this.preferredLocs;
    }

    public String toString() {
        return new StringBuilder().append((Object)"ResultTask(").append((Object)BoxesRunTime.boxToInteger((int)super.stageId())).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).append((Object)")").toString();
    }

    public ResultTask(int stageId, int stageAttemptId, Broadcast<byte[]> taskBinary, Partition partition, Seq<TaskLocation> locs, int outputId, Seq<Accumulator<Object>> internalAccumulators) {
        this.taskBinary = taskBinary;
        this.partition = partition;
        this.outputId = outputId;
        super(stageId, stageAttemptId, partition.index(), internalAccumulators);
        this.preferredLocs = locs == null ? Nil$.MODULE$ : locs.toSet().toSeq();
    }
}

