/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.memory.MemoryPool;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra!B\u0001\u0003\u0001\tQ!aE#yK\u000e,H/[8o\u001b\u0016lwN]=Q_>d'BA\u0002\u0005\u0003\u0019iW-\\8ss*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017=\u0001\"\u0001D\u0007\u000e\u0003\tI!A\u0004\u0002\u0003\u00155+Wn\u001c:z!>|G\u000e\u0005\u0002\u0011#5\tA!\u0003\u0002\u0013\t\t9Aj\\4hS:<\u0007\u0002\u0003\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t1|7m[\u0002\u0001!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0003mC:<'\"A\u000e\u0002\t)\fg/Y\u0005\u0003;a\u0011aa\u00142kK\u000e$\b\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u0011A|w\u000e\u001c(b[\u0016\u0004\"!I\u0014\u000f\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003M\rBQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDcA\u0017/_A\u0011A\u0002\u0001\u0005\u0006))\u0002\rA\u0006\u0005\u0006?)\u0002\r\u0001\t\u0005\bc\u0001\u0011\r\u0011\"\u00033\u00035iW-\\8ss\u001a{'\u000fV1tWV\t1\u0007\u0005\u00035smZT\"A\u001b\u000b\u0005Y:\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003q\r\n!bY8mY\u0016\u001cG/[8o\u0013\tQTGA\u0004ICNDW*\u00199\u0011\u0005\tb\u0014BA\u001f$\u0005\u0011auN\\4\t\r}\u0002\u0001\u0015!\u00034\u00039iW-\\8ss\u001a{'\u000fV1tW\u0002BCAP!L\u0019B\u0011!)S\u0007\u0002\u0007*\u0011A)R\u0001\u000bG>t7-\u001e:sK:$(B\u0001$H\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002\u0011\u0006)!.\u0019<bq&\u0011!j\u0011\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f\u0013\u0001\u0006\u0005\u0006\u001d\u0002!\teT\u0001\u000b[\u0016lwN]=Vg\u0016$W#A\u001e\t\u000bE\u0003A\u0011\u0001*\u0002+\u001d,G/T3n_JLXk]1hK\u001a{'\u000fV1tWR\u00111h\u0015\u0005\u0006)B\u0003\raO\u0001\u000ei\u0006\u001c8.\u0011;uK6\u0004H/\u00133\t\rY\u0003A\u0011\u0001\u0002X\u00035\t7-];je\u0016lU-\\8ssR)1\b\u0017.\\G\")\u0011,\u0016a\u0001w\u0005Aa.^7CsR,7\u000fC\u0003U+\u0002\u00071\bC\u0004]+B\u0005\t\u0019A/\u0002\u001b5\f\u0017PY3He><\bk\\8m!\u0011\u0011cl\u000f1\n\u0005}\u001b#!\u0003$v]\u000e$\u0018n\u001c82!\t\u0011\u0013-\u0003\u0002cG\t!QK\\5u\u0011\u001d!W\u000b%AA\u0002\u0015\f!cY8naV$X-T1y!>|GnU5{KB\u0019!EZ\u001e\n\u0005\u001d\u001c#!\u0003$v]\u000e$\u0018n\u001c81\u0011\u0015I\u0007\u0001\"\u0001k\u00035\u0011X\r\\3bg\u0016lU-\\8ssR\u0019\u0001m\u001b7\t\u000beC\u0007\u0019A\u001e\t\u000bQC\u0007\u0019A\u001e\t\u000b9\u0004A\u0011A8\u0002/I,G.Z1tK\u0006cG.T3n_JLhi\u001c:UCN\\GCA\u001eq\u0011\u0015!V\u000e1\u0001<\u0011\u001d\u0011\b!%A\u0005\u0002M\fq#Y2rk&\u0014X-T3n_JLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003QT#!X;,\u0003Y\u0004\"a^>\u000e\u0003aT!!\u001f>\u0002\u0013Ut7\r[3dW\u0016$'B\u0001$$\u0013\ta\bPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DqA \u0001\u0012\u0002\u0013\u0005q0A\fbGF,\u0018N]3NK6|'/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u0001\u0016\u0003KV\u0004")
public class ExecutionMemoryPool
extends MemoryPool
implements Logging {
    private final Object lock;
    public final String org$apache$spark$memory$ExecutionMemoryPool$$poolName;
    @GuardedBy(value="lock")
    private final HashMap<Object, Object> memoryForTask;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private HashMap<Object, Object> memoryForTask() {
        return this.memoryForTask;
    }

    @Override
    public long memoryUsed() {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.memoryForTask().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$);
            return BoxesRunTime.unboxToLong((Object)object2);
        }
    }

    public long getMemoryUsageForTask(long taskAttemptId) {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.memoryForTask().getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            });
            return BoxesRunTime.unboxToLong((Object)object2);
        }
    }

    public long acquireMemory(long numBytes, long taskAttemptId, Function1<Object, BoxedUnit> maybeGrowPool, Function0<Object> computeMaxPoolSize) {
        Object object = this.lock;
        synchronized (object) {
            long toGrant;
            Predef$.MODULE$.assert(numBytes > 0L, (Function0)new Serializable(this, numBytes){
                public static final long serialVersionUID = 0L;
                private final long numBytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid number of bytes requested: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.numBytes$1)}));
                }
                {
                    this.numBytes$1 = numBytes$1;
                }
            });
            if (!this.memoryForTask().contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
                this.memoryForTask().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)0L));
                this.lock.notifyAll();
            }
            while (true) {
                int numActiveTasks = this.memoryForTask().keys().size();
                long curMem = BoxesRunTime.unboxToLong((Object)this.memoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId)));
                maybeGrowPool.apply$mcVJ$sp(numBytes - this.memoryFree());
                long maxPoolSize = computeMaxPoolSize.apply$mcJ$sp();
                long maxMemoryPerTask = maxPoolSize / (long)numActiveTasks;
                long minMemoryPerTask = this.poolSize() / (long)(2 * numActiveTasks);
                long maxToGrant = package$.MODULE$.min(numBytes, package$.MODULE$.max(0L, maxMemoryPerTask - curMem));
                toGrant = package$.MODULE$.min(maxToGrant, this.memoryFree());
                if (toGrant >= numBytes || curMem + toGrant >= minMemoryPerTask) break;
                this.logInfo((Function0<String>)new Serializable(this, taskAttemptId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExecutionMemoryPool $outer;
                    private final long taskAttemptId$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TID ", " waiting for at least 1/2N of ", " pool to be free"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskAttemptId$1), this.$outer.org$apache$spark$memory$ExecutionMemoryPool$$poolName}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.taskAttemptId$1 = taskAttemptId$1;
                    }
                });
                this.lock.wait();
            }
            this.memoryForTask().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.memoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) + toGrant)));
            return toGrant;
        }
    }

    public Function1<Object, BoxedUnit> acquireMemory$default$3() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(long additionalSpaceNeeded) {
                this.apply$mcVJ$sp(additionalSpaceNeeded);
            }

            public void apply$mcVJ$sp(long additionalSpaceNeeded) {
            }
        };
    }

    public Function0<Object> acquireMemory$default$4() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionMemoryPool $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.poolSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void releaseMemory(long numBytes, long taskAttemptId) {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            long memoryToFree;
            long l;
            long curMem = BoxesRunTime.unboxToLong((Object)this.memoryForTask().getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }));
            if (curMem < numBytes) {
                this.logWarning((Function0<String>)new Serializable(this, numBytes, curMem){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExecutionMemoryPool $outer;
                    private final long numBytes$2;
                    private final long curMem$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Internal error: release called on ", " bytes but task only has ", " bytes "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.numBytes$2), BoxesRunTime.boxToLong((long)this.curMem$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"of memory from the ", " pool"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$memory$ExecutionMemoryPool$$poolName}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numBytes$2 = numBytes$2;
                        this.curMem$1 = curMem$1;
                    }
                });
                l = curMem;
            } else {
                l = memoryToFree = numBytes;
            }
            if (this.memoryForTask().contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
                this.memoryForTask().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.memoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) - memoryToFree)));
                object2 = BoxesRunTime.unboxToLong((Object)this.memoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) <= 0L ? this.memoryForTask().remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)) : BoxedUnit.UNIT;
            } else {
                object2 = BoxedUnit.UNIT;
            }
            this.lock.notifyAll();
            return;
        }
    }

    public long releaseAllMemoryForTask(long taskAttemptId) {
        Object object = this.lock;
        synchronized (object) {
            long numBytesToFree = this.getMemoryUsageForTask(taskAttemptId);
            this.releaseMemory(numBytesToFree, taskAttemptId);
            Long l = BoxesRunTime.boxToLong((long)numBytesToFree);
            return BoxesRunTime.unboxToLong((Object)l);
        }
    }

    public ExecutionMemoryPool(Object lock, String poolName) {
        this.lock = lock;
        this.org$apache$spark$memory$ExecutionMemoryPool$$poolName = poolName;
        super(lock);
        Logging$class.$init$(this);
        this.memoryForTask = new HashMap();
    }
}

