/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.crypto.key.kms.LoadBalancingKMSClientProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLoadBalancingKMSClientProvider {
    @Test
    public void testCreation() throws Exception {
        Configuration conf = new Configuration();
        KeyProvider kp = new KMSClientProvider.Factory().createProvider(new URI("kms://http@host1/kms/foo"), conf);
        Assert.assertTrue((boolean)(kp instanceof KMSClientProvider));
        Assert.assertEquals((Object)"http://host1/kms/foo/v1/", (Object)((KMSClientProvider)kp).getKMSUrl());
        kp = new KMSClientProvider.Factory().createProvider(new URI("kms://http@host1;host2;host3/kms/foo"), conf);
        Assert.assertTrue((boolean)(kp instanceof LoadBalancingKMSClientProvider));
        KMSClientProvider[] providers = ((LoadBalancingKMSClientProvider)kp).getProviders();
        Assert.assertEquals((long)3L, (long)providers.length);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"http://host1/kms/foo/v1/", "http://host2/kms/foo/v1/", "http://host3/kms/foo/v1/"}), (Object)Sets.newHashSet((Object[])new String[]{providers[0].getKMSUrl(), providers[1].getKMSUrl(), providers[2].getKMSUrl()}));
        kp = new KMSClientProvider.Factory().createProvider(new URI("kms://http@host1;host2;host3:16000/kms/foo"), conf);
        Assert.assertTrue((boolean)(kp instanceof LoadBalancingKMSClientProvider));
        providers = ((LoadBalancingKMSClientProvider)kp).getProviders();
        Assert.assertEquals((long)3L, (long)providers.length);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"http://host1:16000/kms/foo/v1/", "http://host2:16000/kms/foo/v1/", "http://host3:16000/kms/foo/v1/"}), (Object)Sets.newHashSet((Object[])new String[]{providers[0].getKMSUrl(), providers[1].getKMSUrl(), providers[2].getKMSUrl()}));
    }

    @Test
    public void testLoadBalancing() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p1", "v1", new byte[0]));
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p2", "v2", new byte[0]));
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p3", "v3", new byte[0]));
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3}, 0L, conf);
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test1", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p2", (Object)kp.createKey("test2", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p3", (Object)kp.createKey("test3", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test4", new KeyProvider.Options(conf)).getName());
    }

    @Test
    public void testLoadBalancingWithFailure() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p1", "v1", new byte[0]));
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new NoSuchAlgorithmException("p2")});
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p3", "v3", new byte[0]));
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        KMSClientProvider p4 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p4.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p4")});
        Mockito.when((Object)p4.getKMSUrl()).thenReturn((Object)"p4");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3, p4}, 0L, conf);
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test4", new KeyProvider.Options(conf)).getName());
        try {
            kp.createKey("test1", new KeyProvider.Options(conf)).getName();
            Assert.fail((String)"Should fail since its not an IOException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NoSuchAlgorithmException));
        }
        Assert.assertEquals((Object)"p3", (Object)kp.createKey("test2", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test3", new KeyProvider.Options(conf)).getName());
    }

    @Test
    public void testLoadBalancingWithAllBadNodes() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p3")});
        KMSClientProvider p4 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p4.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p4")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        Mockito.when((Object)p4.getKMSUrl()).thenReturn((Object)"p4");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3, p4}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf)).getName();
            Assert.fail((String)"Should fail since all providers threw an IOException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
        }
    }
}

