/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class MetadataTable {
    public static Pair<SortedMap<KeyExtent, Text>, List<KeyExtent>> getMetadataLocationEntries(SortedMap<Key, Value> entries) {
        Text location = null;
        Value prevRow = null;
        TreeMap<KeyExtent, Text> results = new TreeMap<KeyExtent, Text>();
        ArrayList<KeyExtent> locationless = new ArrayList<KeyExtent>();
        Text lastRowFromKey = new Text();
        Text colf = new Text();
        Text colq = new Text();
        for (Map.Entry<Key, Value> entry : entries.entrySet()) {
            Key key = entry.getKey();
            Value val = entry.getValue();
            if (key.compareRow(lastRowFromKey) != 0) {
                prevRow = null;
                location = null;
                key.getRow(lastRowFromKey);
            }
            colf = key.getColumnFamily(colf);
            colq = key.getColumnQualifier(colq);
            if (colf.equals((Object)Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY) || colf.equals((Object)Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY)) {
                if (location != null) {
                    throw new IllegalStateException("Tablet has multiple locations : " + lastRowFromKey);
                }
                location = new Text(val.toString());
            } else if (Constants.METADATA_PREV_ROW_COLUMN.equals(colf, colq)) {
                prevRow = new Value(val);
            }
            if (prevRow == null) continue;
            KeyExtent ke = new KeyExtent(key.getRow(), prevRow);
            if (location != null) {
                results.put(ke, location);
            } else {
                locationless.add(ke);
            }
            location = null;
            prevRow = null;
        }
        return new Pair<SortedMap<KeyExtent, Text>, List<KeyExtent>>(results, locationless);
    }

    public static SortedMap<Text, SortedMap<ColumnFQ, Value>> getTabletEntries(SortedMap<Key, Value> tabletKeyValues, List<ColumnFQ> columns) {
        TreeMap<Text, SortedMap<ColumnFQ, Value>> tabletEntries = new TreeMap<Text, SortedMap<ColumnFQ, Value>>();
        HashSet<ColumnFQ> colSet = null;
        if (columns != null) {
            colSet = new HashSet<ColumnFQ>(columns);
        }
        for (Map.Entry<Key, Value> entry : tabletKeyValues.entrySet()) {
            if (columns != null && !colSet.contains(new ColumnFQ(entry.getKey()))) continue;
            Text row = entry.getKey().getRow();
            SortedMap<ColumnFQ, Value> colVals = tabletEntries.get(row);
            if (colVals == null) {
                colVals = new TreeMap<ColumnFQ, Value>();
                tabletEntries.put(row, colVals);
            }
            colVals.put(new ColumnFQ(entry.getKey()), entry.getValue());
        }
        return tabletEntries;
    }

    public static void getEntries(Instance instance, TCredentials credentials, String table, boolean isTid, Map<KeyExtent, String> locations, SortedSet<KeyExtent> tablets) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableId = isTid ? table : (String)Tables.getNameToIdMap(instance).get(table);
        Scanner scanner = instance.getConnector(credentials.getPrincipal(), CredentialHelper.extractToken(credentials)).createScanner("!METADATA", Constants.NO_AUTHS);
        Constants.METADATA_PREV_ROW_COLUMN.fetch(scanner);
        scanner.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
        KeyExtent ke = new KeyExtent(new Text(tableId), new Text(), null);
        Key startKey = new Key(ke.getMetadataEntry());
        ke = new KeyExtent(new Text(tableId), null, null);
        Key endKey = new Key(ke.getMetadataEntry()).followingKey(PartialKey.ROW);
        scanner.setRange(new Range(startKey, endKey));
        Text colf = new Text();
        Text colq = new Text();
        KeyExtent currentKeyExtent = null;
        String location = null;
        Text row = null;
        boolean haveExtent = false;
        boolean haveLocation = false;
        for (Map.Entry<Key, Value> entry : scanner) {
            if (row != null) {
                if (!row.equals((Object)entry.getKey().getRow())) {
                    currentKeyExtent = null;
                    haveExtent = false;
                    haveLocation = false;
                    row = entry.getKey().getRow();
                }
            } else {
                row = entry.getKey().getRow();
            }
            colf = entry.getKey().getColumnFamily(colf);
            colq = entry.getKey().getColumnQualifier(colq);
            if (!new KeyExtent(entry.getKey().getRow(), (Text)null).getTableId().toString().equals(tableId)) break;
            if (Constants.METADATA_PREV_ROW_COLUMN.equals(colf, colq)) {
                currentKeyExtent = new KeyExtent(entry.getKey().getRow(), entry.getValue());
                tablets.add(currentKeyExtent);
                haveExtent = true;
            } else if (colf.equals((Object)Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY)) {
                location = entry.getValue().toString();
                haveLocation = true;
            }
            if (!haveExtent || !haveLocation) continue;
            locations.put(currentKeyExtent, location);
            haveExtent = false;
            haveLocation = false;
            currentKeyExtent = null;
        }
        MetadataTable.validateEntries(tableId, tablets);
    }

    public static void validateEntries(String tableId, SortedSet<KeyExtent> tablets) throws AccumuloException {
        if (tablets.size() == 0) {
            throw new AccumuloException("No entries found in metadata table for table " + tableId);
        }
        if (tablets.first().getPrevEndRow() != null) {
            throw new AccumuloException("Problem with metadata table, first entry for table " + tableId + "- " + tablets.first() + " - has non null prev end row");
        }
        if (tablets.last().getEndRow() != null) {
            throw new AccumuloException("Problem with metadata table, last entry for table " + tableId + "- " + tablets.first() + " - has non null end row");
        }
        Iterator tabIter = tablets.iterator();
        Text lastEndRow = ((KeyExtent)tabIter.next()).getEndRow();
        while (tabIter.hasNext()) {
            KeyExtent tabke = (KeyExtent)tabIter.next();
            if (tabke.getPrevEndRow() == null) {
                throw new AccumuloException("Problem with metadata table, it has null prev end row in middle of table " + tabke);
            }
            if (!tabke.getPrevEndRow().equals((Object)lastEndRow)) {
                throw new AccumuloException("Problem with metadata table, it has a hole " + tabke.getPrevEndRow() + " != " + lastEndRow);
            }
            lastEndRow = tabke.getEndRow();
        }
    }

    public static boolean isContiguousRange(KeyExtent ke, SortedSet<KeyExtent> children) {
        boolean erEqual;
        if (children.size() == 0) {
            return false;
        }
        if (children.size() == 1) {
            return children.first().equals(ke);
        }
        Text per = children.first().getPrevEndRow();
        Text er = children.last().getEndRow();
        boolean perEqual = per == ke.getPrevEndRow() || per != null && ke.getPrevEndRow() != null && ke.getPrevEndRow().compareTo((BinaryComparable)per) == 0;
        boolean bl = erEqual = er == ke.getEndRow() || er != null && ke.getEndRow() != null && ke.getEndRow().compareTo((BinaryComparable)er) == 0;
        if (!perEqual || !erEqual) {
            return false;
        }
        Iterator iter = children.iterator();
        Text lastEndRow = ((KeyExtent)iter.next()).getEndRow();
        while (iter.hasNext()) {
            KeyExtent cke = (KeyExtent)iter.next();
            per = cke.getPrevEndRow();
            if (per == null || lastEndRow == null) {
                return false;
            }
            if (per.compareTo((BinaryComparable)lastEndRow) != 0) {
                return false;
            }
            lastEndRow = cke.getEndRow();
        }
        return true;
    }

    public static class DataFileValue {
        private long size;
        private long numEntries;
        private long time = -1L;

        public DataFileValue(long size, long numEntries, long time) {
            this.size = size;
            this.numEntries = numEntries;
            this.time = time;
        }

        public DataFileValue(long size, long numEntries) {
            this.size = size;
            this.numEntries = numEntries;
            this.time = -1L;
        }

        public DataFileValue(byte[] encodedDFV) {
            String[] ba = new String(encodedDFV).split(",");
            this.size = Long.parseLong(ba[0]);
            this.numEntries = Long.parseLong(ba[1]);
            this.time = ba.length == 3 ? Long.parseLong(ba[2]) : -1L;
        }

        public long getSize() {
            return this.size;
        }

        public long getNumEntries() {
            return this.numEntries;
        }

        public boolean isTimeSet() {
            return this.time >= 0L;
        }

        public long getTime() {
            return this.time;
        }

        public byte[] encode() {
            if (this.time >= 0L) {
                return ("" + this.size + "," + this.numEntries + "," + this.time).getBytes();
            }
            return ("" + this.size + "," + this.numEntries).getBytes();
        }

        public boolean equals(Object o) {
            if (o instanceof DataFileValue) {
                DataFileValue odfv = (DataFileValue)o;
                return this.size == odfv.size && this.numEntries == odfv.numEntries;
            }
            return false;
        }

        public int hashCode() {
            return Long.valueOf(this.size + this.numEntries).hashCode();
        }

        public String toString() {
            return this.size + " " + this.numEntries;
        }

        public void setTime(long time) {
            if (time < 0L) {
                throw new IllegalArgumentException();
            }
            this.time = time;
        }
    }
}

