/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.mock.IteratorAdapter;
import org.apache.accumulo.core.client.mock.MockScannerBase;
import org.apache.accumulo.core.client.mock.MockTable;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.SortedMapIterator;
import org.apache.accumulo.core.security.Authorizations;

public class MockScanner
extends MockScannerBase
implements Scanner {
    int batchSize = 0;
    Range range = new Range();

    MockScanner(MockTable table, Authorizations auths) {
        super(table, auths);
    }

    @Override
    @Deprecated
    public void setTimeOut(int timeOut) {
        if (timeOut == Integer.MAX_VALUE) {
            this.setTimeout(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        } else {
            this.setTimeout(timeOut, TimeUnit.SECONDS);
        }
    }

    @Override
    @Deprecated
    public int getTimeOut() {
        long timeout = this.getTimeout(TimeUnit.SECONDS);
        if (timeout >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)timeout;
    }

    @Override
    public void setRange(Range range) {
        this.range = range;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void enableIsolation() {
    }

    @Override
    public void disableIsolation() {
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        SortedKeyValueIterator<Key, Value> i = new SortedMapIterator(this.table.table);
        try {
            i = new RangeFilter(this.createFilter(i), this.range);
            i.seek(this.range, MockScanner.createColumnBSS(this.fetchedColumns), !this.fetchedColumns.isEmpty());
            return new IteratorAdapter(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class RangeFilter
    extends Filter {
        Range range;

        RangeFilter(SortedKeyValueIterator<Key, Value> i, Range range) {
            this.setSource(i);
            this.range = range;
        }

        @Override
        public boolean accept(Key k, Value v) {
            return this.range.contains(k);
        }
    }
}

