/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapred;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.mapreduce.lib.util.OutputConfigurator;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AccumuloOutputFormat
implements OutputFormat<Text, Mutation> {
    private static final Class<?> CLASS = AccumuloOutputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    public static void setConnectorInfo(JobConf job, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        OutputConfigurator.setConnectorInfo(CLASS, (Configuration)job, principal, token);
    }

    protected static Boolean isConnectorInfoSet(JobConf job) {
        return OutputConfigurator.isConnectorInfoSet(CLASS, (Configuration)job);
    }

    protected static String getPrincipal(JobConf job) {
        return OutputConfigurator.getPrincipal(CLASS, (Configuration)job);
    }

    protected static String getTokenClass(JobConf job) {
        return OutputConfigurator.getTokenClass(CLASS, (Configuration)job);
    }

    protected static byte[] getToken(JobConf job) {
        return OutputConfigurator.getToken(CLASS, (Configuration)job);
    }

    public static void setZooKeeperInstance(JobConf job, String instanceName, String zooKeepers) {
        OutputConfigurator.setZooKeeperInstance(CLASS, (Configuration)job, instanceName, zooKeepers);
    }

    public static void setMockInstance(JobConf job, String instanceName) {
        OutputConfigurator.setMockInstance(CLASS, (Configuration)job, instanceName);
    }

    protected static Instance getInstance(JobConf job) {
        return OutputConfigurator.getInstance(CLASS, (Configuration)job);
    }

    public static void setLogLevel(JobConf job, Level level) {
        OutputConfigurator.setLogLevel(CLASS, (Configuration)job, level);
    }

    protected static Level getLogLevel(JobConf job) {
        return OutputConfigurator.getLogLevel(CLASS, (Configuration)job);
    }

    public static void setDefaultTableName(JobConf job, String tableName) {
        OutputConfigurator.setDefaultTableName(CLASS, (Configuration)job, tableName);
    }

    protected static String getDefaultTableName(JobConf job) {
        return OutputConfigurator.getDefaultTableName(CLASS, (Configuration)job);
    }

    public static void setBatchWriterOptions(JobConf job, BatchWriterConfig bwConfig) {
        OutputConfigurator.setBatchWriterOptions(CLASS, (Configuration)job, bwConfig);
    }

    protected static BatchWriterConfig getBatchWriterOptions(JobConf job) {
        return OutputConfigurator.getBatchWriterOptions(CLASS, (Configuration)job);
    }

    public static void setCreateTables(JobConf job, boolean enableFeature) {
        OutputConfigurator.setCreateTables(CLASS, (Configuration)job, enableFeature);
    }

    protected static Boolean canCreateTables(JobConf job) {
        return OutputConfigurator.canCreateTables(CLASS, (Configuration)job);
    }

    public static void setSimulationMode(JobConf job, boolean enableFeature) {
        OutputConfigurator.setSimulationMode(CLASS, (Configuration)job, enableFeature);
    }

    protected static Boolean getSimulationMode(JobConf job) {
        return OutputConfigurator.getSimulationMode(CLASS, (Configuration)job);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        if (!AccumuloOutputFormat.isConnectorInfoSet(job).booleanValue()) {
            throw new IOException("Connector info has not been set.");
        }
        try {
            Connector c = AccumuloOutputFormat.getInstance(job).getConnector(AccumuloOutputFormat.getPrincipal(job), CredentialHelper.extractToken(AccumuloOutputFormat.getTokenClass(job), AccumuloOutputFormat.getToken(job)));
            if (!c.securityOperations().authenticateUser(AccumuloOutputFormat.getPrincipal(job), CredentialHelper.extractToken(AccumuloOutputFormat.getTokenClass(job), AccumuloOutputFormat.getToken(job)))) {
                throw new IOException("Unable to authenticate user");
            }
        }
        catch (AccumuloException e) {
            throw new IOException(e);
        }
        catch (AccumuloSecurityException e) {
            throw new IOException(e);
        }
    }

    public RecordWriter<Text, Mutation> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        try {
            return new AccumuloRecordWriter(job);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected static class AccumuloRecordWriter
    implements RecordWriter<Text, Mutation> {
        private MultiTableBatchWriter mtbw = null;
        private HashMap<Text, BatchWriter> bws = null;
        private Text defaultTableName = null;
        private boolean simulate = false;
        private boolean createTables = false;
        private long mutCount = 0L;
        private long valCount = 0L;
        private Connector conn;

        protected AccumuloRecordWriter(JobConf job) throws AccumuloException, AccumuloSecurityException, IOException {
            Level l = AccumuloOutputFormat.getLogLevel(job);
            if (l != null) {
                log.setLevel(AccumuloOutputFormat.getLogLevel(job));
            }
            this.simulate = AccumuloOutputFormat.getSimulationMode(job);
            this.createTables = AccumuloOutputFormat.canCreateTables(job);
            if (this.simulate) {
                log.info((Object)"Simulating output only. No writes to tables will occur");
            }
            this.bws = new HashMap();
            String tname = AccumuloOutputFormat.getDefaultTableName(job);
            Text text = this.defaultTableName = tname == null ? null : new Text(tname);
            if (!this.simulate) {
                this.conn = AccumuloOutputFormat.getInstance(job).getConnector(AccumuloOutputFormat.getPrincipal(job), CredentialHelper.extractToken(AccumuloOutputFormat.getTokenClass(job), AccumuloOutputFormat.getToken(job)));
                this.mtbw = this.conn.createMultiTableBatchWriter(AccumuloOutputFormat.getBatchWriterOptions(job));
            }
        }

        public void write(Text table, Mutation mutation) throws IOException {
            if (table == null || table.toString().isEmpty()) {
                table = this.defaultTableName;
            }
            if (!this.simulate && table == null) {
                throw new IOException("No table or default table specified. Try simulation mode next time");
            }
            ++this.mutCount;
            this.valCount += (long)mutation.size();
            this.printMutation(table, mutation);
            if (this.simulate) {
                return;
            }
            if (!this.bws.containsKey(table)) {
                try {
                    this.addTable(table);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e);
                }
            }
            try {
                this.bws.get(table).addMutation(mutation);
            }
            catch (MutationsRejectedException e) {
                throw new IOException(e);
            }
        }

        public void addTable(Text tableName) throws AccumuloException, AccumuloSecurityException {
            if (this.simulate) {
                log.info((Object)("Simulating adding table: " + tableName));
                return;
            }
            log.debug((Object)("Adding table: " + tableName));
            BatchWriter bw = null;
            String table = tableName.toString();
            if (this.createTables && !this.conn.tableOperations().exists(table)) {
                try {
                    this.conn.tableOperations().create(table);
                }
                catch (AccumuloSecurityException e) {
                    log.error((Object)("Accumulo security violation creating " + table), (Throwable)e);
                    throw e;
                }
                catch (TableExistsException e) {
                    // empty catch block
                }
            }
            try {
                bw = this.mtbw.getBatchWriter(table);
            }
            catch (TableNotFoundException e) {
                log.error((Object)("Accumulo table " + table + " doesn't exist and cannot be created."), (Throwable)e);
                throw new AccumuloException(e);
            }
            catch (AccumuloException e) {
                throw e;
            }
            catch (AccumuloSecurityException e) {
                throw e;
            }
            if (bw != null) {
                this.bws.put(tableName, bw);
            }
        }

        private int printMutation(Text table, Mutation m) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Table %s row key: %s", table, this.hexDump(m.getRow())));
                for (ColumnUpdate cu : m.getUpdates()) {
                    log.trace((Object)String.format("Table %s column: %s:%s", table, this.hexDump(cu.getColumnFamily()), this.hexDump(cu.getColumnQualifier())));
                    log.trace((Object)String.format("Table %s security: %s", table, new ColumnVisibility(cu.getColumnVisibility()).toString()));
                    log.trace((Object)String.format("Table %s value: %s", table, this.hexDump(cu.getValue())));
                }
            }
            return m.getUpdates().size();
        }

        private String hexDump(byte[] ba) {
            StringBuilder sb = new StringBuilder();
            for (byte b : ba) {
                if (b > 32 && b < 126) {
                    sb.append((char)b);
                    continue;
                }
                sb.append(String.format("x%02x", b));
            }
            return sb.toString();
        }

        public void close(Reporter reporter) throws IOException {
            block6: {
                log.debug((Object)("mutations written: " + this.mutCount + ", values written: " + this.valCount));
                if (this.simulate) {
                    return;
                }
                try {
                    this.mtbw.close();
                }
                catch (MutationsRejectedException e) {
                    if (e.getAuthorizationFailuresMap().size() >= 0) {
                        HashMap tables = new HashMap();
                        for (Map.Entry<KeyExtent, Set<SecurityErrorCode>> ke : e.getAuthorizationFailuresMap().entrySet()) {
                            HashSet secCodes = (HashSet)tables.get(ke.getKey().getTableId().toString());
                            if (secCodes == null) {
                                secCodes = new HashSet();
                                tables.put(ke.getKey().getTableId().toString(), secCodes);
                            }
                            secCodes.addAll(ke.getValue());
                        }
                        log.error((Object)("Not authorized to write to tables : " + tables));
                    }
                    if (e.getConstraintViolationSummaries().size() <= 0) break block6;
                    log.error((Object)("Constraint violations : " + e.getConstraintViolationSummaries().size()));
                }
            }
        }
    }
}

