/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TabletLocatorImpl
extends TabletLocator {
    private static final Logger log = Logger.getLogger(TabletLocatorImpl.class);
    static final Text MAX_TEXT = new Text();
    static final EndRowComparator endRowComparator = new EndRowComparator();
    protected Text tableId;
    protected TabletLocator parent;
    protected TreeMap<Text, TabletLocator.TabletLocation> metaCache = new TreeMap(endRowComparator);
    protected TabletLocationObtainer locationObtainer;
    protected Text lastTabletRow;
    private TreeSet<KeyExtent> badExtents = new TreeSet();
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwLock.readLock();
    private final Lock wLock = this.rwLock.writeLock();

    public TabletLocatorImpl(Text table, TabletLocator parent, TabletLocationObtainer tlo) {
        this.tableId = table;
        this.parent = parent;
        this.locationObtainer = tlo;
        this.lastTabletRow = new Text(this.tableId);
        this.lastTabletRow.append(new byte[]{60}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binMutations(List<Mutation> mutations, Map<String, TabletLocator.TabletServerMutations> binnedMutations, List<Mutation> failures, TCredentials credentials) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        OpTimer opTimer = null;
        if (log.isTraceEnabled()) {
            opTimer = new OpTimer(log, Level.TRACE).start("Binning " + mutations.size() + " mutations for table " + this.tableId);
        }
        ArrayList<Mutation> notInCache = new ArrayList<Mutation>();
        Text row = new Text();
        this.rLock.lock();
        try {
            this.processInvalidated(credentials);
            for (Mutation mutation : mutations) {
                row.set(mutation.getRow());
                TabletLocator.TabletLocation tl = this.locateTabletInCache(row);
                if (tl == null) {
                    notInCache.add(mutation);
                    continue;
                }
                this.addMutation(binnedMutations, mutation, tl);
            }
        }
        finally {
            this.rLock.unlock();
        }
        if (notInCache.size() > 0) {
            Collections.sort(notInCache, new Comparator<Mutation>(){

                @Override
                public int compare(Mutation o1, Mutation o2) {
                    return WritableComparator.compareBytes((byte[])o1.getRow(), (int)0, (int)o1.getRow().length, (byte[])o2.getRow(), (int)0, (int)o2.getRow().length);
                }
            });
            this.wLock.lock();
            try {
                boolean failed = false;
                for (Mutation mutation : notInCache) {
                    if (failed) {
                        failures.add(mutation);
                        continue;
                    }
                    row.set(mutation.getRow());
                    TabletLocator.TabletLocation tl = this._locateTablet(row, false, false, false, credentials);
                    if (tl == null) {
                        failures.add(mutation);
                        failed = true;
                        continue;
                    }
                    this.addMutation(binnedMutations, mutation, tl);
                }
            }
            finally {
                this.wLock.unlock();
            }
        }
        if (opTimer != null) {
            opTimer.stop("Binned " + mutations.size() + " mutations for table " + this.tableId + " to " + binnedMutations.size() + " tservers in %DURATION%");
        }
    }

    private void addMutation(Map<String, TabletLocator.TabletServerMutations> binnedMutations, Mutation mutation, TabletLocator.TabletLocation tl) {
        TabletLocator.TabletServerMutations tsm = binnedMutations.get(tl.tablet_location);
        if (tsm == null) {
            tsm = new TabletLocator.TabletServerMutations();
            binnedMutations.put(tl.tablet_location, tsm);
        }
        tsm.addMutation(tl.tablet_extent, mutation);
    }

    private List<Range> binRanges(List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges, boolean useCache, TCredentials credentials) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ArrayList<Range> failures = new ArrayList<Range>();
        ArrayList<TabletLocator.TabletLocation> tabletLocations = new ArrayList<TabletLocator.TabletLocation>();
        boolean lookupFailed = false;
        block0: for (Range range : ranges) {
            tabletLocations.clear();
            Text startRow = range.getStartKey() != null ? range.getStartKey().getRow() : new Text();
            TabletLocator.TabletLocation tl = null;
            if (useCache) {
                tl = this.locateTabletInCache(startRow);
            } else if (!lookupFailed) {
                tl = this._locateTablet(startRow, false, false, false, credentials);
            }
            if (tl == null) {
                failures.add(range);
                if (useCache) continue;
                lookupFailed = true;
                continue;
            }
            tabletLocations.add(tl);
            while (tl.tablet_extent.getEndRow() != null && !range.afterEndKey(new Key(tl.tablet_extent.getEndRow()).followingKey(PartialKey.ROW))) {
                if (useCache) {
                    Text row = new Text(tl.tablet_extent.getEndRow());
                    row.append(new byte[]{0}, 0, 1);
                    tl = this.locateTabletInCache(row);
                } else {
                    tl = this._locateTablet(tl.tablet_extent.getEndRow(), true, false, false, credentials);
                }
                if (tl == null) {
                    failures.add(range);
                    if (useCache) continue block0;
                    lookupFailed = true;
                    continue block0;
                }
                tabletLocations.add(tl);
            }
            for (TabletLocator.TabletLocation tl2 : tabletLocations) {
                TabletLocatorImpl.addRange(binnedRanges, tl2.tablet_location, tl2.tablet_extent, range);
            }
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Range> binRanges(List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges, TCredentials credentials) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        List<Range> failures;
        OpTimer opTimer = null;
        if (log.isTraceEnabled()) {
            opTimer = new OpTimer(log, Level.TRACE).start("Binning " + ranges.size() + " ranges for table " + this.tableId);
        }
        this.rLock.lock();
        try {
            this.processInvalidated(credentials);
            failures = this.binRanges(ranges, binnedRanges, true, credentials);
        }
        finally {
            this.rLock.unlock();
        }
        if (failures.size() > 0) {
            Collections.sort(failures);
            this.wLock.lock();
            try {
                failures = this.binRanges(failures, binnedRanges, false, credentials);
            }
            finally {
                this.wLock.unlock();
            }
        }
        if (opTimer != null) {
            opTimer.stop("Binned " + ranges.size() + " ranges for table " + this.tableId + " to " + binnedRanges.size() + " tservers in %DURATION%");
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCache(KeyExtent failedExtent) {
        this.wLock.lock();
        try {
            this.badExtents.add(failedExtent);
        }
        finally {
            this.wLock.unlock();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invalidated extent=" + failedExtent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCache(Collection<KeyExtent> keySet) {
        this.wLock.lock();
        try {
            this.badExtents.addAll(keySet);
        }
        finally {
            this.wLock.unlock();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invalidated " + keySet.size() + " cache entries for table " + this.tableId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCache(String server) {
        int invalidatedCount = 0;
        this.wLock.lock();
        try {
            for (TabletLocator.TabletLocation cacheEntry : this.metaCache.values()) {
                if (!cacheEntry.tablet_location.equals(server)) continue;
                this.badExtents.add(cacheEntry.tablet_extent);
                ++invalidatedCount;
            }
        }
        finally {
            this.wLock.unlock();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("invalidated " + invalidatedCount + " cache entries  table=" + this.tableId + " server=" + server));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCache() {
        int invalidatedCount;
        this.wLock.lock();
        try {
            invalidatedCount = this.metaCache.size();
            this.metaCache.clear();
        }
        finally {
            this.wLock.unlock();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("invalidated all " + invalidatedCount + " cache entries for table=" + this.tableId));
        }
    }

    @Override
    public TabletLocator.TabletLocation locateTablet(Text row, boolean skipRow, boolean retry, TCredentials credentials) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        TabletLocator.TabletLocation tl;
        OpTimer opTimer = null;
        if (log.isTraceEnabled()) {
            opTimer = new OpTimer(log, Level.TRACE).start("Locating tablet  table=" + this.tableId + " row=" + TextUtil.truncate(row) + "  skipRow=" + skipRow + " retry=" + retry);
        }
        while (true) {
            tl = this._locateTablet(row, skipRow, retry, true, credentials);
            if (!retry || tl != null) break;
            UtilWaitThread.sleep(100L);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Failed to locate tablet containing row " + TextUtil.truncate(row) + " in table " + this.tableId + ", will retry..."));
        }
        if (opTimer != null) {
            opTimer.stop("Located tablet " + (tl == null ? null : tl.tablet_extent) + " at " + (tl == null ? null : tl.tablet_location) + " in %DURATION%");
        }
        return tl;
    }

    private void lookupTabletLocation(Text row, boolean retry, TCredentials credentials) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Text metadataRow = new Text(this.tableId);
        metadataRow.append(new byte[]{59}, 0, 1);
        metadataRow.append(row.getBytes(), 0, row.getLength());
        TabletLocator.TabletLocation ptl = this.parent.locateTablet(metadataRow, false, retry, credentials);
        if (ptl != null) {
            Text er;
            TabletLocator.TabletLocations locations = this.locationObtainer.lookupTablet(ptl, metadataRow, this.lastTabletRow, this.parent, credentials);
            while (locations != null && locations.getLocations().isEmpty() && locations.getLocationless().isEmpty() && !ptl.tablet_extent.isRootTablet() && (er = ptl.tablet_extent.getEndRow()) != null && er.compareTo((BinaryComparable)this.lastTabletRow) < 0 && (ptl = this.parent.locateTablet(er, true, retry, credentials)) != null) {
                locations = this.locationObtainer.lookupTablet(ptl, metadataRow, this.lastTabletRow, this.parent, credentials);
            }
            if (locations == null) {
                return;
            }
            Text lastEndRow = null;
            for (TabletLocator.TabletLocation tabletLocation : locations.getLocations()) {
                KeyExtent ke = tabletLocation.tablet_extent;
                TabletLocator.TabletLocation locToCache = lastEndRow != null && ke.getPrevEndRow() != null && ke.getPrevEndRow().equals((Object)lastEndRow) ? new TabletLocator.TabletLocation(new KeyExtent(ke.getTableId(), ke.getEndRow(), lastEndRow), tabletLocation.tablet_location) : tabletLocation;
                lastEndRow = locToCache.tablet_extent.getEndRow();
                this.updateCache(locToCache);
            }
        }
    }

    private void updateCache(TabletLocator.TabletLocation tabletLocation) {
        if (!tabletLocation.tablet_extent.getTableId().equals((Object)this.tableId)) {
            throw new IllegalStateException("Unexpected extent returned " + this.tableId + "  " + tabletLocation.tablet_extent);
        }
        if (tabletLocation.tablet_location == null) {
            throw new IllegalStateException("Cannot add null locations to cache " + this.tableId + "  " + tabletLocation.tablet_extent);
        }
        if (!tabletLocation.tablet_extent.getTableId().equals((Object)this.tableId)) {
            throw new IllegalStateException("Cannot add other table ids to locations cache " + this.tableId + "  " + tabletLocation.tablet_extent);
        }
        TabletLocatorImpl.removeOverlapping(this.metaCache, tabletLocation.tablet_extent);
        Text er = tabletLocation.tablet_extent.getEndRow();
        if (er == null) {
            er = MAX_TEXT;
        }
        this.metaCache.put(er, tabletLocation);
        if (this.badExtents.size() > 0) {
            TabletLocatorImpl.removeOverlapping(this.badExtents, tabletLocation.tablet_extent);
        }
    }

    static void removeOverlapping(TreeMap<Text, TabletLocator.TabletLocation> metaCache, KeyExtent nke) {
        Iterator<Map.Entry<Text, TabletLocator.TabletLocation>> iter = null;
        if (nke.getPrevEndRow() == null) {
            iter = metaCache.entrySet().iterator();
        } else {
            Text row = TabletLocatorImpl.rowAfterPrevRow(nke);
            SortedMap<Text, TabletLocator.TabletLocation> tailMap = metaCache.tailMap(row);
            iter = tailMap.entrySet().iterator();
        }
        while (iter.hasNext()) {
            Map.Entry<Text, TabletLocator.TabletLocation> entry = iter.next();
            KeyExtent ke = entry.getValue().tablet_extent;
            if (TabletLocatorImpl.stopRemoving(nke, ke)) break;
            iter.remove();
        }
    }

    private static boolean stopRemoving(KeyExtent nke, KeyExtent ke) {
        return ke.getPrevEndRow() != null && nke.getEndRow() != null && ke.getPrevEndRow().compareTo((BinaryComparable)nke.getEndRow()) >= 0;
    }

    private static Text rowAfterPrevRow(KeyExtent nke) {
        Text row = new Text(nke.getPrevEndRow());
        row.append(new byte[]{0}, 0, 1);
        return row;
    }

    static void removeOverlapping(TreeSet<KeyExtent> extents, KeyExtent nke) {
        for (KeyExtent overlapping : KeyExtent.findOverlapping(nke, extents)) {
            extents.remove(overlapping);
        }
    }

    private TabletLocator.TabletLocation locateTabletInCache(Text row) {
        KeyExtent ke;
        Map.Entry<Text, TabletLocator.TabletLocation> entry = this.metaCache.ceilingEntry(row);
        if (entry != null && ((ke = entry.getValue().tablet_extent).getPrevEndRow() == null || ke.getPrevEndRow().compareTo((BinaryComparable)row) < 0)) {
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TabletLocator.TabletLocation _locateTablet(Text row, boolean skipRow, boolean retry, boolean lock, TCredentials credentials) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        TabletLocator.TabletLocation tl;
        if (skipRow) {
            row = new Text(row);
            row.append(new byte[]{0}, 0, 1);
        }
        if (lock) {
            this.rLock.lock();
        }
        try {
            this.processInvalidated(credentials);
            tl = this.locateTabletInCache(row);
        }
        finally {
            if (lock) {
                this.rLock.unlock();
            }
        }
        if (tl == null) {
            if (lock) {
                this.wLock.lock();
            }
            try {
                this.lookupTabletLocation(row, retry, credentials);
                tl = this.locateTabletInCache(row);
            }
            finally {
                if (lock) {
                    this.wLock.unlock();
                }
            }
        }
        return tl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInvalidated(TCredentials credentials) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        if (this.badExtents.size() == 0) {
            return;
        }
        boolean writeLockHeld = this.rwLock.isWriteLockedByCurrentThread();
        try {
            if (!writeLockHeld) {
                this.rLock.unlock();
                this.wLock.lock();
                if (this.badExtents.size() == 0) {
                    return;
                }
            }
            List<Range> lookups = new ArrayList<Range>(this.badExtents.size());
            for (KeyExtent be : this.badExtents) {
                lookups.add(be.toMetadataRange());
                TabletLocatorImpl.removeOverlapping(this.metaCache, be);
            }
            lookups = Range.mergeOverlapping(lookups);
            HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
            this.parent.binRanges(lookups, binnedRanges, credentials);
            ArrayList tabletServers = new ArrayList(binnedRanges.keySet());
            Collections.shuffle(tabletServers);
            for (String tserver : tabletServers) {
                List<TabletLocator.TabletLocation> locations = this.locationObtainer.lookupTablets(tserver, (Map)binnedRanges.get(tserver), this.parent, credentials);
                for (TabletLocator.TabletLocation tabletLocation : locations) {
                    this.updateCache(tabletLocation);
                }
            }
        }
        finally {
            if (!writeLockHeld) {
                this.rLock.lock();
                this.wLock.unlock();
            }
        }
    }

    protected static void addRange(Map<String, Map<KeyExtent, List<Range>>> binnedRanges, String location, KeyExtent ke, Range range) {
        List<Range> tabletsRanges;
        Map<KeyExtent, List<Range>> tablets = binnedRanges.get(location);
        if (tablets == null) {
            tablets = new HashMap<KeyExtent, List<Range>>();
            binnedRanges.put(location, tablets);
        }
        if ((tabletsRanges = tablets.get(ke)) == null) {
            tabletsRanges = new ArrayList<Range>();
            tablets.put(ke, tabletsRanges);
        }
        tabletsRanges.add(range);
    }

    public static interface TabletLocationObtainer {
        public TabletLocator.TabletLocations lookupTablet(TabletLocator.TabletLocation var1, Text var2, Text var3, TabletLocator var4, TCredentials var5) throws AccumuloSecurityException, AccumuloException;

        public List<TabletLocator.TabletLocation> lookupTablets(String var1, Map<KeyExtent, List<Range>> var2, TabletLocator var3, TCredentials var4) throws AccumuloSecurityException, AccumuloException;
    }

    private static class EndRowComparator
    implements Comparator<Text> {
        private EndRowComparator() {
        }

        @Override
        public int compare(Text o1, Text o2) {
            int ret = o1 == MAX_TEXT ? (o2 == MAX_TEXT ? 0 : 1) : (o2 == MAX_TEXT ? -1 : o1.compareTo((BinaryComparable)o2));
            return ret;
        }
    }
}

