/*
 * Decompiled with CFR 0.152.
 */
package tachyon.hadoop;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.conf.TachyonConf;

public class ConfUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    private ConfUtils() {
    }

    public static void storeToHadoopConfiguration(TachyonConf source, Configuration target) {
        target.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        Properties confProperties = source.getInternalProperties();
        try {
            DefaultStringifier.store((Configuration)target, (Object)confProperties, (String)"tachyon.conf.site");
        }
        catch (IOException ex) {
            LOG.error("Unable to store TachyonConf in Hadoop configuration", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static TachyonConf loadFromHadoopConfiguration(Configuration source) {
        Properties tachyonConfProperties = null;
        if (source.get("tachyon.conf.site") != null) {
            LOG.info("Found TachyonConf site from Job configuration for Tachyon");
            try {
                tachyonConfProperties = (Properties)DefaultStringifier.load((Configuration)source, (String)"tachyon.conf.site", Properties.class);
            }
            catch (IOException e) {
                LOG.error("Unable to load TachyonConf from Hadoop configuration", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (tachyonConfProperties == null) {
            tachyonConfProperties = new Properties();
        }
        for (Map.Entry entry : source) {
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith("tachyon.") && !propertyName.equals("fs.s3n.awsAccessKeyId") && !propertyName.equals("fs.s3n.awsSecretAccessKey")) continue;
            tachyonConfProperties.put(propertyName, entry.getValue());
        }
        LOG.info("Loading Tachyon properties from Hadoop configuration: " + tachyonConfProperties);
        return new TachyonConf(tachyonConfProperties);
    }
}

