/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.block;

import java.io.IOException;
import tachyon.client.ClientContext;
import tachyon.client.RemoteBlockWriter;
import tachyon.client.block.BufferedBlockOutStream;
import tachyon.worker.WorkerClient;

public final class RemoteBlockOutStream
extends BufferedBlockOutStream {
    private final RemoteBlockWriter mRemoteWriter = RemoteBlockWriter.Factory.createRemoteBlockWriter(ClientContext.getConf());
    private final WorkerClient mWorkerClient;

    public RemoteBlockOutStream(long blockId, long blockSize) throws IOException {
        super(blockId, blockSize);
        this.mWorkerClient = this.mContext.acquireWorkerClient();
        try {
            this.mWorkerClient.mustConnect();
            this.mRemoteWriter.open(this.mWorkerClient.getDataServerAddress(), this.mBlockId, this.mWorkerClient.getSessionId());
        }
        catch (IOException e) {
            this.mContext.releaseWorkerClient(this.mWorkerClient);
            throw e;
        }
    }

    public RemoteBlockOutStream(long blockId, long blockSize, String hostname) throws IOException {
        super(blockId, blockSize);
        this.mWorkerClient = this.mContext.acquireWorkerClient(hostname);
        try {
            this.mWorkerClient.mustConnect();
            this.mRemoteWriter.open(this.mWorkerClient.getDataServerAddress(), this.mBlockId, this.mWorkerClient.getSessionId());
        }
        catch (IOException e) {
            this.mContext.releaseWorkerClient(this.mWorkerClient);
            throw e;
        }
    }

    @Override
    public void cancel() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mRemoteWriter.close();
        this.mWorkerClient.cancelBlock(this.mBlockId);
        this.mContext.releaseWorkerClient(this.mWorkerClient);
        this.mClosed = true;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.flush();
        this.mRemoteWriter.close();
        if (this.mFlushedBytes > 0L) {
            this.mWorkerClient.cacheBlock(this.mBlockId);
            ClientContext.getClientMetrics().incBlocksWrittenRemote(1L);
        } else {
            this.mWorkerClient.cancelBlock(this.mBlockId);
        }
        this.mContext.releaseWorkerClient(this.mWorkerClient);
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        this.writeToRemoteBlock(this.mBuffer.array(), 0, this.mBuffer.position());
        this.mBuffer.clear();
    }

    @Override
    protected void unBufferedWrite(byte[] b, int off, int len) throws IOException {
        this.writeToRemoteBlock(b, off, len);
    }

    private void writeToRemoteBlock(byte[] b, int off, int len) throws IOException {
        this.mRemoteWriter.write(b, off, len);
        this.mFlushedBytes += (long)len;
        ClientContext.getClientMetrics().incBytesWrittenRemote(len);
    }
}

