/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.ReadType;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.WriteType;
import tachyon.client.file.FileInStream;
import tachyon.client.file.FileOutStream;
import tachyon.client.file.TachyonFileSystem;
import tachyon.client.file.options.InStreamOptions;
import tachyon.client.file.options.OutStreamOptions;
import tachyon.conf.TachyonConf;
import tachyon.exception.TachyonException;
import tachyon.thrift.BlockLocation;
import tachyon.thrift.FileBlockInfo;
import tachyon.thrift.FileInfo;
import tachyon.thrift.NetAddress;

@Deprecated
public class TachyonFile
implements Comparable<TachyonFile> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final TachyonFileSystem mTFS;
    final TachyonFS mTachyonFS;
    final long mFileId;
    private Object mUFSConf = null;
    private final TachyonConf mTachyonConf;

    TachyonFile(TachyonFS tfs, long fid, TachyonConf tachyonConf) {
        this.mTachyonFS = tfs;
        this.mTFS = TachyonFileSystem.TachyonFileSystemFactory.get();
        this.mFileId = fid;
        this.mTachyonConf = tachyonConf;
    }

    private FileInfo getCachedFileStatus() throws IOException {
        return this.mTachyonFS.getFileStatus(this.mFileId, true);
    }

    private FileInfo getUnCachedFileStatus() throws IOException {
        return this.mTachyonFS.getFileStatus(this.mFileId, false);
    }

    @Override
    public int compareTo(TachyonFile o) {
        if (this.mFileId == o.mFileId) {
            return 0;
        }
        return this.mFileId < o.mFileId ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TachyonFile) {
            return this.compareTo((TachyonFile)obj) == 0;
        }
        return false;
    }

    public long getBlockId(int blockIndex) throws IOException {
        return this.mTachyonFS.getBlockId(this.mFileId, blockIndex);
    }

    public long getBlockSizeByte() throws IOException {
        return this.getCachedFileStatus().getBlockSizeBytes();
    }

    public synchronized FileBlockInfo getClientBlockInfo(int blockIndex) throws IOException {
        return this.mTachyonFS.getClientBlockInfo(this.mFileId, blockIndex);
    }

    public long getCreationTimeMs() throws IOException {
        return this.getCachedFileStatus().getCreationTimeMs();
    }

    public int getDiskReplication() {
        return 3;
    }

    public FileInStream getInStream(ReadType readType) throws IOException {
        if (readType == null) {
            throw new IOException("ReadType can not be null.");
        }
        if (!this.isCompleted()) {
            throw new IOException("The file " + this + " is not complete.");
        }
        if (this.isDirectory()) {
            throw new IOException("Cannot open a directory for reading.");
        }
        FileInfo info = this.getUnCachedFileStatus();
        TachyonURI uri = new TachyonURI(info.getPath());
        InStreamOptions.Builder optionsBuilder = new InStreamOptions.Builder(this.mTachyonConf);
        optionsBuilder.setTachyonStorageType(readType.getTachyonStorageType());
        try {
            tachyon.client.file.TachyonFile newFile = this.mTFS.open(uri);
            return this.mTFS.getInStream(newFile, optionsBuilder.build());
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    public String getLocalFilename(int blockIndex) throws IOException {
        int blockLockId;
        FileBlockInfo fileBlockInfo = this.getClientBlockInfo(blockIndex);
        long blockId = fileBlockInfo.blockInfo.getBlockId();
        String filename = this.mTachyonFS.lockBlock(blockId, blockLockId = this.mTachyonFS.getBlockLockId());
        if (filename != null) {
            this.mTachyonFS.unlockBlock(blockId, blockLockId);
        }
        return filename;
    }

    public List<String> getLocationHosts() throws IOException {
        ArrayList ret = Lists.newArrayList();
        if (this.getNumberOfBlocks() > 0) {
            List<NetAddress> underFsLocations;
            List<BlockLocation> blockLocations = this.getClientBlockInfo(0).getBlockInfo().getLocations();
            if (blockLocations != null) {
                for (BlockLocation location : blockLocations) {
                    ret.add(location.workerAddress.host);
                }
            }
            if ((underFsLocations = this.getClientBlockInfo(0).getUfsLocations()) != null) {
                for (NetAddress location : underFsLocations) {
                    ret.add(location.host);
                }
            }
        }
        return ret;
    }

    public int getNumberOfBlocks() throws IOException {
        return this.getUnCachedFileStatus().getBlockIds().size();
    }

    public FileOutStream getOutStream(WriteType writeType) throws IOException {
        return this.getOutStream();
    }

    public FileOutStream getOutStream() throws IOException {
        if (this.isCompleted()) {
            throw new IOException("Overriding after completion not supported.");
        }
        WriteType writeType = this.mTachyonConf.getEnum("tachyon.user.file.writetype.default", WriteType.class);
        FileInfo info = this.getUnCachedFileStatus();
        OutStreamOptions.Builder optionsBuilder = new OutStreamOptions.Builder(this.mTachyonConf);
        optionsBuilder.setBlockSizeBytes(info.getBlockSizeBytes()).setTachyonStorageType(writeType.getTachyonStorageType()).setUnderStorageType(writeType.getUnderStorageType());
        return this.mTFS.getOutStream(this.mFileId, optionsBuilder.build());
    }

    public String getPath() throws IOException {
        return this.getUnCachedFileStatus().getPath();
    }

    public Object getUFSConf() {
        return this.mUFSConf;
    }

    public int hashCode() {
        return Long.valueOf(this.mFileId).hashCode();
    }

    public boolean isCompleted() throws IOException {
        return this.getCachedFileStatus().isCompleted || this.getUnCachedFileStatus().isCompleted;
    }

    public boolean isDirectory() throws IOException {
        return this.getCachedFileStatus().isFolder;
    }

    public boolean isFile() throws IOException {
        return !this.isDirectory();
    }

    public boolean isInMemory() throws IOException {
        return this.getUnCachedFileStatus().getInMemoryPercentage() == 100;
    }

    public long length() throws IOException {
        return this.getUnCachedFileStatus().getLength();
    }

    public boolean needPin() throws IOException {
        return this.getUnCachedFileStatus().isPinned;
    }

    public boolean promoteBlock(int blockIndex) throws IOException {
        FileBlockInfo fileBlockInfo = this.getClientBlockInfo(blockIndex);
        return this.mTachyonFS.promoteBlock(fileBlockInfo.blockInfo.getBlockId());
    }

    @Deprecated
    public TachyonByteBuffer readByteBuffer(int blockIndex) throws IOException {
        throw new UnsupportedOperationException("ReadByteBuffer is not supported");
    }

    TachyonByteBuffer readLocalByteBuffer(int blockIndex) throws IOException {
        throw new UnsupportedOperationException("ReadLocalByteBuffer is not supported");
    }

    private TachyonByteBuffer readLocalByteBuffer(int blockIndex, long offset, long len) throws IOException {
        throw new UnsupportedOperationException("ReadLocalByteBuffer is not supported");
    }

    TachyonByteBuffer readRemoteByteBuffer(FileBlockInfo blockInfo) throws IOException {
        throw new UnsupportedOperationException("ReadRemoteByteBuffer is not supported");
    }

    public boolean recache() throws IOException {
        throw new UnsupportedOperationException("Recache is not supported");
    }

    boolean recache(int blockIndex) throws IOException {
        throw new UnsupportedOperationException("Recache is not supported");
    }

    public boolean rename(TachyonURI path) throws IOException {
        return this.mTachyonFS.rename(this.mFileId, path);
    }

    public void setUFSConf(Object conf) {
        this.mUFSConf = conf;
    }

    public String toString() {
        try {
            return this.getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("File does not exist anymore: " + this.mFileId);
        }
    }
}

