/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tachyon.TachyonURI;
import tachyon.client.ClientContext;
import tachyon.client.TachyonStorageType;
import tachyon.client.UnderStorageType;
import tachyon.client.file.FileOutStream;
import tachyon.client.file.TachyonFile;
import tachyon.client.file.TachyonFileSystem;
import tachyon.client.file.options.InStreamOptions;
import tachyon.client.file.options.OutStreamOptions;
import tachyon.exception.ExceptionMessage;
import tachyon.exception.TachyonException;
import tachyon.thrift.FileInfo;

public final class TachyonFSTestUtils {
    public static TachyonFile createByteFile(TachyonFileSystem tfs, String fileName, int len, OutStreamOptions options) throws IOException {
        return TachyonFSTestUtils.createByteFile(tfs, fileName, options.getTachyonStorageType(), options.getUnderStorageType(), len, options.getBlockSizeBytes());
    }

    public static TachyonFile createByteFile(TachyonFileSystem tfs, String fileName, TachyonStorageType tachyonStorageType, UnderStorageType underStorageType, int len) throws IOException {
        return TachyonFSTestUtils.createByteFile(tfs, new TachyonURI(fileName), tachyonStorageType, underStorageType, len);
    }

    public static TachyonFile createByteFile(TachyonFileSystem tfs, TachyonURI fileURI, TachyonStorageType tachyonStorageType, UnderStorageType underStorageType, int len) throws IOException {
        try {
            OutStreamOptions options = new OutStreamOptions.Builder(ClientContext.getConf()).setTachyonStorageType(tachyonStorageType).setUnderStorageType(underStorageType).build();
            FileOutStream os = tfs.getOutStream(fileURI, options);
            byte[] arr = new byte[len];
            for (int k = 0; k < len; ++k) {
                arr[k] = (byte)k;
            }
            os.write(arr);
            os.close();
            return tfs.open(fileURI);
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static TachyonFile createByteFile(TachyonFileSystem tfs, String fileName, TachyonStorageType tachyonStorageType, UnderStorageType underStorageType, int len, long blockCapacityByte) throws IOException {
        try {
            OutStreamOptions options = new OutStreamOptions.Builder(ClientContext.getConf()).setTachyonStorageType(tachyonStorageType).setUnderStorageType(underStorageType).setBlockSizeBytes(blockCapacityByte).build();
            FileOutStream os = tfs.getOutStream(new TachyonURI(fileName), options);
            for (int k = 0; k < len; ++k) {
                os.write((byte)k);
            }
            os.close();
            return tfs.open(new TachyonURI(fileName));
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static List<String> listFiles(TachyonFileSystem tfs, String path) throws IOException {
        try {
            TachyonFile file = tfs.open(new TachyonURI(path));
            if (file == null) {
                throw new IOException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(path));
            }
            List<FileInfo> infos = tfs.listStatus(file);
            ArrayList<String> res = new ArrayList<String>();
            for (FileInfo info : infos) {
                res.add(info.getPath());
                if (!info.isFolder) continue;
                res.addAll(TachyonFSTestUtils.listFiles(tfs, info.getPath()));
            }
            return res;
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static InStreamOptions toInStreamOptions(OutStreamOptions op) {
        return new InStreamOptions.Builder(ClientContext.getConf()).setTachyonStorageType(op.getTachyonStorageType()).build();
    }

    private TachyonFSTestUtils() {
    }
}

