/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobControlCompiler;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.mapreduce.hadoop.DeprecatedKeys;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoDisk;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRHelpers;

@InterfaceAudience.Private
public class MRToTezHelper {
    private static final Log LOG = LogFactory.getLog(MRToTezHelper.class);
    private static final String JOB_SPLIT_RESOURCE_NAME = "job.split";
    private static final String JOB_SPLIT_METAINFO_RESOURCE_NAME = "job.splitmetainfo";
    private static Map<String, String> mrAMParamToTezAMParamMap = new HashMap<String, String>();
    private static Map<String, String> mrMapParamToTezVertexParamMap = new HashMap<String, String>();
    private static Map<String, String> mrReduceParamToTezVertexParamMap = new HashMap<String, String>();
    private static List<String> mrSettingsToRetain = new ArrayList<String>();
    private static List<String> mrSettingsToRemove = new ArrayList<String>();

    private MRToTezHelper() {
    }

    private static void populateMRToTezParamsMap() {
        mrAMParamToTezAMParamMap.put("yarn.app.mapreduce.am.resource.mb", "tez.am.resource.memory.mb");
        mrAMParamToTezAMParamMap.put("yarn.app.mapreduce.am.resource.cpu-vcores", "tez.am.resource.cpu.vcores");
        mrAMParamToTezAMParamMap.put("mapreduce.am.max-attempts", "tez.am.max.app.attempts");
        mrAMParamToTezAMParamMap.put("mapreduce.job.credentials.binary", "tez.credentials.path");
        mrAMParamToTezAMParamMap.put("mapreduce.job.complete.cancel.delegation.tokens", "tez.cancel.delegation.tokens.on.completion");
        mrMapParamToTezVertexParamMap.put("mapreduce.map.maxattempts", "tez.am.task.max.failed.attempts");
        mrMapParamToTezVertexParamMap.put("mapreduce.map.speculative", "tez.am.speculation.enabled");
        mrMapParamToTezVertexParamMap.put("mapreduce.map.log.level", "tez.task.log.level");
        mrMapParamToTezVertexParamMap.put("mapreduce.job.running.map.limit", "tez.am.vertex.max-task-concurrency");
        mrMapParamToTezVertexParamMap.put("mapreduce.task.timeout", "tez.am.progress.stuck.interval-ms");
        mrMapParamToTezVertexParamMap.put("mapreduce.map.failures.maxpercent", "tez.vertex.failures.maxpercent");
        mrReduceParamToTezVertexParamMap.put("mapreduce.reduce.maxattempts", "tez.am.task.max.failed.attempts");
        mrReduceParamToTezVertexParamMap.put("mapreduce.reduce.speculative", "tez.am.speculation.enabled");
        mrReduceParamToTezVertexParamMap.put("mapreduce.reduce.log.level", "tez.task.log.level");
        mrReduceParamToTezVertexParamMap.put("mapreduce.job.running.reduce.limit", "tez.am.vertex.max-task-concurrency");
        mrReduceParamToTezVertexParamMap.put("mapreduce.task.timeout", "tez.am.progress.stuck.interval-ms");
        mrReduceParamToTezVertexParamMap.put("mapreduce.reduce.failures.maxpercent", "tez.vertex.failures.maxpercent");
    }

    private static void populateMRSettingsToRetain() {
        mrSettingsToRetain.add("mapreduce.input.fileinputformat.inputdir");
        mrSettingsToRetain.add("mapreduce.input.fileinputformat.split.maxsize");
        mrSettingsToRetain.add("mapreduce.input.fileinputformat.split.minsize");
        mrSettingsToRetain.add("mapreduce.input.pathFilter.class");
        mrSettingsToRetain.add("mapreduce.input.fileinputformat.numinputfiles");
        mrSettingsToRetain.add("mapreduce.input.fileinputformat.input.dir.recursive");
        mrSettingsToRetain.add("mapreduce.output.basename");
        mrSettingsToRetain.add("mapreduce.output.fileoutputformat.compress");
        mrSettingsToRetain.add("mapreduce.output.fileoutputformat.compress.codec");
        mrSettingsToRetain.add("mapreduce.output.fileoutputformat.compress.type");
        mrSettingsToRetain.add("mapreduce.output.fileoutputformat.outputdir");
        mrSettingsToRetain.add("mapreduce.fileoutputcommitter.marksuccessfuljobs");
    }

    private static void populateMRSettingsToRemove() {
        mrSettingsToRemove.add("mapreduce.job.credentials.binary");
        mrSettingsToRemove.add("mapreduce.job.cache.archives");
        mrSettingsToRemove.add("mapreduce.job.cache.archives.filesizes");
        mrSettingsToRemove.add("mapreduce.job.cache.archives.timestamps");
        mrSettingsToRemove.add("mapreduce.job.cache.archives.visibilities");
        mrSettingsToRemove.add("mapreduce.job.cache.files");
        mrSettingsToRemove.add("mapreduce.job.cache.files.filesizes");
        mrSettingsToRemove.add("mapreduce.job.cache.files.timestamps");
        mrSettingsToRemove.add("mapreduce.job.cache.files.visibilities");
        mrSettingsToRemove.add("mapreduce.job.classpath.files");
    }

    private static void removeUnwantedSettings(Configuration tezConf, boolean isAMConf) {
        for (String mrSetting : mrSettingsToRemove) {
            tezConf.unset(mrSetting);
        }
        Iterator iter = new Configuration(tezConf).iterator();
        while (iter.hasNext()) {
            String key = (String)((Map.Entry)iter.next()).getKey();
            if (!isAMConf && key.startsWith("oozie.")) {
                tezConf.unset(key);
                continue;
            }
            if (key.startsWith("yarn.nodemanager")) {
                tezConf.unset(key);
                continue;
            }
            if (key.startsWith("mapreduce.jobhistory")) {
                tezConf.unset(key);
                continue;
            }
            if (key.startsWith("mapreduce.jobtracker")) {
                tezConf.unset(key);
                continue;
            }
            if (!key.startsWith("mapreduce.tasktracker")) continue;
            tezConf.unset(key);
        }
    }

    public static void translateMRSettingsForTezAM(TezConfiguration dagAMConf) {
        MRToTezHelper.convertMRToTezConf((Configuration)dagAMConf, (Configuration)dagAMConf, DeprecatedKeys.getMRToDAGParamMap());
        MRToTezHelper.convertMRToTezConf((Configuration)dagAMConf, (Configuration)dagAMConf, mrAMParamToTezAMParamMap);
        String env = dagAMConf.get("yarn.app.mapreduce.am.admin.user.env");
        if (dagAMConf.get("yarn.app.mapreduce.am.env") != null) {
            String string = env = env == null ? dagAMConf.get("yarn.app.mapreduce.am.env") : env + "," + dagAMConf.get("yarn.app.mapreduce.am.env");
        }
        if (env != null) {
            dagAMConf.setIfUnset("tez.am.launch.env", env);
        }
        dagAMConf.setIfUnset("tez.am.launch.cmd-opts", MRHelpers.getJavaOptsForMRAM((Configuration)dagAMConf));
        String queueName = dagAMConf.get("mapreduce.job.queuename", "default");
        dagAMConf.setIfUnset("tez.queue.name", queueName);
        dagAMConf.setIfUnset("tez.am.view-acls", dagAMConf.get("mapreduce.job.acl-view-job", " "));
        dagAMConf.setIfUnset("tez.am.modify-acls", dagAMConf.get("mapreduce.job.acl-modify-job", " "));
        dagAMConf.setIfUnset("tez.task.scale.memory.reserve-fraction", "0.5");
        MRToTezHelper.removeUnwantedSettings((Configuration)dagAMConf, true);
    }

    public static void setVertexConfig(Vertex vertex, boolean isMapVertex, Configuration conf) {
        Map<String, String> configMapping = isMapVertex ? mrMapParamToTezVertexParamMap : mrReduceParamToTezVertexParamMap;
        for (Map.Entry<String, String> dep : configMapping.entrySet()) {
            String value = conf.get(dep.getValue(), conf.get(dep.getKey()));
            if (value == null) continue;
            vertex.setConf(dep.getValue(), value);
            LOG.debug((Object)("Setting " + dep.getValue() + " to " + value + " for the vertex " + vertex.getName()));
        }
    }

    public static void processMRSettings(Configuration tezConf, Configuration mrConf) {
        for (String mrSetting : mrSettingsToRetain) {
            if (mrConf.get(mrSetting) == null) continue;
            tezConf.set(mrSetting, mrConf.get(mrSetting));
        }
        JobControlCompiler.configureCompression(tezConf);
        MRToTezHelper.convertMRToTezConf(tezConf, mrConf, DeprecatedKeys.getMRToTezRuntimeParamMap());
        MRToTezHelper.removeUnwantedSettings(tezConf, false);
        String slowStartFraction = mrConf.get("mapreduce.job.reduce.slowstart.completedmaps");
        if (slowStartFraction != null) {
            tezConf.setIfUnset("tez.shuffle-vertex-manager.min-src-fraction", slowStartFraction);
            tezConf.setIfUnset("tez.shuffle-vertex-manager.max-src-fraction", slowStartFraction);
        }
    }

    private static void convertMRToTezConf(Configuration tezConf, Configuration mrConf, Map<String, String> mrToTezConfigMapping) {
        for (Map.Entry<String, String> dep : mrToTezConfigMapping.entrySet()) {
            if (mrConf.get(dep.getKey()) == null) continue;
            if (tezConf.get(dep.getValue()) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting " + dep.getValue() + " to " + mrConf.get(dep.getKey()) + " from MR setting " + dep.getKey()));
                }
                tezConf.set(dep.getValue(), mrConf.get(dep.getKey()));
            }
            tezConf.unset(dep.getKey());
        }
    }

    public static InputSplitInfoDisk writeInputSplitInfoToDisk(InputSplitInfoMem infoMem, Path inputSplitsDir, JobConf jobConf, FileSystem fs) throws IOException, InterruptedException {
        InputSplit[] splits = infoMem.getNewFormatSplits();
        JobSplitWriter.createSplitFiles((Path)inputSplitsDir, (Configuration)jobConf, (FileSystem)fs, (InputSplit[])splits);
        return new InputSplitInfoDisk(JobSubmissionFiles.getJobSplitFile((Path)inputSplitsDir), JobSubmissionFiles.getJobSplitMetaFile((Path)inputSplitsDir), splits.length, infoMem.getTaskLocationHints(), jobConf.getCredentials());
    }

    public static void updateLocalResourcesForInputSplits(FileSystem fs, InputSplitInfo inputSplitInfo, Map<String, LocalResource> localResources) throws IOException {
        if (localResources.containsKey(JOB_SPLIT_RESOURCE_NAME)) {
            throw new RuntimeException("LocalResources already contains a resource named job.split");
        }
        if (localResources.containsKey(JOB_SPLIT_METAINFO_RESOURCE_NAME)) {
            throw new RuntimeException("LocalResources already contains a resource named job.splitmetainfo");
        }
        FileStatus splitFileStatus = fs.getFileStatus(inputSplitInfo.getSplitsFile());
        FileStatus metaInfoFileStatus = fs.getFileStatus(inputSplitInfo.getSplitsMetaInfoFile());
        localResources.put(JOB_SPLIT_RESOURCE_NAME, LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)inputSplitInfo.getSplitsFile()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)splitFileStatus.getLen(), (long)splitFileStatus.getModificationTime()));
        localResources.put(JOB_SPLIT_METAINFO_RESOURCE_NAME, LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)inputSplitInfo.getSplitsMetaInfoFile()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)metaInfoFileStatus.getLen(), (long)metaInfoFileStatus.getModificationTime()));
    }

    static {
        MRToTezHelper.populateMRToTezParamsMap();
        MRToTezHelper.populateMRSettingsToRetain();
        MRToTezHelper.populateMRSettingsToRemove();
    }
}

