/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.InputSizeReducerEstimator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigInputFormat;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POSimpleTezLoad;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;

public class LoaderProcessor
extends TezOpPlanVisitor {
    private static final Log LOG = LogFactory.getLog(LoaderProcessor.class);
    private TezOperPlan tezOperPlan;
    private JobConf jobConf;
    private PigContext pc;

    public LoaderProcessor(TezOperPlan plan, PigContext pigContext) throws VisitorException {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        this.tezOperPlan = plan;
        this.pc = pigContext;
        this.jobConf = new JobConf(ConfigurationUtil.toConfiguration(this.pc.getProperties()));
        this.jobConf.setCredentials(this.tezOperPlan.getCredentials());
        this.jobConf.setBoolean("mapred.mapper.new-api", true);
        this.jobConf.setClass("mapreduce.inputformat.class", PigInputFormat.class, InputFormat.class);
    }

    private List<POLoad> processLoads(TezOperator tezOp) throws VisitorException, IOException, ClassNotFoundException, InterruptedException {
        ArrayList<FileSpec> inp = new ArrayList<FileSpec>();
        ArrayList inpTargets = new ArrayList();
        ArrayList<String> inpSignatureLists = new ArrayList<String>();
        ArrayList<Long> inpLimits = new ArrayList<Long>();
        LinkedList<POLoad> lds = PlanHelper.getPhysicalOperators(tezOp.plan, POLoad.class);
        Job job = Job.getInstance((Configuration)this.jobConf);
        Configuration conf = job.getConfiguration();
        if (lds != null && lds.size() > 0) {
            if (lds.size() == 1) {
                for (POLoad ld : lds) {
                    LoadFunc lf = ld.getLoadFunc();
                    lf.setLocation(ld.getLFile().getFileName(), job);
                    inp.add(ld.getLFile());
                }
            } else {
                throw new VisitorException("There is more than one load for TezOperator " + tezOp);
            }
        }
        if (lds != null && lds.size() > 0) {
            for (POLoad ld : lds) {
                ArrayList<POLoad> ldSucs = new ArrayList<POLoad>(tezOp.plan.getSuccessors(ld));
                ArrayList<OperatorKey> ldSucKeys = new ArrayList<OperatorKey>();
                if (ldSucs != null) {
                    for (PhysicalOperator physicalOperator : ldSucs) {
                        ldSucKeys.add(physicalOperator.getOperatorKey());
                    }
                }
                inpTargets.add(ldSucKeys);
                inpSignatureLists.add(ld.getSignature());
                inpLimits.add(ld.getLimit());
                tezOp.plan.remove(ld);
                POSimpleTezLoad tezLoad = new POSimpleTezLoad(ld.getOperatorKey(), ld.getLoadFunc());
                tezLoad.setLFile(ld.getLFile());
                tezLoad.setSignature(ld.getSignature());
                tezLoad.setInputKey(ld.getOperatorKey().toString());
                tezLoad.copyAliasFrom(ld);
                tezLoad.setCacheFiles(ld.getCacheFiles());
                tezLoad.setShipFiles(ld.getShipFiles());
                tezOp.plan.add(tezLoad);
                for (PhysicalOperator physicalOperator : ldSucs) {
                    tezOp.plan.connect(tezLoad, physicalOperator);
                }
            }
            UDFContext.getUDFContext().serialize(conf);
            conf.set("udf.import.list", ObjectSerializer.serialize(PigContext.getPackageImportList()));
            conf.set("pig.inputs", ObjectSerializer.serialize(inp));
            conf.set("pig.inpTargets", ObjectSerializer.serialize(inpTargets));
            conf.set("pig.inpSignatures", ObjectSerializer.serialize(inpSignatureLists));
            conf.set("pig.inpLimits", ObjectSerializer.serialize(inpLimits));
            long maxCombinedSplitSize = 0L;
            if (!tezOp.combineSmallSplits() || this.pc.getProperties().getProperty("pig.splitCombination", "true").equals("false")) {
                conf.setBoolean("pig.noSplitCombination", true);
            } else {
                String tmp = this.pc.getProperties().getProperty("pig.maxCombinedSplitSize", null);
                if (tmp != null) {
                    try {
                        maxCombinedSplitSize = Long.parseLong(tmp);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn((Object)"Invalid numeric format for pig.maxCombinedSplitSize; use the default maximum combined split size");
                    }
                }
            }
            if (maxCombinedSplitSize > 0L) {
                conf.setLong("pig.maxCombinedSplitSize", maxCombinedSplitSize);
            }
            tezOp.getLoaderInfo().setInpSignatureLists(inpSignatureLists);
            tezOp.getLoaderInfo().setInp(inp);
            tezOp.getLoaderInfo().setInpLimits(inpLimits);
            tezOp.getLoaderInfo().setInputSplitInfo((InputSplitInfo)MRInputHelpers.generateInputSplitsToMem((Configuration)conf, (boolean)false, (int)0));
            int parallelism = tezOp.getLoaderInfo().getInputSplitInfo().getNumTasks();
            tezOp.setRequestedParallelism(parallelism);
            tezOp.setTotalInputFilesSize(InputSizeReducerEstimator.getTotalInputFileSize(conf, lds, job));
        }
        return lds;
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        try {
            tezOp.getLoaderInfo().setLoads(this.processLoads(tezOp));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new VisitorException(e);
        }
    }
}

