/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.operator;

import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.OperatorKey;

public class POReduceBySpark
extends POForEach {
    private String customPartitioner;
    protected POLocalRearrange lr;
    protected POPackage pkg;
    private boolean useSecondaryKey;
    private boolean[] secondarySortOrder;

    public POReduceBySpark(OperatorKey k, int rp, List<PhysicalPlan> inp, List<Boolean> isToBeFlattened, POPackage pkg, POLocalRearrange lr) {
        super(k, rp, inp, isToBeFlattened);
        this.pkg = pkg;
        this.lr = lr;
        this.addOriginalLocation(lr.getAlias(), lr.getOriginalLocations());
    }

    public POPackage getPKGOp() {
        return this.pkg;
    }

    @Override
    public String name() {
        return this.getAliasString() + "Reduce By(" + this.getFlatStr() + ")[" + DataType.findTypeName(this.resultType) + "] - " + this.mKey.toString();
    }

    protected String getFlatStr() {
        if (this.isToBeFlattenedArray == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean[] blArray = this.isToBeFlattenedArray;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean b = blArray[i];
            sb.append(b);
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public boolean isUseSecondaryKey() {
        return this.useSecondaryKey;
    }

    public void setUseSecondaryKey(boolean useSecondaryKey) {
        this.useSecondaryKey = useSecondaryKey;
    }

    public boolean[] getSecondarySortOrder() {
        return this.secondarySortOrder;
    }

    public void setSecondarySortOrder(boolean[] secondarySortOrder) {
        this.secondarySortOrder = secondarySortOrder;
    }

    public String getCustomPartitioner() {
        return this.customPartitioner;
    }

    public void setCustomPartitioner(String customPartitioner) {
        this.customPartitioner = customPartitioner;
    }

    public POLocalRearrange getLROp() {
        return this.lr;
    }
}

