/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.OutputConsumerIterator;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.rdd.RDD;

public class MergeJoinConverter
implements RDDConverter<Tuple, Tuple, POMergeJoin> {
    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POMergeJoin poMergeJoin) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, poMergeJoin, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        MergeJoinFunction mergeJoinFunction = new MergeJoinFunction(poMergeJoin);
        return rdd.toJavaRDD().mapPartitions((FlatMapFunction)mergeJoinFunction, true).rdd();
    }

    private static class MergeJoinFunction
    implements FlatMapFunction<Iterator<Tuple>, Tuple>,
    Serializable {
        private POMergeJoin poMergeJoin;

        private MergeJoinFunction(POMergeJoin poMergeJoin) {
            this.poMergeJoin = poMergeJoin;
        }

        public Iterable<Tuple> call(final Iterator<Tuple> input) {
            return new Iterable<Tuple>(){

                @Override
                public Iterator<Tuple> iterator() {
                    return new OutputConsumerIterator(input){

                        @Override
                        protected void attach(Tuple tuple) {
                            MergeJoinFunction.this.poMergeJoin.setInputs(null);
                            MergeJoinFunction.this.poMergeJoin.attachInput(tuple);
                        }

                        @Override
                        protected Result getNextResult() throws ExecException {
                            return MergeJoinFunction.this.poMergeJoin.getNextTuple();
                        }

                        @Override
                        protected void endOfInput() {
                            MergeJoinFunction.this.poMergeJoin.setEndOfInput(true);
                        }
                    };
                }
            };
        }
    }
}

