/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POFRJoinTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POStoreTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueOutputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.udf.ReadScalarsTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.HashValuePartitioner;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.builtin.TOBAG;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.apache.tez.runtime.library.output.UnorderedKVOutput;
import org.apache.tez.runtime.library.output.UnorderedPartitionedKVOutput;

public class TezCompilerUtil {
    public static String TUPLE_CLASS = TupleFactory.getInstance().tupleClass().getName();

    private TezCompilerUtil() {
    }

    public static void simpleConnectTwoVertex(TezOperPlan tezPlan, TezOperator op1, TezOperator op2, String scope, NodeIdGenerator nig) throws PlanException {
        PhysicalPlan ep = new PhysicalPlan();
        POProject prjStar = new POProject(new OperatorKey(scope, nig.getNextNodeId(scope)));
        prjStar.setResultType((byte)110);
        prjStar.setStar(true);
        ep.add(prjStar);
        ArrayList<PhysicalPlan> eps = new ArrayList<PhysicalPlan>();
        eps.add(ep);
        POLocalRearrangeTez lr = new POLocalRearrangeTez(new OperatorKey(scope, nig.getNextNodeId(scope)));
        try {
            lr.setIndex(0);
        }
        catch (ExecException e) {
            int errCode = 2058;
            String msg = "Unable to set index on the newly created POLocalRearrange.";
            throw new PlanException(msg, errCode, 4, (Throwable)e);
        }
        lr.setKeyType((byte)110);
        lr.setPlans(eps);
        lr.setResultType((byte)110);
        lr.setOutputKey(op2.getOperatorKey().toString());
        op1.plan.addAsLeaf(lr);
        POPackage pkg = new POPackage(new OperatorKey(scope, nig.getNextNodeId(scope)));
        pkg.getPkgr().setKeyType((byte)110);
        pkg.setNumInps(1);
        boolean[] inner = new boolean[]{false};
        pkg.getPkgr().setInner(inner);
        op2.plan.add(pkg);
        op2.plan.addAsLeaf(TezCompilerUtil.getForEachPlain(scope, nig));
        TezCompilerUtil.connect(tezPlan, op1, op2);
    }

    public static TezEdgeDescriptor connect(TezOperPlan plan, TezOperator from, TezOperator to) throws PlanException {
        PhysicalOperator leaf;
        plan.connect(from, to);
        if (!from.plan.isEmpty() && (leaf = (PhysicalOperator)from.plan.getLeaves().get(0)) instanceof POLocalRearrangeTez) {
            POLocalRearrangeTez lr = (POLocalRearrangeTez)leaf;
            lr.setOutputKey(to.getOperatorKey().toString());
        }
        TezEdgeDescriptor edge = new TezEdgeDescriptor();
        to.inEdges.put(from.getOperatorKey(), edge);
        from.outEdges.put(to.getOperatorKey(), edge);
        return edge;
    }

    public static void connect(TezOperPlan plan, TezOperator from, TezOperator to, TezEdgeDescriptor edge) throws PlanException {
        plan.connect(from, to);
        to.inEdges.put(from.getOperatorKey(), edge);
        from.outEdges.put(to.getOperatorKey(), edge);
    }

    public static void connectTezOpToNewPredecessor(TezOperPlan plan, TezOperator tezOp, TezOperator newPredecessor, TezEdgeDescriptor edge, String oldInputKey) throws PlanException {
        plan.connect(newPredecessor, tezOp);
        tezOp.inEdges.put(newPredecessor.getOperatorKey(), edge);
        newPredecessor.outEdges.put(tezOp.getOperatorKey(), edge);
        if (oldInputKey != null) {
            TezCompilerUtil.replaceInput(tezOp, oldInputKey, newPredecessor.getOperatorKey().toString());
        }
    }

    public static void replaceInput(TezOperator tezOp, String oldInputKey, String newInputKey) throws PlanException {
        try {
            LinkedList<TezInput> inputs = PlanHelper.getPhysicalOperators(tezOp.plan, TezInput.class);
            for (TezInput input : inputs) {
                input.replaceInput(oldInputKey, newInputKey);
            }
            LinkedList<POUserFunc> userFuncs = PlanHelper.getPhysicalOperators(tezOp.plan, POUserFunc.class);
            for (POUserFunc userFunc : userFuncs) {
                if (!(userFunc.getFunc() instanceof ReadScalarsTez)) continue;
                TezInput input = (TezInput)((Object)userFunc.getFunc());
                input.replaceInput(oldInputKey, newInputKey);
                userFunc.getFuncSpec().setCtorArgs(input.getTezInputs());
            }
        }
        catch (VisitorException e) {
            throw new PlanException(e);
        }
    }

    public static void connectTezOpToNewSuccesor(TezOperPlan plan, TezOperator tezOp, TezOperator newSuccessor, TezEdgeDescriptor edge, String oldOutputKey) throws PlanException {
        plan.connect(tezOp, newSuccessor);
        newSuccessor.inEdges.put(tezOp.getOperatorKey(), edge);
        tezOp.outEdges.put(newSuccessor.getOperatorKey(), edge);
        if (oldOutputKey != null) {
            TezCompilerUtil.replaceOutput(tezOp, oldOutputKey, newSuccessor.getOperatorKey().toString());
        }
    }

    public static void replaceOutput(TezOperator tezOp, String oldOutputKey, String newOutputKey) throws PlanException {
        try {
            LinkedList<TezOutput> tezOutputs = PlanHelper.getPhysicalOperators(tezOp.plan, TezOutput.class);
            for (TezOutput tezOut : tezOutputs) {
                if (!ArrayUtils.contains((Object[])tezOut.getTezOutputs(), (Object)oldOutputKey)) continue;
                tezOut.replaceOutput(oldOutputKey, newOutputKey);
            }
        }
        catch (VisitorException e) {
            throw new PlanException(e);
        }
    }

    public static boolean isNonPackageInput(String inputKey, TezOperator tezOp) throws PlanException {
        try {
            LinkedList<POFRJoinTez> inputs = PlanHelper.getPhysicalOperators(tezOp.plan, POFRJoinTez.class);
            for (POFRJoinTez input : inputs) {
                if (!ArrayUtils.contains((Object[])input.getTezInputs(), (Object)inputKey)) continue;
                return true;
            }
            LinkedList<POUserFunc> userFuncs = PlanHelper.getPhysicalOperators(tezOp.plan, POUserFunc.class);
            for (POUserFunc userFunc : userFuncs) {
                TezInput input;
                if (!(userFunc.getFunc() instanceof ReadScalarsTez) || !ArrayUtils.contains((Object[])(input = (TezInput)((Object)userFunc.getFunc())).getTezInputs(), (Object)inputKey)) continue;
                return true;
            }
            return false;
        }
        catch (VisitorException e) {
            throw new PlanException(e);
        }
    }

    public static POForEach getForEach(POProject project, int rp, String scope, NodeIdGenerator nig) {
        PhysicalPlan forEachPlan = new PhysicalPlan();
        forEachPlan.add(project);
        ArrayList forEachPlans = Lists.newArrayList();
        forEachPlans.add(forEachPlan);
        ArrayList flatten = Lists.newArrayList();
        flatten.add(true);
        POForEach forEach = new POForEach(new OperatorKey(scope, nig.getNextNodeId(scope)), rp, forEachPlans, flatten);
        forEach.setResultType((byte)120);
        return forEach;
    }

    public static POForEach getForEachPlain(String scope, NodeIdGenerator nig) {
        POProject project = new POProject(new OperatorKey(scope, nig.getNextNodeId(scope)));
        project.setResultType((byte)110);
        project.setStar(false);
        project.setColumn(1);
        project.setOverloaded(true);
        return TezCompilerUtil.getForEach(project, -1, scope, nig);
    }

    public static POStore getStore(String scope, NodeIdGenerator nig) {
        POStoreTez st = new POStoreTez(new OperatorKey(scope, nig.getNextNodeId(scope)));
        st.setIsTmpStore(true);
        return st;
    }

    public static void setCustomPartitioner(String customPartitioner, TezOperator tezOp) throws IOException {
        if (customPartitioner != null) {
            for (TezEdgeDescriptor edge : tezOp.inEdges.values()) {
                edge.partitionerClass = PigContext.resolveClassName(customPartitioner);
            }
        }
    }

    public static void configureValueOnlyTupleOutput(TezEdgeDescriptor edge, EdgeProperty.DataMovementType dataMovementType) {
        edge.dataMovementType = dataMovementType;
        if (dataMovementType == EdgeProperty.DataMovementType.BROADCAST || dataMovementType == EdgeProperty.DataMovementType.ONE_TO_ONE) {
            edge.outputClassName = UnorderedKVOutput.class.getName();
            edge.inputClassName = UnorderedKVInput.class.getName();
        } else if (dataMovementType == EdgeProperty.DataMovementType.SCATTER_GATHER) {
            edge.outputClassName = UnorderedPartitionedKVOutput.class.getName();
            edge.inputClassName = UnorderedKVInput.class.getName();
            edge.partitionerClass = HashValuePartitioner.class;
        }
        edge.setIntermediateOutputKeyClass(POValueOutputTez.EmptyWritable.class.getName());
        edge.setIntermediateOutputValueClass(TUPLE_CLASS);
    }

    public static boolean bagDataTypeInCombinePlan(PhysicalPlan combinePlan) throws ExecException {
        PhysicalOperator lr = (PhysicalOperator)combinePlan.getLeaves().get(0);
        POForEach fe = (POForEach)combinePlan.getPredecessors(lr).get(0);
        Type dataBagType = new TOBAG().getReturnType();
        List<PhysicalPlan> inputPlans = fe.getInputPlans();
        for (PhysicalPlan inputPlan : inputPlans) {
            POUserFunc func;
            PhysicalOperator leaf = (PhysicalOperator)inputPlan.getLeaves().get(0);
            if (leaf.getResultType() == 120) {
                return true;
            }
            if (!(leaf instanceof POUserFunc) || !dataBagType.equals((func = (POUserFunc)leaf).getOriginalReturnType())) continue;
            return true;
        }
        return false;
    }
}

