/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.StoreFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POStoreTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueOutputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.udf.ReadScalarsTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.backend.hadoop.executionengine.tez.util.TezCompilerUtil;
import org.apache.pig.backend.hadoop.hbase.HBaseStorage;
import org.apache.pig.builtin.AvroStorage;
import org.apache.pig.builtin.JsonStorage;
import org.apache.pig.builtin.OrcStorage;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.builtin.RoundRobinPartitioner;
import org.apache.pig.builtin.mock.Storage;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.ReverseDependencyOrderWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.apache.tez.runtime.library.output.UnorderedPartitionedKVOutput;

public class UnionOptimizer
extends TezOpPlanVisitor {
    private static final Log LOG = LogFactory.getLog(UnionOptimizer.class);
    private TezOperPlan tezPlan;
    private static Set<String> builtinSupportedStoreFuncs = new HashSet<String>();
    private List<String> supportedStoreFuncs;
    private List<String> unsupportedStoreFuncs;

    public UnionOptimizer(TezOperPlan plan, List<String> supportedStoreFuncs, List<String> unsupportedStoreFuncs) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new ReverseDependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        this.tezPlan = plan;
        this.supportedStoreFuncs = supportedStoreFuncs;
        this.unsupportedStoreFuncs = unsupportedStoreFuncs;
    }

    public static boolean isOptimizable(TezOperator tezOp) throws VisitorException {
        if ((tezOp.isLimit() || tezOp.isLimitAfterSort()) && tezOp.getRequestedParallelism() == 1) {
            return false;
        }
        if (tezOp.getRequestedParallelism() != -1) {
            return false;
        }
        return !tezOp.isRankCounter();
    }

    public static boolean isOptimizableStoreFunc(TezOperator tezOp, List<String> supportedStoreFuncs, List<String> unsupportedStoreFuncs) throws VisitorException {
        LinkedList<POStoreTez> stores = PlanHelper.getPhysicalOperators(tezOp.plan, POStoreTez.class);
        for (POStoreTez store : stores) {
            StoreFunc func;
            String name = store.getStoreFunc().getClass().getName();
            if (store.getStoreFunc() instanceof StoreFunc && (func = (StoreFunc)store.getStoreFunc()).supportsParallelWriteToStoreLocation() != null) {
                if (func.supportsParallelWriteToStoreLocation().booleanValue()) continue;
                LOG.warn((Object)(name + " does not support union optimization." + " Disabling it. There will be some performance degradation."));
                return false;
            }
            if (supportedStoreFuncs == null && unsupportedStoreFuncs == null) continue;
            if (unsupportedStoreFuncs != null && unsupportedStoreFuncs.contains(name)) {
                return false;
            }
            if (supportedStoreFuncs == null || supportedStoreFuncs.contains(name) || builtinSupportedStoreFuncs.contains(name)) continue;
            LOG.warn((Object)("pig.tez.opt.union.supported.storefuncs does not contain " + name + " and so disabling union optimization. There will be some performance degradation. " + "If your storefunc does not hardcode part file names and can work with multiple vertices writing to the output location," + " run pig with -D" + "pig.tez.opt.union.supported.storefuncs" + "=<Comma separated list of fully qualified StoreFunc class names> to enable the optimization. Refer PIG-4691"));
            return false;
        }
        return true;
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        ArrayList<TezOperator> successors;
        if (!tezOp.isUnion()) {
            return;
        }
        if (!UnionOptimizer.isOptimizable(tezOp)) {
            return;
        }
        TezOperator unionOp = tezOp;
        String scope = unionOp.getOperatorKey().scope;
        PhysicalPlan unionOpPlan = unionOp.plan;
        HashSet<OperatorKey> uniqueUnionMembers = new HashSet<OperatorKey>(unionOp.getUnionMembers());
        ArrayList<TezOperator> predecessors = new ArrayList<TezOperator>(this.tezPlan.getPredecessors(unionOp));
        ArrayList<TezOperator> arrayList = successors = this.tezPlan.getSuccessors(unionOp) == null ? null : new ArrayList<TezOperator>(this.tezPlan.getSuccessors(unionOp));
        if (uniqueUnionMembers.size() != 1) {
            if (!UnionOptimizer.isOptimizableStoreFunc(tezOp, this.supportedStoreFuncs, this.unsupportedStoreFuncs)) {
                return;
            }
            if (successors != null) {
                for (TezOperator succ : successors) {
                    for (TezOperator pred : predecessors) {
                        if (!succ.inEdges.containsKey(pred.getOperatorKey())) continue;
                        return;
                    }
                }
            }
            if (predecessors.size() > unionOp.getUnionMembers().size()) {
                return;
            }
        }
        if (uniqueUnionMembers.size() == 1) {
            OperatorKey splitPredKey = (OperatorKey)uniqueUnionMembers.iterator().next();
            TezOperator splitPredOp = (TezOperator)this.tezPlan.getOperator(splitPredKey);
            PhysicalPlan splitPredPlan = splitPredOp.plan;
            if (splitPredPlan.getLeaves().get(0) instanceof POSplit) {
                try {
                    this.connectUnionNonMemberPredecessorsToSplit(unionOp, splitPredOp, predecessors);
                    unionOpPlan.remove((PhysicalOperator)unionOpPlan.getRoots().get(0));
                    for (int i = 0; i < Collections.frequency(unionOp.getUnionMembers(), splitPredKey); ++i) {
                        this.cloneAndMergeUnionPlan(unionOp, splitPredOp);
                    }
                    this.copyOperatorProperties(splitPredOp, unionOp);
                    this.tezPlan.disconnect(splitPredOp, unionOp);
                    this.connectSplitOpToUnionSuccessors(unionOp, splitPredOp, successors);
                }
                catch (PlanException e) {
                    throw new VisitorException(e);
                }
                this.tezPlan.remove(unionOp);
                return;
            }
            throw new VisitorException("Expected POSplit but found " + splitPredPlan.getLeaves().get(0));
        }
        LinkedList<POStoreTez> unionStoreOutputs = PlanHelper.getPhysicalOperators(unionOpPlan, POStoreTez.class);
        TezOperator[] storeVertexGroupOps = new TezOperator[unionStoreOutputs.size()];
        for (int i = 0; i < storeVertexGroupOps.length; ++i) {
            TezOperator existingVertexGroup = null;
            if (successors != null) {
                for (TezOperator succ : successors) {
                    if (!succ.isVertexGroup() || !((POStoreTez)unionStoreOutputs.get(i)).getSFile().equals(succ.getVertexGroupInfo().getSFile())) continue;
                    existingVertexGroup = succ;
                }
            }
            if (existingVertexGroup != null) {
                storeVertexGroupOps[i] = existingVertexGroup;
                existingVertexGroup.getVertexGroupMembers().remove(unionOp.getOperatorKey());
                existingVertexGroup.getVertexGroupMembers().addAll(unionOp.getUnionMembers());
                existingVertexGroup.getVertexGroupInfo().removeInput(unionOp.getOperatorKey());
                continue;
            }
            storeVertexGroupOps[i] = new TezOperator(OperatorKey.genOpKey(scope));
            storeVertexGroupOps[i].setVertexGroupInfo(new TezOperator.VertexGroupInfo((POStore)unionStoreOutputs.get(i)));
            storeVertexGroupOps[i].getVertexGroupInfo().setSFile(((POStoreTez)unionStoreOutputs.get(i)).getSFile());
            storeVertexGroupOps[i].setVertexGroupMembers(new ArrayList<OperatorKey>(unionOp.getUnionMembers()));
            this.tezPlan.add(storeVertexGroupOps[i]);
        }
        LinkedList<TezOutput> unionOutputs = PlanHelper.getPhysicalOperators(unionOpPlan, TezOutput.class);
        ArrayList<String> unionOutputKeys = new ArrayList<String>();
        for (TezOutput output : unionOutputs) {
            if (output instanceof POStoreTez) continue;
            for (String key : output.getTezOutputs()) {
                unionOutputKeys.add(key);
            }
        }
        TezOperator[] outputVertexGroupOps = new TezOperator[unionOutputKeys.size()];
        String[] newOutputKeys = new String[unionOutputKeys.size()];
        for (int i = 0; i < outputVertexGroupOps.length; ++i) {
            outputVertexGroupOps[i] = new TezOperator(OperatorKey.genOpKey(scope));
            outputVertexGroupOps[i].setVertexGroupInfo(new TezOperator.VertexGroupInfo());
            outputVertexGroupOps[i].getVertexGroupInfo().setOutput((String)unionOutputKeys.get(i));
            outputVertexGroupOps[i].setVertexGroupMembers(new ArrayList<OperatorKey>(unionOp.getUnionMembers()));
            newOutputKeys[i] = outputVertexGroupOps[i].getOperatorKey().toString();
            this.tezPlan.add(outputVertexGroupOps[i]);
        }
        try {
            unionOpPlan.remove((PhysicalOperator)unionOpPlan.getRoots().get(0));
            for (OperatorKey predKey : unionOp.getUnionMembers()) {
                TezOperator pred = (TezOperator)this.tezPlan.getOperator(predKey);
                PhysicalPlan clonePlan = this.cloneAndMergeUnionPlan(unionOp, pred);
                this.connectPredecessorsToVertexGroups(unionOp, pred, clonePlan, storeVertexGroupOps, outputVertexGroupOps);
            }
            this.connectVertexGroupsToSuccessors(unionOp, successors, unionOutputKeys, outputVertexGroupOps);
            this.replaceSuccessorInputsAndDisconnect(unionOp, successors, unionOutputKeys, newOutputKeys);
            this.tezPlan.remove(unionOp);
        }
        catch (VisitorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VisitorException(e);
        }
    }

    private void connectUnionNonMemberPredecessorsToSplit(TezOperator unionOp, TezOperator splitPredOp, List<TezOperator> unionPredecessors) throws PlanException, VisitorException {
        String unionOpKey = unionOp.getOperatorKey().toString();
        OperatorKey splitPredKey = splitPredOp.getOperatorKey();
        for (TezOperator pred : unionPredecessors) {
            if (pred.getOperatorKey().equals(splitPredKey)) continue;
            TezOperator predVertexGroup = null;
            ArrayList actualPreds = new ArrayList();
            if (pred.isVertexGroup()) {
                predVertexGroup = pred;
                for (OperatorKey opKey : pred.getVertexGroupMembers()) {
                    actualPreds.add(this.tezPlan.getOperator(opKey));
                }
                this.tezPlan.disconnect(predVertexGroup, unionOp);
                this.tezPlan.connect(predVertexGroup, splitPredOp);
            } else {
                actualPreds.add(pred);
            }
            for (TezOperator actualPred : actualPreds) {
                TezCompilerUtil.replaceOutput(actualPred, unionOpKey, splitPredKey.toString());
                TezEdgeDescriptor edge = actualPred.outEdges.remove(unionOp.getOperatorKey());
                if (edge == null) {
                    throw new VisitorException("Edge description is empty");
                }
                actualPred.outEdges.put(splitPredKey, edge);
                splitPredOp.inEdges.put(actualPred.getOperatorKey(), edge);
                if (predVertexGroup != null) continue;
                this.tezPlan.disconnect(actualPred, unionOp);
                this.tezPlan.connect(actualPred, splitPredOp);
            }
        }
    }

    private void connectSplitOpToUnionSuccessors(TezOperator unionOp, TezOperator splitPredOp, List<TezOperator> successors) throws PlanException, VisitorException {
        String unionOpKey = unionOp.getOperatorKey().toString();
        String splitPredOpKey = splitPredOp.getOperatorKey().toString();
        List<TezOperator> splitSuccessors = this.tezPlan.getSuccessors(splitPredOp);
        if (successors != null) {
            for (TezOperator succ : successors) {
                TezOperator successorVertexGroup = null;
                boolean removeSuccessorVertexGroup = false;
                ArrayList<TezOperator> actualSuccs = new ArrayList<TezOperator>();
                if (succ.isVertexGroup()) {
                    successorVertexGroup = succ;
                    if (this.tezPlan.getSuccessors(successorVertexGroup) != null) {
                        actualSuccs.addAll(this.tezPlan.getSuccessors(successorVertexGroup));
                    }
                    int index = succ.getVertexGroupMembers().indexOf(unionOp.getOperatorKey());
                    while (index > -1) {
                        succ.getVertexGroupMembers().set(index, splitPredOp.getOperatorKey());
                        index = succ.getVertexGroupMembers().indexOf(unionOp.getOperatorKey());
                    }
                    POStore store = successorVertexGroup.getVertexGroupInfo().getStore();
                    if (store != null) {
                        LinkedList<POStoreTez> storeOutputs = PlanHelper.getPhysicalOperators(splitPredOp.plan, POStoreTez.class);
                        for (POStoreTez storeOut : storeOutputs) {
                            if (!storeOut.getOutputKey().equals(store.getOperatorKey().toString())) continue;
                            splitPredOp.addVertexGroupStore(storeOut.getOperatorKey(), successorVertexGroup.getOperatorKey());
                        }
                    }
                    this.tezPlan.disconnect(unionOp, successorVertexGroup);
                    HashSet<OperatorKey> uniqueVertexGroupMembers = new HashSet<OperatorKey>(succ.getVertexGroupMembers());
                    if (uniqueVertexGroupMembers.size() == 1) {
                        removeSuccessorVertexGroup = true;
                    } else if (splitSuccessors == null || !splitSuccessors.contains(successorVertexGroup)) {
                        this.tezPlan.connect(splitPredOp, successorVertexGroup);
                    }
                } else {
                    actualSuccs.add(succ);
                }
                if (actualSuccs.isEmpty() && removeSuccessorVertexGroup) {
                    splitPredOp.removeVertexGroupStore(successorVertexGroup.getOperatorKey());
                    this.tezPlan.remove(successorVertexGroup);
                }
                for (TezOperator actualSucc : actualSuccs) {
                    TezCompilerUtil.replaceInput(actualSucc, unionOpKey, splitPredOpKey);
                    TezEdgeDescriptor edge = actualSucc.inEdges.remove(unionOp.getOperatorKey());
                    if (edge == null) {
                        throw new VisitorException("Edge description is empty");
                    }
                    actualSucc.inEdges.put(splitPredOp.getOperatorKey(), edge);
                    splitPredOp.outEdges.put(actualSucc.getOperatorKey(), edge);
                    if (successorVertexGroup != null && !removeSuccessorVertexGroup) continue;
                    if (removeSuccessorVertexGroup) {
                        this.tezPlan.disconnect(successorVertexGroup, actualSucc);
                        this.tezPlan.remove(successorVertexGroup);
                        TezCompilerUtil.replaceInput(actualSucc, successorVertexGroup.getOperatorKey().toString(), splitPredOpKey);
                    } else {
                        this.tezPlan.disconnect(unionOp, actualSucc);
                    }
                    if (splitSuccessors != null && splitSuccessors.contains(actualSucc)) continue;
                    this.tezPlan.connect(splitPredOp, actualSucc);
                }
            }
        }
    }

    private PhysicalPlan cloneAndMergeUnionPlan(TezOperator unionOp, TezOperator predOp) throws VisitorException {
        try {
            PhysicalPlan predPlan = predOp.plan;
            PhysicalOperator predLeaf = (PhysicalOperator)predPlan.getLeaves().get(0);
            if (predLeaf instanceof POSplit) {
                predPlan = UnionOptimizer.getUnionPredPlanFromSplit(predPlan, unionOp.getOperatorKey().toString());
                predLeaf = (PhysicalOperator)predPlan.getLeaves().get(0);
            }
            PhysicalPlan clonePlan = unionOp.plan.clone();
            predPlan.remove(predLeaf);
            boolean isEmptyPlan = predPlan.isEmpty();
            if (!isEmptyPlan) {
                predLeaf = (PhysicalOperator)predPlan.getLeaves().get(0);
            }
            predPlan.merge(clonePlan);
            if (!isEmptyPlan) {
                predPlan.connect(predLeaf, (PhysicalOperator)clonePlan.getRoots().get(0));
            }
            return clonePlan;
        }
        catch (Exception e) {
            throw new VisitorException(e);
        }
    }

    public void connectPredecessorsToVertexGroups(TezOperator unionOp, TezOperator pred, PhysicalPlan predClonedUnionPlan, TezOperator[] storeVertexGroupOps, TezOperator[] outputVertexGroupOps) throws VisitorException, PlanException {
        LinkedList<POStoreTez> clonedUnionStoreOutputs = PlanHelper.getPhysicalOperators(predClonedUnionPlan, POStoreTez.class);
        int i = 0;
        for (TezOperator storeVertexGroup : storeVertexGroupOps) {
            storeVertexGroup.getVertexGroupInfo().addInput(pred.getOperatorKey());
            pred.addVertexGroupStore(((POStoreTez)clonedUnionStoreOutputs.get(i++)).getOperatorKey(), storeVertexGroup.getOperatorKey());
            this.tezPlan.connect(pred, storeVertexGroup);
        }
        for (TezOperator outputVertexGroup : outputVertexGroupOps) {
            outputVertexGroup.getVertexGroupInfo().addInput(pred.getOperatorKey());
            this.tezPlan.connect(pred, outputVertexGroup);
        }
        this.copyOperatorProperties(pred, unionOp);
        this.tezPlan.disconnect(pred, unionOp);
    }

    private void connectVertexGroupsToSuccessors(TezOperator unionOp, List<TezOperator> successors, List<String> unionOutputKeys, TezOperator[] outputVertexGroupOps) throws PlanException {
        for (Map.Entry<OperatorKey, TezEdgeDescriptor> entry : unionOp.outEdges.entrySet()) {
            TezOperator succOp = (TezOperator)this.tezPlan.getOperator(entry.getKey());
            TezOperator succOpVertexGroup = null;
            for (TezOperator succ : successors) {
                if (!succ.isVertexGroup() || !succOp.getOperatorKey().toString().equals(succ.getVertexGroupInfo().getOutput())) continue;
                succOpVertexGroup = succ;
                break;
            }
            TezEdgeDescriptor edge = entry.getValue();
            if (edge.dataMovementType == EdgeProperty.DataMovementType.ONE_TO_ONE) {
                edge.dataMovementType = EdgeProperty.DataMovementType.SCATTER_GATHER;
                edge.partitionerClass = RoundRobinPartitioner.class;
                edge.outputClassName = UnorderedPartitionedKVOutput.class.getName();
                edge.inputClassName = UnorderedKVInput.class.getName();
            }
            TezOperator vertexGroupOp = outputVertexGroupOps[unionOutputKeys.indexOf(entry.getKey().toString())];
            for (OperatorKey predKey : vertexGroupOp.getVertexGroupMembers()) {
                TezOperator pred = (TezOperator)this.tezPlan.getOperator(predKey);
                pred.outEdges.put(entry.getKey(), edge);
                succOp.inEdges.put(predKey, edge);
                if (succOpVertexGroup == null) continue;
                succOpVertexGroup.getVertexGroupMembers().add(predKey);
                succOpVertexGroup.getVertexGroupInfo().addInput(predKey);
                this.tezPlan.disconnect(pred, vertexGroupOp);
                this.tezPlan.connect(pred, succOpVertexGroup);
            }
            if (succOpVertexGroup != null) {
                succOpVertexGroup.getVertexGroupMembers().remove(unionOp.getOperatorKey());
                succOpVertexGroup.getVertexGroupInfo().removeInput(unionOp.getOperatorKey());
                this.tezPlan.remove(vertexGroupOp);
                continue;
            }
            this.tezPlan.connect(vertexGroupOp, succOp);
        }
    }

    private void replaceSuccessorInputsAndDisconnect(TezOperator unionOp, List<TezOperator> successors, List<String> unionOutputKeys, String[] newOutputKeys) throws VisitorException {
        if (successors != null) {
            String unionOpKey = unionOp.getOperatorKey().toString();
            for (TezOperator succ : successors) {
                LinkedList<TezInput> inputs = PlanHelper.getPhysicalOperators(succ.plan, TezInput.class);
                for (TezInput input : inputs) {
                    for (String key : input.getTezInputs()) {
                        if (!key.equals(unionOpKey)) continue;
                        input.replaceInput(key, newOutputKeys[unionOutputKeys.indexOf(succ.getOperatorKey().toString())]);
                    }
                }
                LinkedList<POUserFunc> userFuncs = PlanHelper.getPhysicalOperators(succ.plan, POUserFunc.class);
                for (POUserFunc userFunc : userFuncs) {
                    if (!(userFunc.getFunc() instanceof ReadScalarsTez)) continue;
                    TezInput tezInput = (TezInput)((Object)userFunc.getFunc());
                    for (String inputKey : tezInput.getTezInputs()) {
                        if (!inputKey.equals(unionOpKey)) continue;
                        tezInput.replaceInput(inputKey, newOutputKeys[unionOutputKeys.indexOf(succ.getOperatorKey().toString())]);
                        userFunc.getFuncSpec().setCtorArgs(tezInput.getTezInputs());
                    }
                }
                this.tezPlan.disconnect(unionOp, succ);
            }
        }
    }

    private void copyOperatorProperties(TezOperator pred, TezOperator unionOp) throws VisitorException {
        pred.UDFs.addAll(unionOp.UDFs);
        pred.scalars.addAll(unionOp.scalars);
        if (unionOp.getCrossKeys() != null) {
            for (String key : unionOp.getCrossKeys()) {
                pred.addCrossKey(key);
            }
        }
        pred.copyFeatures(unionOp, Arrays.asList(TezOperator.OPER_FEATURE.UNION));
        if (unionOp.getSampleOperator() != null) {
            if (pred.getSampleOperator() == null) {
                pred.setSampleOperator(unionOp.getSampleOperator());
            } else if (!pred.getSampleOperator().equals(unionOp.getSampleOperator())) {
                throw new VisitorException("Conflicting sample operators " + pred.getSampleOperator().toString() + " and " + unionOp.getSampleOperator().toString());
            }
        }
    }

    public static PhysicalPlan getUnionPredPlanFromSplit(PhysicalPlan plan, String unionOpKey) throws VisitorException {
        LinkedList<POSplit> splits = PlanHelper.getPhysicalOperators(plan, POSplit.class);
        for (POSplit split : splits) {
            for (PhysicalPlan subPlan : split.getPlans()) {
                POValueOutputTez out;
                if (!(subPlan.getLeaves().get(0) instanceof POValueOutputTez) || !(out = (POValueOutputTez)subPlan.getLeaves().get(0)).containsOutputKey(unionOpKey)) continue;
                return subPlan;
            }
        }
        throw new VisitorException("Did not find the union predecessor in the split plan");
    }

    static {
        builtinSupportedStoreFuncs.add(PigStorage.class.getName());
        builtinSupportedStoreFuncs.add(JsonStorage.class.getName());
        builtinSupportedStoreFuncs.add(OrcStorage.class.getName());
        builtinSupportedStoreFuncs.add(HBaseStorage.class.getName());
        builtinSupportedStoreFuncs.add(AvroStorage.class.getName());
        builtinSupportedStoreFuncs.add("org.apache.pig.piggybank.storage.avro.AvroStorage");
        builtinSupportedStoreFuncs.add("org.apache.pig.piggybank.storage.avro.CSVExcelStorage");
        builtinSupportedStoreFuncs.add(Storage.class.getName());
    }
}

