/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.BitSet;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.HttpConnection;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleUtils.class);
    public static final String SHUFFLE_HANDLER_SERVICE_ID = "mapreduce_shuffle";
    static final ThreadLocal<DecimalFormat> MBPS_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.00");
        }
    };

    public static SecretKey getJobTokenSecretFromTokenBytes(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        SecretKey sk = JobTokenSecretManager.createSecretKey((byte[])jt.getPassword());
        return sk;
    }

    public static ByteBuffer convertJobTokenToBytes(Token<JobTokenIdentifier> jobToken) throws IOException {
        return TezCommonUtils.convertJobTokenToBytes(jobToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deserializeShuffleProviderMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        try {
            int port;
            in.reset(new ByteBuffer[]{meta});
            int n = port = in.readInt();
            return n;
        }
        finally {
            in.close();
        }
    }

    public static void shuffleToMemory(byte[] shuffleData, InputStream input, int decompressedLength, int compressedLength, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, Logger LOG, String identifier) throws IOException {
        try {
            IFile.Reader.readToMemory(shuffleData, input, compressedLength, codec, ifileReadAhead, ifileReadAheadLength);
            LOG.info("Read " + shuffleData.length + " bytes from input for " + identifier);
        }
        catch (IOException ioe) {
            ShuffleUtils.ioCleanup(input);
            throw ioe;
        }
    }

    public static void shuffleToDisk(OutputStream output, String hostIdentifier, InputStream input, long compressedLength, Logger LOG, String identifier) throws IOException {
        long bytesLeft;
        try {
            int n;
            int BYTES_TO_READ = 65536;
            byte[] buf = new byte[65536];
            for (bytesLeft = compressedLength; bytesLeft > 0L; bytesLeft -= (long)n) {
                n = input.read(buf, 0, (int)Math.min(bytesLeft, 65536L));
                if (n < 0) {
                    throw new IOException("read past end of stream reading " + identifier);
                }
                output.write(buf, 0, n);
            }
            LOG.info("Read " + (compressedLength - bytesLeft) + " bytes from input for " + identifier);
            output.close();
        }
        catch (IOException ioe) {
            ShuffleUtils.ioCleanup(input, output);
            throw ioe;
        }
        if (bytesLeft != 0L) {
            throw new IOException("Incomplete map output received for " + identifier + " from " + hostIdentifier + " (" + bytesLeft + " bytes missing of " + compressedLength + ")");
        }
    }

    public static void ioCleanup(Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Exception in closing " + c, (Throwable)e);
            }
        }
    }

    public static StringBuilder constructBaseURIForShuffleHandler(String host, int port, int partition, String appId, boolean sslShuffle) {
        return ShuffleUtils.constructBaseURIForShuffleHandler(host + ":" + String.valueOf(port), partition, appId, sslShuffle);
    }

    public static StringBuilder constructBaseURIForShuffleHandler(String hostIdentifier, int partition, String appId, boolean sslShuffle) {
        String http_protocol = sslShuffle ? "https://" : "http://";
        StringBuilder sb = new StringBuilder(http_protocol);
        sb.append(hostIdentifier);
        sb.append("/");
        sb.append("mapOutput?job=");
        sb.append(appId.replace("application", "job"));
        sb.append("&reduce=");
        sb.append(String.valueOf(partition));
        sb.append("&map=");
        return sb;
    }

    public static URL constructInputURL(String baseURI, List<InputAttemptIdentifier> inputs, boolean keepAlive) throws MalformedURLException {
        StringBuilder url = new StringBuilder(baseURI);
        boolean first = true;
        for (InputAttemptIdentifier input : inputs) {
            if (first) {
                first = false;
                url.append(input.getPathComponent());
                continue;
            }
            url.append(",").append(input.getPathComponent());
        }
        if (keepAlive) {
            url.append("&keepAlive=true");
        }
        return new URL(url.toString());
    }

    public static HttpConnection.HttpConnectionParams constructHttpShuffleConnectionParams(Configuration conf) {
        HttpConnection.HttpConnectionParamsBuilder builder = new HttpConnection.HttpConnectionParamsBuilder();
        int connectionTimeout = conf.getInt("tez.runtime.shuffle.connect.timeout", 180000);
        int readTimeout = conf.getInt("tez.runtime.shuffle.read.timeout", 180000);
        int bufferSize = conf.getInt("tez.runtime.shuffle.buffersize", 8192);
        boolean keepAlive = conf.getBoolean("tez.runtime.shuffle.keep-alive.enabled", false);
        int keepAliveMaxConnections = conf.getInt("tez.runtime.shuffle.keep-alive.max.connections", 20);
        if (keepAlive) {
            System.setProperty("sun.net.http.errorstream.enableBuffering", "true");
            System.setProperty("http.maxConnections", String.valueOf(keepAliveMaxConnections));
            LOG.info("Set keepAlive max connections: " + keepAliveMaxConnections);
        }
        builder.setTimeout(connectionTimeout, readTimeout).setBufferSize(bufferSize).setKeepAlive(keepAlive, keepAliveMaxConnections);
        boolean sslShuffle = conf.getBoolean("tez.runtime.shuffle.ssl.enable", false);
        builder.setSSL(sslShuffle, conf);
        return builder.build();
    }

    public static String stringify(ShuffleUserPayloads.DataMovementEventPayloadProto dmProto) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (dmProto.hasEmptyPartitions()) {
            sb.append("hasEmptyPartitions: ").append(dmProto.hasEmptyPartitions()).append(", ");
        }
        sb.append("host: " + dmProto.getHost()).append(", ");
        sb.append("port: " + dmProto.getPort()).append(", ");
        sb.append("pathComponent: " + dmProto.getPathComponent()).append(", ");
        sb.append("runDuration: " + dmProto.getRunDuration());
        sb.append("]");
        return sb.toString();
    }

    static ByteBuffer generateDMEPayload(boolean sendEmptyPartitionDetails, int numPhysicalOutputs, TezSpillRecord spillRecord, OutputContext context, int spillId, boolean finalMergeEnabled, boolean isLastEvent, String pathComponent) throws IOException {
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder payloadBuilder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        boolean outputGenerated = true;
        if (sendEmptyPartitionDetails) {
            BitSet emptyPartitionDetails = new BitSet();
            for (int i = 0; i < spillRecord.size(); ++i) {
                TezIndexRecord indexRecord = spillRecord.getIndex(i);
                if (indexRecord.hasData()) continue;
                emptyPartitionDetails.set(i);
            }
            int emptyPartitions = emptyPartitionDetails.cardinality();
            boolean bl = outputGenerated = spillRecord.size() != emptyPartitions;
            if (emptyPartitions > 0) {
                ByteString emptyPartitionsBytesString = TezCommonUtils.compressByteArrayToByteString((byte[])TezUtilsInternal.toByteArray((BitSet)emptyPartitionDetails));
                payloadBuilder.setEmptyPartitions(emptyPartitionsBytesString);
                LOG.info("EmptyPartition bitsetSize=" + emptyPartitionDetails.cardinality() + ", numOutputs=" + numPhysicalOutputs + ", emptyPartitions=" + emptyPartitions + ", compressedSize=" + emptyPartitionsBytesString.size());
            }
        }
        if (!sendEmptyPartitionDetails || outputGenerated) {
            String host = context.getExecutionContext().getHostName();
            ByteBuffer shuffleMetadata = context.getServiceProviderMetaData(SHUFFLE_HANDLER_SERVICE_ID);
            int shufflePort = ShuffleUtils.deserializeShuffleProviderMetaData(shuffleMetadata);
            payloadBuilder.setHost(host);
            payloadBuilder.setPort(shufflePort);
            payloadBuilder.setPathComponent(pathComponent);
        }
        if (!finalMergeEnabled) {
            payloadBuilder.setSpillId(spillId);
            payloadBuilder.setLastEvent(isLastEvent);
        }
        payloadBuilder.setRunDuration(0);
        ShuffleUserPayloads.DataMovementEventPayloadProto payloadProto = payloadBuilder.build();
        ByteBuffer payload = payloadProto.toByteString().asReadOnlyByteBuffer();
        return payload;
    }

    public static void generateEventsForNonStartedOutput(List<Event> eventList, int numPhysicalOutputs, OutputContext context, boolean generateVmEvent, boolean isCompositeEvent) throws IOException {
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder payloadBuilder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        if (generateVmEvent) {
            ShuffleUserPayloads.VertexManagerEventPayloadProto.Builder vmBuilder = ShuffleUserPayloads.VertexManagerEventPayloadProto.newBuilder();
            vmBuilder.setOutputSize(0L);
            VertexManagerEvent vmEvent = VertexManagerEvent.create((String)context.getDestinationVertexName(), (ByteBuffer)vmBuilder.build().toByteString().asReadOnlyByteBuffer());
            eventList.add((Event)vmEvent);
        }
        LOG.info("Setting all {} partitions as empty for non-started output", (Object)numPhysicalOutputs);
        BitSet emptyPartitionDetails = new BitSet(numPhysicalOutputs);
        emptyPartitionDetails.set(0, numPhysicalOutputs, true);
        ByteString emptyPartitionsBytesString = TezCommonUtils.compressByteArrayToByteString((byte[])TezUtilsInternal.toByteArray((BitSet)emptyPartitionDetails));
        payloadBuilder.setEmptyPartitions(emptyPartitionsBytesString);
        payloadBuilder.setRunDuration(0);
        ShuffleUserPayloads.DataMovementEventPayloadProto payloadProto = payloadBuilder.build();
        ByteBuffer dmePayload = payloadProto.toByteString().asReadOnlyByteBuffer();
        if (isCompositeEvent) {
            CompositeDataMovementEvent cdme = CompositeDataMovementEvent.create((int)0, (int)numPhysicalOutputs, (ByteBuffer)dmePayload);
            eventList.add((Event)cdme);
        } else {
            DataMovementEvent dme = DataMovementEvent.create((int)0, (ByteBuffer)dmePayload);
            eventList.add((Event)dme);
        }
    }

    public static void generateEventOnSpill(List<Event> eventList, boolean finalMergeEnabled, boolean isLastEvent, OutputContext context, int spillId, TezSpillRecord spillRecord, int numPhysicalOutputs, boolean sendEmptyPartitionDetails, String pathComponent) throws IOException {
        Preconditions.checkArgument((eventList != null ? 1 : 0) != 0, (Object)"EventList can't be null");
        if (finalMergeEnabled) {
            Preconditions.checkArgument((boolean)isLastEvent, (Object)"Can not send multiple events when final merge is enabled");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pathComponent=" + pathComponent + ", isLastEvent=" + isLastEvent + ", spillId=" + spillId + ", finalMergeDisabled=" + finalMergeEnabled + ", numPhysicalOutputs=" + numPhysicalOutputs);
        }
        ByteBuffer payload = ShuffleUtils.generateDMEPayload(sendEmptyPartitionDetails, numPhysicalOutputs, spillRecord, context, spillId, finalMergeEnabled, isLastEvent, pathComponent);
        if (finalMergeEnabled || isLastEvent) {
            ShuffleUserPayloads.VertexManagerEventPayloadProto.Builder vmBuilder = ShuffleUserPayloads.VertexManagerEventPayloadProto.newBuilder();
            long outputSize = context.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES).getValue();
            vmBuilder.setOutputSize(outputSize);
            VertexManagerEvent vmEvent = VertexManagerEvent.create((String)context.getDestinationVertexName(), (ByteBuffer)vmBuilder.build().toByteString().asReadOnlyByteBuffer());
            eventList.add((Event)vmEvent);
        }
        CompositeDataMovementEvent csdme = CompositeDataMovementEvent.create((int)0, (int)numPhysicalOutputs, (ByteBuffer)payload);
        eventList.add((Event)csdme);
    }

    public static void logIndividualFetchComplete(Logger log, long millis, long bytesCompressed, long bytesDecompressed, String outputType, InputAttemptIdentifier srcAttemptIdentifier) {
        double rate = 0.0;
        if (millis != 0L) {
            rate = (double)bytesCompressed / ((double)millis / 1000.0);
            rate /= 1048576.0;
        }
        log.info("Completed fetch for attempt: " + srcAttemptIdentifier + " to " + outputType + ", CompressedSize=" + bytesCompressed + ", DecompressedSize=" + bytesDecompressed + ", EndTime=" + System.currentTimeMillis() + ", TimeTaken=" + millis + ", Rate=" + MBPS_FORMAT.get().format(rate) + " MB/s");
    }
}

