/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.orc.ConversionTreeReaderFactory;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.TreeReaderFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public class RecordReaderFactory {
    static final Log LOG = LogFactory.getLog(RecordReaderFactory.class);
    private static final boolean isLogInfoEnabled = LOG.isInfoEnabled();

    public static TreeReaderFactory.TreeReader createTreeReader(int colId, Configuration conf, List<OrcProto.Type> fileSchema, boolean[] included, boolean skipCorrupt) throws IOException {
        boolean isAcid = RecordReaderFactory.checkAcidSchema(fileSchema);
        List<OrcProto.Type> originalFileSchema = isAcid ? fileSchema.subList(fileSchema.get(0).getSubtypesCount(), fileSchema.size()) : fileSchema;
        int numCols = originalFileSchema.get(0).getSubtypesCount();
        List<OrcProto.Type> schemaOnRead = RecordReaderFactory.getSchemaOnRead(numCols, conf);
        List<OrcProto.Type> schemaUsed = RecordReaderFactory.getMatchingSchema(fileSchema, schemaOnRead);
        if (schemaUsed == null) {
            return TreeReaderFactory.createTreeReader(colId, fileSchema, included, skipCorrupt);
        }
        return ConversionTreeReaderFactory.createTreeReader(colId, schemaUsed, included, skipCorrupt);
    }

    private static boolean checkAcidSchema(List<OrcProto.Type> fileSchema) {
        List<String> rootFields;
        List<String> acidFields;
        return fileSchema.get(0).getKind().equals((Object)OrcProto.Type.Kind.STRUCT) && (acidFields = OrcRecordUpdater.getAcidEventFields()).equals(rootFields = fileSchema.get(0).getFieldNamesList());
    }

    private static List<OrcProto.Type> getMatchingSchema(List<OrcProto.Type> fileSchema, List<OrcProto.Type> schemaOnRead) {
        if (schemaOnRead == null) {
            if (isLogInfoEnabled) {
                LOG.info((Object)"Schema is not specified on read. Using file schema.");
            }
            return null;
        }
        if (fileSchema.size() != schemaOnRead.size()) {
            if (isLogInfoEnabled) {
                LOG.info((Object)"Schema on read column count does not match file schema's column count. Falling back to using file schema.");
            }
            return null;
        }
        ArrayList result = Lists.newArrayList(fileSchema);
        boolean canPromoteType = false;
        for (int i = 0; i < fileSchema.size(); ++i) {
            OrcProto.Type fColType = fileSchema.get(i);
            OrcProto.Type rColType = schemaOnRead.get(i);
            if (fColType.getKind().equals((Object)rColType.getKind())) continue;
            if (fColType.getKind().equals((Object)OrcProto.Type.Kind.SHORT)) {
                if (rColType.getKind().equals((Object)OrcProto.Type.Kind.INT) || rColType.getKind().equals((Object)OrcProto.Type.Kind.LONG)) {
                    result.set(i, ((OrcProto.Type)result.get(i)).toBuilder().setKind(rColType.getKind()).build());
                    canPromoteType = true;
                    continue;
                }
                canPromoteType = false;
                continue;
            }
            if (fColType.getKind().equals((Object)OrcProto.Type.Kind.INT)) {
                if (rColType.getKind().equals((Object)OrcProto.Type.Kind.LONG)) {
                    result.set(i, ((OrcProto.Type)result.get(i)).toBuilder().setKind(rColType.getKind()).build());
                    canPromoteType = true;
                    continue;
                }
                canPromoteType = false;
                continue;
            }
            canPromoteType = false;
        }
        if (canPromoteType) {
            if (isLogInfoEnabled) {
                LOG.info((Object)"Integer type promotion happened in ORC record reader. Using promoted schema.");
            }
            return result;
        }
        return null;
    }

    private static List<OrcProto.Type> getSchemaOnRead(int numCols, Configuration conf) {
        String columnTypeProperty = conf.get("columns.types");
        String columnNameProperty = conf.get("columns");
        if (columnTypeProperty == null || columnNameProperty == null) {
            return null;
        }
        ArrayList columnNames = Lists.newArrayList((Object[])columnNameProperty.split(","));
        ArrayList fieldTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        StructTypeInfo structTypeInfo = new StructTypeInfo();
        structTypeInfo.setAllStructFieldNames(Lists.newArrayList(columnNames.subList(0, numCols)));
        structTypeInfo.setAllStructFieldTypeInfos(Lists.newArrayList(fieldTypes.subList(0, numCols)));
        ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)structTypeInfo);
        return RecordReaderFactory.getOrcTypes(oi);
    }

    private static List<OrcProto.Type> getOrcTypes(ObjectInspector inspector) {
        ArrayList result = Lists.newArrayList();
        RecordReaderFactory.getOrcTypesImpl(result, inspector);
        return result;
    }

    private static void getOrcTypesImpl(List<OrcProto.Type> result, ObjectInspector inspector) {
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveObjectInspector)inspector).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        type.setKind(OrcProto.Type.Kind.BOOLEAN);
                        break;
                    }
                    case BYTE: {
                        type.setKind(OrcProto.Type.Kind.BYTE);
                        break;
                    }
                    case SHORT: {
                        type.setKind(OrcProto.Type.Kind.SHORT);
                        break;
                    }
                    case INT: {
                        type.setKind(OrcProto.Type.Kind.INT);
                        break;
                    }
                    case LONG: {
                        type.setKind(OrcProto.Type.Kind.LONG);
                        break;
                    }
                    case FLOAT: {
                        type.setKind(OrcProto.Type.Kind.FLOAT);
                        break;
                    }
                    case DOUBLE: {
                        type.setKind(OrcProto.Type.Kind.DOUBLE);
                        break;
                    }
                    case STRING: {
                        type.setKind(OrcProto.Type.Kind.STRING);
                        break;
                    }
                    case CHAR: {
                        CharTypeInfo charTypeInfo = (CharTypeInfo)((PrimitiveObjectInspector)inspector).getTypeInfo();
                        type.setKind(OrcProto.Type.Kind.CHAR);
                        type.setMaximumLength(charTypeInfo.getLength());
                        break;
                    }
                    case VARCHAR: {
                        VarcharTypeInfo typeInfo = (VarcharTypeInfo)((PrimitiveObjectInspector)inspector).getTypeInfo();
                        type.setKind(OrcProto.Type.Kind.VARCHAR);
                        type.setMaximumLength(typeInfo.getLength());
                        break;
                    }
                    case BINARY: {
                        type.setKind(OrcProto.Type.Kind.BINARY);
                        break;
                    }
                    case TIMESTAMP: {
                        type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                        break;
                    }
                    case DATE: {
                        type.setKind(OrcProto.Type.Kind.DATE);
                        break;
                    }
                    case DECIMAL: {
                        DecimalTypeInfo decTypeInfo = (DecimalTypeInfo)((PrimitiveObjectInspector)inspector).getTypeInfo();
                        type.setKind(OrcProto.Type.Kind.DECIMAL);
                        type.setPrecision(decTypeInfo.precision());
                        type.setScale(decTypeInfo.scale());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown primitive category: " + ((PrimitiveObjectInspector)inspector).getPrimitiveCategory());
                    }
                }
                result.add(type.build());
                break;
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                result.add(type.build());
                RecordReaderFactory.getOrcTypesImpl(result, ((ListObjectInspector)inspector).getListElementObjectInspector());
                break;
            }
            case MAP: {
                type.setKind(OrcProto.Type.Kind.MAP);
                result.add(type.build());
                RecordReaderFactory.getOrcTypesImpl(result, ((MapObjectInspector)inspector).getMapKeyObjectInspector());
                RecordReaderFactory.getOrcTypesImpl(result, ((MapObjectInspector)inspector).getMapValueObjectInspector());
                break;
            }
            case STRUCT: {
                type.setKind(OrcProto.Type.Kind.STRUCT);
                result.add(type.build());
                for (StructField field : ((StructObjectInspector)inspector).getAllStructFieldRefs()) {
                    RecordReaderFactory.getOrcTypesImpl(result, field.getFieldObjectInspector());
                }
                break;
            }
            case UNION: {
                type.setKind(OrcProto.Type.Kind.UNION);
                result.add(type.build());
                for (ObjectInspector oi : ((UnionObjectInspector)inspector).getObjectInspectors()) {
                    RecordReaderFactory.getOrcTypesImpl(result, oi);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + inspector.getCategory());
            }
        }
    }
}

