/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.shims;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigOutputCommitter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop20.PigJobControl;

public class HadoopShims {
    private static Log LOG = LogFactory.getLog(HadoopShims.class);

    public static JobContext cloneJobContext(JobContext original) throws IOException, InterruptedException {
        JobContext newContext = new JobContext(original.getConfiguration(), original.getJobID());
        return newContext;
    }

    public static TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskId) {
        TaskAttemptContext newContext = new TaskAttemptContext(conf, taskId);
        return newContext;
    }

    public static JobContext createJobContext(Configuration conf, JobID jobId) {
        JobContext newJobContext = new JobContext(conf, jobId);
        return newJobContext;
    }

    public static boolean isMap(TaskAttemptID taskAttemptID) {
        return taskAttemptID.isMap();
    }

    public static TaskAttemptID getNewTaskAttemptID() {
        return new TaskAttemptID();
    }

    public static TaskAttemptID createTaskAttemptID(String jtIdentifier, int jobId, boolean isMap, int taskId, int id) {
        return new TaskAttemptID(jtIdentifier, jobId, isMap, taskId, id);
    }

    public static void storeSchemaForLocal(Job job, POStore st) throws IOException {
        JobContext jc = HadoopShims.createJobContext((Configuration)job.getJobConf(), new JobID());
        JobContext updatedJc = PigOutputCommitter.setUpContext(jc, st);
        PigOutputCommitter.storeCleanup(st, updatedJc.getConfiguration());
    }

    public static String getFsCounterGroupName() {
        return "FileSystemCounters";
    }

    public static void commitOrCleanup(OutputCommitter oc, JobContext jc) throws IOException {
        oc.cleanupJob(jc);
    }

    public static JobControl newJobControl(String groupName, int timeToSleep) {
        return new PigJobControl(groupName, timeToSleep);
    }

    public static long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize();
    }

    public static Counters getCounters(Job job) throws IOException {
        JobClient jobClient = job.getJobClient();
        return jobClient.getJob(job.getAssignedJobID()).getCounters();
    }

    public static boolean isJobFailed(TaskReport report) {
        float successfulProgress = 1.0f;
        return report.getProgress() != successfulProgress;
    }

    public static void unsetConf(Configuration conf, String key) {
    }

    public static void setTaskAttemptId(Configuration conf, TaskAttemptID taskAttemptID) {
        conf.set("mapred.task.id", taskAttemptID.toString());
    }

    public static boolean hasFileSystemImpl(Path path, Configuration conf) {
        String fsImpl;
        String scheme = path.toUri().getScheme();
        return scheme == null || (fsImpl = conf.get("fs." + scheme + ".impl")) != null;
    }

    public static double progressOfRunningJob(Job j) throws IOException {
        RunningJob rj = j.getJobClient().getJob(j.getAssignedJobID());
        if (rj == null && j.getState() == 0) {
            return 1.0;
        }
        if (rj == null) {
            return 0.0;
        }
        return (rj.mapProgress() + rj.reduceProgress()) / 2.0f;
    }

    public static void killJob(Job job) throws IOException {
        RunningJob runningJob = job.getJobClient().getJob(job.getAssignedJobID());
        if (runningJob != null) {
            runningJob.killJob();
        }
    }

    public static Iterator<TaskReport> getTaskReports(Job job, TaskType type) throws IOException {
        if (job.getJobConf().getBoolean("pig.stats.notaskreport", false)) {
            LOG.info((Object)("TaskReports are disabled for job: " + job.getAssignedJobID()));
            return null;
        }
        JobClient jobClient = job.getJobClient();
        TaskReport[] reports = null;
        reports = type == TaskType.MAP ? jobClient.getMapTaskReports(job.getAssignedJobID()) : jobClient.getReduceTaskReports(job.getAssignedJobID());
        return reports == null ? null : Arrays.asList(reports).iterator();
    }

    public static boolean isHadoopYARN() {
        return false;
    }
}

