/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskStateUpdateListener;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.VertexStateUpdateListener;
import org.apache.tez.dag.app.dag.event.VertexEventRootInputFailed;
import org.apache.tez.dag.app.dag.event.VertexEventRootInputInitialized;
import org.apache.tez.dag.app.dag.impl.AMUserCodeException;
import org.apache.tez.dag.app.dag.impl.TezRootInputInitializerContextImpl;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.InputInitializer;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootInputInitializerManager {
    private static final Logger LOG = LoggerFactory.getLogger(RootInputInitializerManager.class);
    private final ExecutorService rawExecutor;
    private final ListeningExecutorService executor;
    private final EventHandler eventHandler;
    private volatile boolean isStopped = false;
    private final UserGroupInformation dagUgi;
    private final StateChangeNotifier entityStateTracker;
    private final Vertex vertex;
    private final AppContext appContext;
    @VisibleForTesting
    final Map<String, InitializerWrapper> initializerMap = new HashMap<String, InitializerWrapper>();
    private final ListMultimap<String, VertexUpdateRegistrationHolder> pendingVertexRegistrations = LinkedListMultimap.create();

    public RootInputInitializerManager(Vertex vertex, AppContext appContext, UserGroupInformation dagUgi, StateChangeNotifier stateTracker) {
        this.appContext = appContext;
        this.vertex = vertex;
        this.eventHandler = appContext.getEventHandler();
        this.rawExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("InputInitializer [" + this.vertex.getName() + "] #%d").build());
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)this.rawExecutor);
        this.dagUgi = dagUgi;
        this.entityStateTracker = stateTracker;
    }

    public void runInputInitializers(List<RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> inputs) {
        for (RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> input : inputs) {
            TezRootInputInitializerContextImpl context = new TezRootInputInitializerContextImpl(input, this.vertex, this.appContext, this);
            InputInitializer initializer = this.createInitializer(input, context);
            InitializerWrapper initializerWrapper = new InitializerWrapper(input, initializer, context, this.vertex, this.entityStateTracker, this.appContext);
            List vertexUpdateRegistrations = this.pendingVertexRegistrations.removeAll((Object)input.getName());
            if (vertexUpdateRegistrations != null) {
                for (VertexUpdateRegistrationHolder h : vertexUpdateRegistrations) {
                    initializerWrapper.registerForVertexStateUpdates(h.vertexName, h.stateSet);
                }
            }
            this.initializerMap.put(input.getName(), initializerWrapper);
            ListenableFuture future = this.executor.submit((Callable)new InputInitializerCallable(initializerWrapper, this.dagUgi));
            Futures.addCallback((ListenableFuture)future, (FutureCallback)this.createInputInitializerCallback(initializerWrapper));
        }
    }

    @VisibleForTesting
    protected InputInitializer createInitializer(RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> input, InputInitializerContext context) {
        InputInitializer initializer = (InputInitializer)ReflectionUtils.createClazzInstance((String)((InputInitializerDescriptor)input.getControllerDescriptor()).getClassName(), (Class[])new Class[]{InputInitializerContext.class}, (Object[])new Object[]{context});
        return initializer;
    }

    public void handleInitializerEvents(List<TezEvent> events) {
        LinkedListMultimap eventMap = LinkedListMultimap.create();
        for (TezEvent tezEvent : events) {
            Preconditions.checkState((boolean)(tezEvent.getEvent() instanceof InputInitializerEvent));
            InputInitializerEvent event = (InputInitializerEvent)tezEvent.getEvent();
            Preconditions.checkState((boolean)this.vertex.getName().equals(event.getTargetVertexName()), (Object)"Received event for incorrect vertex");
            Preconditions.checkNotNull((Object)event.getTargetInputName(), (Object)"target input name must be set");
            InitializerWrapper initializer = this.initializerMap.get(event.getTargetInputName());
            Preconditions.checkState((initializer != null ? 1 : 0) != 0, (Object)("Received event for unknown input : " + event.getTargetInputName()));
            eventMap.put((Object)initializer, (Object)tezEvent);
        }
        if (this.isStopped) {
            LOG.warn("InitializerManager already stopped for " + this.vertex.getLogIdentifier() + " Dropping " + events.size() + " events");
        }
        for (Map.Entry entry : eventMap.asMap().entrySet()) {
            InitializerWrapper initializerWrapper = (InitializerWrapper)entry.getKey();
            if (initializerWrapper.isComplete()) {
                LOG.warn(((Collection)entry.getValue()).size() + " events targeted at vertex " + this.vertex.getLogIdentifier() + ", initializerWrapper for Input: " + initializerWrapper.getInput().getName() + " will be dropped, since Input has already been initialized.");
                continue;
            }
            initializerWrapper.handleInputInitializerEvents((Collection)entry.getValue());
        }
    }

    public void registerForVertexUpdates(String vertexName, String inputName, @Nullable Set<VertexState> stateSet) {
        Preconditions.checkNotNull((Object)vertexName, (Object)("VertexName cannot be null: " + vertexName));
        Preconditions.checkNotNull((Object)inputName, (Object)"InputName cannot be null");
        InitializerWrapper initializer = this.initializerMap.get(inputName);
        if (initializer == null) {
            this.pendingVertexRegistrations.put((Object)inputName, (Object)new VertexUpdateRegistrationHolder(vertexName, stateSet));
        } else {
            initializer.registerForVertexStateUpdates(vertexName, stateSet);
        }
    }

    @VisibleForTesting
    protected InputInitializerCallback createInputInitializerCallback(InitializerWrapper initializer) {
        return new InputInitializerCallback(initializer, this.eventHandler, this.vertex.getVertexId());
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public InitializerWrapper getInitializerWrapper(String inputName) {
        return this.initializerMap.get(inputName);
    }

    public void shutdown() {
        if (this.executor != null && !this.isStopped) {
            this.executor.shutdownNow();
            this.isStopped = true;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static class InitializerWrapper
    implements VertexStateUpdateListener,
    TaskStateUpdateListener {
        private final RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> input;
        private final InputInitializer initializer;
        private final InputInitializerContext context;
        private final AtomicBoolean isComplete = new AtomicBoolean(false);
        private final String vertexLogIdentifier;
        private final TezVertexID vertexId;
        private final StateChangeNotifier stateChangeNotifier;
        private final List<String> notificationRegisteredVertices = Lists.newArrayList();
        private final AppContext appContext;
        private final Map<String, Map<Integer, Integer>> firstSuccessfulAttemptMap = new HashMap<String, Map<Integer, Integer>>();
        private final ListMultimap<String, TezEvent> pendingEvents = LinkedListMultimap.create();
        private final List<String> taskNotificationRegisteredVertices = Lists.newLinkedList();

        InitializerWrapper(RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> input, InputInitializer initializer, InputInitializerContext context, Vertex vertex, StateChangeNotifier stateChangeNotifier, AppContext appContext) {
            this.input = input;
            this.initializer = initializer;
            this.context = context;
            this.vertexLogIdentifier = vertex.getLogIdentifier();
            this.vertexId = vertex.getVertexId();
            this.stateChangeNotifier = stateChangeNotifier;
            this.appContext = appContext;
        }

        public RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> getInput() {
            return this.input;
        }

        public InputInitializer getInitializer() {
            return this.initializer;
        }

        public String getVertexLogIdentifier() {
            return this.vertexLogIdentifier;
        }

        public boolean isComplete() {
            return this.isComplete.get();
        }

        public void setComplete() {
            this.isComplete.set(true);
            this.unregisterForVertexStatusUpdates();
            this.unregisterForTaskStatusUpdates();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerForVertexStateUpdates(String vertexName, Set<VertexState> stateSet) {
            List<String> list = this.notificationRegisteredVertices;
            synchronized (list) {
                this.notificationRegisteredVertices.add(vertexName);
            }
            this.stateChangeNotifier.registerForVertexUpdates(vertexName, stateSet, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterForVertexStatusUpdates() {
            List<String> list = this.notificationRegisteredVertices;
            synchronized (list) {
                for (String vertexName : this.notificationRegisteredVertices) {
                    this.stateChangeNotifier.unregisterForVertexUpdates(vertexName, this);
                }
            }
        }

        @Override
        public void onStateUpdated(VertexStateUpdate event) {
            if (this.isComplete()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Dropping state update for vertex=" + event.getVertexName() + ", state=" + event.getVertexState() + " since initializer " + this.input.getName() + " is already complete.");
                }
            } else {
                try {
                    this.initializer.onVertexStateUpdated(event);
                }
                catch (Exception e) {
                    this.appContext.getEventHandler().handle((Event)new VertexEventRootInputFailed(this.vertexId, this.input.getName(), new AMUserCodeException(AMUserCodeException.Source.InputInitializer, e)));
                }
            }
        }

        @InterfaceAudience.Private
        @VisibleForTesting
        public Map<String, Map<Integer, Integer>> getFirstSuccessfulAttemptMap() {
            return this.firstSuccessfulAttemptMap;
        }

        @InterfaceAudience.Private
        @VisibleForTesting
        public ListMultimap<String, TezEvent> getPendingEvents() {
            return this.pendingEvents;
        }

        @Override
        public void onTaskSucceeded(String vertexName, TezTaskID taskId, int attemptId) {
            List events;
            if (attemptId == -1) {
                throw new TezUncheckedException("AttemptId is -1. This is likely caused by TEZ-1577; recovery not supported when InputInitializerEvents are used");
            }
            Map<Integer, Integer> vertexSuccessfulAttemptMap = this.firstSuccessfulAttemptMap.get(vertexName);
            Integer successfulAttempt = vertexSuccessfulAttemptMap.get(taskId.getId());
            if (successfulAttempt == null) {
                successfulAttempt = attemptId;
                vertexSuccessfulAttemptMap.put(taskId.getId(), successfulAttempt);
            }
            if ((events = this.pendingEvents.get((Object)vertexName)) != null && !events.isEmpty()) {
                LinkedList<InputInitializerEvent> toForwardEvents = new LinkedList<InputInitializerEvent>();
                Iterator eventIterator = events.iterator();
                while (eventIterator.hasNext()) {
                    TezEvent tezEvent = (TezEvent)eventIterator.next();
                    int taskIndex = tezEvent.getSourceInfo().getTaskAttemptID().getTaskID().getId();
                    int taskAttemptIndex = tezEvent.getSourceInfo().getTaskAttemptID().getId();
                    if (taskIndex != taskId.getId()) continue;
                    if (taskAttemptIndex == successfulAttempt) {
                        toForwardEvents.add((InputInitializerEvent)tezEvent.getEvent());
                    }
                    eventIterator.remove();
                }
                this.sendEvents(toForwardEvents);
            }
        }

        public void handleInputInitializerEvents(Collection<TezEvent> tezEvents) {
            LinkedList<InputInitializerEvent> toForwardEvents = new LinkedList<InputInitializerEvent>();
            for (TezEvent tezEvent : tezEvents) {
                Vertex srcVertex;
                Task task;
                Integer successfulAttemptInteger;
                String srcVertexName = tezEvent.getSourceInfo().getTaskVertexName();
                int taskIndex = tezEvent.getSourceInfo().getTaskAttemptID().getTaskID().getId();
                int taskAttemptIndex = tezEvent.getSourceInfo().getTaskAttemptID().getId();
                Map<Integer, Integer> vertexSuccessfulAttemptMap = this.firstSuccessfulAttemptMap.get(srcVertexName);
                if (vertexSuccessfulAttemptMap == null) {
                    vertexSuccessfulAttemptMap = new HashMap<Integer, Integer>();
                    this.firstSuccessfulAttemptMap.put(srcVertexName, vertexSuccessfulAttemptMap);
                    this.stateChangeNotifier.registerForTaskSuccessUpdates(srcVertexName, this);
                    this.taskNotificationRegisteredVertices.add(srcVertexName);
                }
                if ((successfulAttemptInteger = vertexSuccessfulAttemptMap.get(taskIndex)) == null && (task = (srcVertex = this.appContext.getCurrentDAG().getVertex(srcVertexName)).getTask(taskIndex)).getState() == TaskState.SUCCEEDED) {
                    successfulAttemptInteger = task.getSuccessfulAttempt().getID().getId();
                    vertexSuccessfulAttemptMap.put(taskIndex, successfulAttemptInteger);
                }
                if (successfulAttemptInteger == null) {
                    this.pendingEvents.put((Object)srcVertexName, (Object)tezEvent);
                    continue;
                }
                if (taskAttemptIndex != successfulAttemptInteger) continue;
                toForwardEvents.add((InputInitializerEvent)tezEvent.getEvent());
            }
            this.sendEvents(toForwardEvents);
        }

        private void sendEvents(List<InputInitializerEvent> events) {
            if (events != null && !events.isEmpty()) {
                try {
                    this.initializer.handleInputInitializerEvent(events);
                }
                catch (Exception e) {
                    this.appContext.getEventHandler().handle((Event)new VertexEventRootInputFailed(this.vertexId, this.input.getName(), new AMUserCodeException(AMUserCodeException.Source.InputInitializer, e)));
                }
            }
        }

        private void unregisterForTaskStatusUpdates() {
            for (String vertexName : this.taskNotificationRegisteredVertices) {
                this.stateChangeNotifier.unregisterForTaskSuccessUpdates(vertexName, this);
            }
        }
    }

    @VisibleForTesting
    private static class InputInitializerCallback
    implements FutureCallback<List<org.apache.tez.runtime.api.Event>> {
        private final InitializerWrapper initializer;
        private final EventHandler eventHandler;
        private final TezVertexID vertexID;

        public InputInitializerCallback(InitializerWrapper initializer, EventHandler eventHandler, TezVertexID vertexID) {
            this.initializer = initializer;
            this.eventHandler = eventHandler;
            this.vertexID = vertexID;
        }

        public void onSuccess(List<org.apache.tez.runtime.api.Event> result) {
            this.initializer.setComplete();
            LOG.info("Succeeded InputInitializer for Input: " + this.initializer.getInput().getName() + " on vertex " + this.initializer.getVertexLogIdentifier());
            this.eventHandler.handle((Event)new VertexEventRootInputInitialized(this.vertexID, this.initializer.getInput().getName(), result));
        }

        public void onFailure(Throwable t) {
            if (t instanceof UndeclaredThrowableException) {
                t = t.getCause();
            }
            this.initializer.setComplete();
            LOG.info("Failed InputInitializer for Input: " + this.initializer.getInput().getName() + " on vertex " + this.initializer.getVertexLogIdentifier());
            this.eventHandler.handle((Event)new VertexEventRootInputFailed(this.vertexID, this.initializer.getInput().getName(), new AMUserCodeException(AMUserCodeException.Source.InputInitializer, t)));
        }
    }

    private static class InputInitializerCallable
    implements Callable<List<org.apache.tez.runtime.api.Event>> {
        private final InitializerWrapper initializerWrapper;
        private final UserGroupInformation ugi;

        public InputInitializerCallable(InitializerWrapper initializer, UserGroupInformation ugi) {
            this.initializerWrapper = initializer;
            this.ugi = ugi;
        }

        @Override
        public List<org.apache.tez.runtime.api.Event> call() throws Exception {
            List events = (List)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<org.apache.tez.runtime.api.Event>>(){

                @Override
                public List<org.apache.tez.runtime.api.Event> run() throws Exception {
                    LOG.info("Starting InputInitializer for Input: " + InputInitializerCallable.this.initializerWrapper.getInput().getName() + " on vertex " + InputInitializerCallable.this.initializerWrapper.getVertexLogIdentifier());
                    return InputInitializerCallable.this.initializerWrapper.getInitializer().initialize();
                }
            });
            return events;
        }
    }

    private static class VertexUpdateRegistrationHolder {
        private final String vertexName;
        private final Set<VertexState> stateSet;

        private VertexUpdateRegistrationHolder(String vertexName, Set<VertexState> stateSet) {
            this.vertexName = vertexName;
            this.stateSet = stateSet;
        }
    }
}

