/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;

public class MetricsReplicationSourceSourceImpl
implements MetricsReplicationSourceSource {
    private final MetricsReplicationSourceImpl rms;
    private final String id;
    private final String sizeOfLogQueueKey;
    private final String ageOfLastShippedOpKey;
    private final String logReadInEditsKey;
    private final String logEditsFilteredKey;
    private final String shippedBatchesKey;
    private final String shippedOpsKey;
    private final String shippedKBsKey;
    private final String logReadInBytesKey;
    private final MetricMutableGaugeLong ageOfLastShippedOpGauge;
    private long ageOfLastShipped;
    private final MetricMutableGaugeLong sizeOfLogQueueGauge;
    private final MetricMutableCounterLong logReadInEditsCounter;
    private final MetricMutableCounterLong logEditsFilteredCounter;
    private final MetricMutableCounterLong shippedBatchesCounter;
    private final MetricMutableCounterLong shippedOpsCounter;
    private final MetricMutableCounterLong shippedKBsCounter;
    private final MetricMutableCounterLong logReadInBytesCounter;

    public MetricsReplicationSourceSourceImpl(MetricsReplicationSourceImpl rms, String id) {
        this.rms = rms;
        this.id = id;
        this.ageOfLastShippedOpKey = "source." + id + ".ageOfLastShippedOp";
        this.ageOfLastShippedOpGauge = rms.getMetricsRegistry().getLongGauge(this.ageOfLastShippedOpKey, 0L);
        this.sizeOfLogQueueKey = "source." + id + ".sizeOfLogQueue";
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getLongGauge(this.sizeOfLogQueueKey, 0L);
        this.shippedBatchesKey = "source." + this.id + ".shippedBatches";
        this.shippedBatchesCounter = rms.getMetricsRegistry().getLongCounter(this.shippedBatchesKey, 0L);
        this.shippedOpsKey = "source." + this.id + ".shippedOps";
        this.shippedOpsCounter = rms.getMetricsRegistry().getLongCounter(this.shippedOpsKey, 0L);
        this.shippedKBsKey = "source." + this.id + ".shippedKBs";
        this.shippedKBsCounter = rms.getMetricsRegistry().getLongCounter(this.shippedKBsKey, 0L);
        this.logReadInBytesKey = "source." + this.id + ".logReadInBytes";
        this.logReadInBytesCounter = rms.getMetricsRegistry().getLongCounter(this.logReadInBytesKey, 0L);
        this.logReadInEditsKey = "source." + id + ".logEditsRead";
        this.logReadInEditsCounter = rms.getMetricsRegistry().getLongCounter(this.logReadInEditsKey, 0L);
        this.logEditsFilteredKey = "source." + id + ".logEditsFiltered";
        this.logEditsFilteredCounter = rms.getMetricsRegistry().getLongCounter(this.logEditsFilteredKey, 0L);
    }

    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpGauge.set(age);
        this.ageOfLastShipped = age;
    }

    public void setSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.set((long)size);
    }

    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr((long)size);
    }

    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr((long)size);
    }

    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    public void incrLogEditsFiltered(long size) {
        this.logEditsFilteredCounter.incr(size);
    }

    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr((long)batches);
    }

    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    public void incrShippedKBs(long size) {
        this.shippedKBsCounter.incr(size);
    }

    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    public void clear() {
        this.rms.removeMetric(this.ageOfLastShippedOpKey);
        this.rms.removeMetric(this.sizeOfLogQueueKey);
        this.rms.removeMetric(this.shippedBatchesKey);
        this.rms.removeMetric(this.shippedOpsKey);
        this.rms.removeMetric(this.shippedKBsKey);
        this.rms.removeMetric(this.logReadInBytesKey);
        this.rms.removeMetric(this.logReadInEditsKey);
        this.rms.removeMetric(this.logEditsFilteredKey);
    }

    public long getLastShippedAge() {
        return this.ageOfLastShipped;
    }
}

