/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.committable.InMemoryCommitTable;
import org.apache.omid.transaction.HBaseOmidClientConfiguration;
import org.apache.omid.transaction.HBaseTransactionManager;
import org.apache.omid.transaction.TTable;
import org.apache.omid.tso.TSOMockModule;
import org.apache.omid.tso.TSOServer;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.TSOClient;
import org.apache.phoenix.coprocessor.OmidGCProcessor;
import org.apache.phoenix.coprocessor.OmidTransactionalProcessor;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.transaction.OmidTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionClient;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.PhoenixTransactionService;
import org.apache.phoenix.transaction.TransactionFactory;

public class OmidTransactionProvider
implements PhoenixTransactionProvider {
    private static final OmidTransactionProvider INSTANCE = new OmidTransactionProvider();
    public static final String OMID_TSO_PORT = "phoenix.omid.tso.port";
    public static final String OMID_TSO_CONFLICT_MAP_SIZE = "phoenix.omid.tso.conflict.map.size";
    public static final String OMID_TSO_TIMESTAMP_TYPE = "phoenix.omid.tso.timestamp.type";
    public static final int DEFAULT_OMID_TSO_CONFLICT_MAP_SIZE = 1000;
    public static final String DEFAULT_OMID_TSO_TIMESTAMP_TYPE = "WORLD_TIME";
    private HBaseTransactionManager transactionManager = null;
    private volatile CommitTable.Client commitTableClient = null;
    private CommitTable.Writer commitTableWriter = null;

    public static final OmidTransactionProvider getInstance() {
        return INSTANCE;
    }

    private OmidTransactionProvider() {
    }

    public String toString() {
        return this.getProvider().toString();
    }

    @Override
    public PhoenixTransactionContext getTransactionContext(byte[] txnBytes) throws IOException {
        return new OmidTransactionContext(Arrays.copyOf(txnBytes, txnBytes.length - 1));
    }

    @Override
    public PhoenixTransactionContext getTransactionContext(PhoenixConnection connection) throws SQLException {
        return new OmidTransactionContext(connection);
    }

    @Override
    public PhoenixTransactionClient getTransactionClient(Configuration config, PhoenixEmbeddedDriver.ConnectionInfo connectionInfo) throws SQLException {
        if (this.transactionManager == null) {
            try {
                HBaseOmidClientConfiguration clientConf = new HBaseOmidClientConfiguration();
                clientConf.setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel.ROW);
                this.transactionManager = (HBaseTransactionManager)HBaseTransactionManager.newInstance(clientConf);
            }
            catch (IOException | InterruptedException e) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
            }
        }
        return new OmidTransactionClient(this.transactionManager);
    }

    public CommitTable.Client getCommitTableClient() {
        return this.commitTableClient;
    }

    @Override
    public PhoenixTransactionService getTransactionService(Configuration config, PhoenixEmbeddedDriver.ConnectionInfo connectionInfo, int port) throws SQLException {
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setPort(port);
        tsoConfig.setConflictMapSize(config.getInt(OMID_TSO_CONFLICT_MAP_SIZE, 1000));
        tsoConfig.setTimestampType(config.get(OMID_TSO_TIMESTAMP_TYPE, DEFAULT_OMID_TSO_TIMESTAMP_TYPE));
        tsoConfig.setWaitStrategy(TSOServerConfig.WAIT_STRATEGY.LOW_CPU.toString());
        Injector injector = Guice.createInjector((Module[])new Module[]{new TSOMockModule(tsoConfig)});
        TSOServer tso = (TSOServer)((Object)injector.getInstance(TSOServer.class));
        tso.startAsync();
        tso.awaitRunning();
        OmidClientConfiguration clientConfig = new OmidClientConfiguration();
        clientConfig.setConnectionString("localhost:" + port);
        clientConfig.setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel.ROW);
        InMemoryCommitTable commitTable = (InMemoryCommitTable)injector.getInstance(CommitTable.class);
        try {
            TSOClient client = TSOClient.newInstance(clientConfig);
            HBaseOmidClientConfiguration clientConf = new HBaseOmidClientConfiguration();
            clientConf.setConnectionString("localhost:" + port);
            clientConf.setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel.ROW);
            clientConf.setHBaseConfiguration(config);
            this.commitTableClient = commitTable.getClient();
            this.commitTableWriter = commitTable.getWriter();
            this.transactionManager = HBaseTransactionManager.builder(clientConf).commitTableClient(this.commitTableClient).commitTableWriter(this.commitTableWriter).tsoClient(client).build();
        }
        catch (IOException | InterruptedException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
        return new OmidTransactionService(tso, this.transactionManager);
    }

    @Override
    public Class<? extends RegionObserver> getCoprocessor() {
        return OmidTransactionalProcessor.class;
    }

    @Override
    public Class<? extends RegionObserver> getGCCoprocessor() {
        return OmidGCProcessor.class;
    }

    @Override
    public TransactionFactory.Provider getProvider() {
        return TransactionFactory.Provider.OMID;
    }

    @Override
    public boolean isUnsupported(PhoenixTransactionProvider.Feature feature) {
        return true;
    }

    @Override
    public Put markPutAsCommitted(Put put, long timestamp, long commitTimestamp) {
        return TTable.markPutAsCommitted(put, timestamp, timestamp);
    }

    static class OmidTransactionService
    implements PhoenixTransactionService {
        private final HBaseTransactionManager transactionManager;
        private TSOServer tso;

        public OmidTransactionService(TSOServer tso, HBaseTransactionManager transactionManager) {
            this.tso = tso;
            this.transactionManager = transactionManager;
        }

        public void start() {
        }

        @Override
        public void close() throws IOException {
            if (this.transactionManager != null) {
                this.transactionManager.close();
            }
            if (this.tso != null) {
                this.tso.stopAsync();
                this.tso.awaitTerminated();
            }
        }
    }

    static class OmidTransactionClient
    implements PhoenixTransactionClient {
        private final HBaseTransactionManager transactionManager;

        public OmidTransactionClient(HBaseTransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        public HBaseTransactionManager getTransactionClient() {
            return this.transactionManager;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

