/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.text.Format;
import java.util.Random;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBinaryBase;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;

public class PVarbinary
extends PBinaryBase {
    public static final PVarbinary INSTANCE = new PVarbinary();

    private PVarbinary() {
        super("VARBINARY", -3, byte[].class, null, 22);
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        return (byte[])object;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            return 0;
        }
        byte[] o = (byte[])object;
        System.arraycopy(bytes, offset, o, 0, o.length);
        return o.length;
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        byte[] bytes = this.toBytes(object);
        if (sortOrder == SortOrder.DESC) {
            return SortOrder.invert(bytes, 0, new byte[bytes.length], 0, bytes.length);
        }
        return bytes;
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (length == 0) {
            return null;
        }
        if (offset == 0 && bytes.length == length && sortOrder == SortOrder.ASC) {
            return bytes;
        }
        byte[] bytesCopy = new byte[length];
        System.arraycopy(bytes, offset, bytesCopy, 0, length);
        if (sortOrder == SortOrder.DESC) {
            bytesCopy = SortOrder.invert(bytes, offset, bytesCopy, 0, length);
            offset = 0;
        }
        return bytesCopy;
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        return actualType.toBytes(object);
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int estimateByteSize(Object o) {
        byte[] value = (byte[])o;
        return value == null ? 1 : value.length;
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PVarbinary.equalsAny(targetType, this, PBinary.INSTANCE);
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (PVarbinary.equalsAny(rhsType, this, PBinary.INSTANCE)) {
            return Bytes.compareTo((byte[])((byte[])lhs), (byte[])((byte[])rhs));
        }
        byte[] rhsBytes = rhsType.toBytes(rhs);
        return Bytes.compareTo((byte[])((byte[])lhs), (byte[])rhsBytes);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        byte[] object = Base64.decode((String)value);
        if (object == null) {
            throw PVarbinary.newIllegalDataException("Input: [" + value + "]  is not base64 encoded");
        }
        return object;
    }

    @Override
    public String toStringLiteral(byte[] b, int o, int length, Format formatter) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (length > 0) {
            for (int i = o; i < o + length; ++i) {
                buf.append(0xFF & b[i]);
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        return this.toStringLiteral((byte[])o, 0, ((byte[])o).length, formatter);
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        int length = maxLength != null && maxLength > 0 ? maxLength : 1;
        byte[] b = new byte[length];
        ((Random)RANDOM.get()).nextBytes(b);
        return b;
    }
}

