/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.exception.PhoenixNonRetryableRuntimeException;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.GuidePostsCache;
import org.apache.phoenix.query.GuidePostsCacheFactory;
import org.apache.phoenix.query.GuidePostsCacheWrapper;
import org.apache.phoenix.query.PhoenixStatsLoader;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.ReadOnlyProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuidePostsCacheProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuidePostsCacheProvider.class);
    GuidePostsCacheFactory guidePostsCacheFactory = null;

    @VisibleForTesting
    GuidePostsCacheFactory loadAndGetGuidePostsCacheFactory(String classString) {
        Preconditions.checkNotNull((Object)classString);
        if (this.guidePostsCacheFactory == null) {
            try {
                Class<?> clazz = Class.forName(classString);
                if (!GuidePostsCacheFactory.class.isAssignableFrom(clazz)) {
                    String msg = String.format("Could not load/instantiate class %s is not an instance of GuidePostsCacheFactory", classString);
                    LOGGER.error(msg);
                    throw new PhoenixNonRetryableRuntimeException(msg);
                }
                List factoryList = InstanceResolver.get(GuidePostsCacheFactory.class, null);
                for (GuidePostsCacheFactory factory : factoryList) {
                    if (!clazz.isInstance(factory)) continue;
                    this.guidePostsCacheFactory = factory;
                    LOGGER.info(String.format("Sucessfully loaded class for GuidePostsCacheFactor of type: %s", classString));
                    break;
                }
                if (this.guidePostsCacheFactory == null) {
                    String msg = String.format("Could not load/instantiate class %s", classString);
                    LOGGER.error(msg);
                    throw new PhoenixNonRetryableRuntimeException(msg);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(String.format("Could not load/instantiate class %s", classString), (Throwable)e);
                throw new PhoenixNonRetryableRuntimeException(e);
            }
        }
        return this.guidePostsCacheFactory;
    }

    public GuidePostsCacheWrapper getGuidePostsCache(String classStr, ConnectionQueryServices queryServices, Configuration config) {
        ReadOnlyProps props = null;
        if (queryServices != null) {
            props = queryServices.getProps();
        }
        GuidePostsCacheFactory guidePostCacheFactory = this.loadAndGetGuidePostsCacheFactory(classStr);
        PhoenixStatsLoader phoenixStatsLoader = this.guidePostsCacheFactory.getPhoenixStatsLoader(queryServices, props, config);
        GuidePostsCache guidePostsCache = guidePostCacheFactory.getGuidePostsCache(phoenixStatsLoader, config);
        return new GuidePostsCacheWrapper(guidePostsCache);
    }
}

