/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import org.apache.phoenix.memory.ChildMemoryManager;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateConnectionQueryServices;

public class ChildQueryServices
extends DelegateConnectionQueryServices {
    private final MemoryManager memoryManager;
    private static final int DEFAULT_MAX_ORG_MEMORY_PERC = 30;

    public ChildQueryServices(ConnectionQueryServices services) {
        super(services);
        int maxOrgMemPerc = this.getProps().getInt("phoenix.query.maxTenantMemoryPercentage", 30);
        this.memoryManager = new ChildMemoryManager(services.getMemoryManager(), maxOrgMemPerc);
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }
}

