/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number;

import com.ibm.icu.impl.StandardPlural;
import com.ibm.icu.impl.number.Modifier;

public class ParameterizedModifier {
    private final Modifier positive;
    private final Modifier negative;
    final Modifier[] mods;
    boolean frozen;

    public ParameterizedModifier(Modifier positive, Modifier negative) {
        this.positive = positive;
        this.negative = negative;
        this.mods = null;
        this.frozen = true;
    }

    public ParameterizedModifier() {
        this.positive = null;
        this.negative = null;
        this.mods = new Modifier[2 * StandardPlural.COUNT];
        this.frozen = false;
    }

    public void setModifier(boolean isNegative, StandardPlural plural, Modifier mod) {
        assert (!this.frozen);
        this.mods[ParameterizedModifier.getModIndex((boolean)isNegative, (StandardPlural)plural)] = mod;
    }

    public void freeze() {
        this.frozen = true;
    }

    public Modifier getModifier(boolean isNegative) {
        assert (this.frozen);
        assert (this.mods == null);
        return isNegative ? this.negative : this.positive;
    }

    public Modifier getModifier(boolean isNegative, StandardPlural plural) {
        assert (this.frozen);
        assert (this.positive == null);
        return this.mods[ParameterizedModifier.getModIndex(isNegative, plural)];
    }

    private static int getModIndex(boolean isNegative, StandardPlural plural) {
        return plural.ordinal() * 2 + (isNegative ? 1 : 0);
    }
}

