/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.JavaMathOneArgumentFunction;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.util.ByteUtil;

public abstract class JavaMathTwoArgumentFunction
extends ScalarFunction {
    public JavaMathTwoArgumentFunction() {
    }

    public JavaMathTwoArgumentFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    protected abstract double compute(double var1, double var3);

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression arg2Expr;
        PDataType returnType = this.getDataType();
        Expression arg1Expr = (Expression)this.children.get(0);
        if (!arg1Expr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        double arg1 = JavaMathOneArgumentFunction.getArg(arg1Expr, ptr);
        Expression expression = arg2Expr = this.children.size() <= 1 ? null : (Expression)this.children.get(1);
        if (arg2Expr != null && !arg2Expr.evaluate(tuple, ptr)) {
            return false;
        }
        if (arg2Expr == null || ptr.getLength() == 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        double arg2 = JavaMathOneArgumentFunction.getArg(arg2Expr, ptr);
        ptr.set(new byte[returnType.getByteSize().intValue()]);
        returnType.getCodec().encodeDouble(this.compute(arg1, arg2), ptr);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDouble.INSTANCE;
    }
}

