/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFObjectStreamParser
extends BaseParser {
    private static final Log LOG = LogFactory.getLog(PDFObjectStreamParser.class);
    private List<COSObject> streamObjects = null;
    private List<Long> objectNumbers = null;
    private COSStream stream;

    public PDFObjectStreamParser(COSStream strm, COSDocument doc, boolean forceParsing) throws IOException {
        super(strm.getUnfilteredStream(), forceParsing);
        this.setDocument(doc);
        this.stream = strm;
    }

    public PDFObjectStreamParser(COSStream strm, COSDocument doc) throws IOException {
        this(strm, doc, FORCE_PARSING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        try {
            int numberOfObjects = this.stream.getInt("N");
            this.objectNumbers = new ArrayList<Long>(numberOfObjects);
            this.streamObjects = new ArrayList<COSObject>(numberOfObjects);
            for (int i = 0; i < numberOfObjects; ++i) {
                long objectNumber = this.readObjectNumber();
                long offset = this.readLong();
                this.objectNumbers.add(new Long(objectNumber));
            }
            COSObject object = null;
            COSBase cosObject = null;
            int objectCounter = 0;
            while ((cosObject = this.parseDirObject()) != null) {
                object = new COSObject(cosObject);
                object.setGenerationNumber(COSInteger.ZERO);
                if (objectCounter >= this.objectNumbers.size()) {
                    LOG.error("/ObjStm (object stream) has more objects than /N " + numberOfObjects);
                    break;
                }
                COSInteger objNum = COSInteger.get(this.objectNumbers.get(objectCounter).intValue());
                object.setObjectNumber(objNum);
                this.streamObjects.add(object);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("parsed=" + object);
                }
                if (!this.pdfSource.isEOF() && this.pdfSource.peek() == 101) {
                    this.readLine();
                }
                ++objectCounter;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.pdfSource.close();
            throw throwable;
        }
        this.pdfSource.close();
    }

    public List<COSObject> getObjects() {
        return this.streamObjects;
    }
}

