---
title: "Bear Token"
weight: 2
type: docs
aliases:
- /concepts/rest/bear.html
---
<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# Bear Token

A bearer token is an encrypted string, typically generated by the server based on a secret key. When the client
sends a request to the server, it must include `Authorization: Bearer <token>` in the request header. After receiving
the request, the server extracts the `<token>` and validates its legitimacy. If the validation passes, the
authentication is successful.

```sql
CREATE CATALOG `paimon-rest-catalog`
WITH (
    'type' = 'paimon',
    'uri' = '<catalog server url>',
    'metastore' = 'rest',
    'warehouse' = 'my_instance_name',
    'token.provider' = 'bear'
    'token' = '<token>'
);
```
