/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockDataStreamOutput;
import org.apache.hadoop.hdds.scm.storage.ByteBufferStreamOutput;
import org.apache.hadoop.hdds.scm.storage.StreamBuffer;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.security.token.Token;

public final class BlockDataStreamOutputEntry
implements ByteBufferStreamOutput {
    private final OzoneClientConfig config;
    private ByteBufferStreamOutput byteBufferStreamOutput;
    private BlockID blockID;
    private final String key;
    private final XceiverClientFactory xceiverClientManager;
    private final Pipeline pipeline;
    private final long length;
    private long currentPosition;
    private final Token<OzoneBlockTokenIdentifier> token;
    private List<StreamBuffer> bufferList;

    private BlockDataStreamOutputEntry(BlockID blockID, String key, XceiverClientFactory xceiverClientManager, Pipeline pipeline, long length, Token<OzoneBlockTokenIdentifier> token, OzoneClientConfig config, List<StreamBuffer> bufferList) {
        this.config = config;
        this.byteBufferStreamOutput = null;
        this.blockID = blockID;
        this.key = key;
        this.xceiverClientManager = xceiverClientManager;
        this.pipeline = pipeline;
        this.token = token;
        this.length = length;
        this.currentPosition = 0L;
        this.bufferList = bufferList;
    }

    long getLength() {
        return this.length;
    }

    Token<OzoneBlockTokenIdentifier> getToken() {
        return this.token;
    }

    long getRemaining() {
        return this.length - this.currentPosition;
    }

    private void checkStream() throws IOException {
        if (this.byteBufferStreamOutput == null) {
            this.byteBufferStreamOutput = new BlockDataStreamOutput(this.blockID, this.xceiverClientManager, this.pipeline, this.config, this.token, this.bufferList);
        }
    }

    public void write(ByteBuffer b, int off, int len) throws IOException {
        this.checkStream();
        this.byteBufferStreamOutput.write(b, off, len);
        this.currentPosition += (long)len;
    }

    public void flush() throws IOException {
        if (this.byteBufferStreamOutput != null) {
            this.byteBufferStreamOutput.flush();
        }
    }

    public void hflush() throws IOException {
        this.hsync();
    }

    public void hsync() throws IOException {
        if (this.byteBufferStreamOutput != null) {
            this.byteBufferStreamOutput.hsync();
        }
    }

    public void close() throws IOException {
        if (this.byteBufferStreamOutput != null) {
            this.byteBufferStreamOutput.close();
            this.blockID = ((BlockDataStreamOutput)this.byteBufferStreamOutput).getBlockID();
        }
    }

    boolean isClosed() {
        if (this.byteBufferStreamOutput != null) {
            return ((BlockDataStreamOutput)this.byteBufferStreamOutput).isClosed();
        }
        return false;
    }

    Collection<DatanodeDetails> getFailedServers() {
        if (this.byteBufferStreamOutput != null) {
            BlockDataStreamOutput out = (BlockDataStreamOutput)this.byteBufferStreamOutput;
            return out.getFailedServers();
        }
        return Collections.emptyList();
    }

    long getWrittenDataLength() {
        if (this.byteBufferStreamOutput != null) {
            BlockDataStreamOutput out = (BlockDataStreamOutput)this.byteBufferStreamOutput;
            return out.getWrittenDataLength();
        }
        return 0L;
    }

    public long getTotalAckDataLength() {
        if (this.byteBufferStreamOutput != null) {
            BlockDataStreamOutput out = (BlockDataStreamOutput)this.byteBufferStreamOutput;
            this.blockID = out.getBlockID();
            return out.getTotalAckDataLength();
        }
        return 0L;
    }

    void cleanup(boolean invalidateClient) throws IOException {
        this.checkStream();
        BlockDataStreamOutput out = (BlockDataStreamOutput)this.byteBufferStreamOutput;
        out.cleanup(invalidateClient);
    }

    void writeOnRetry(long len) throws IOException {
        this.checkStream();
        BlockDataStreamOutput out = (BlockDataStreamOutput)this.byteBufferStreamOutput;
        out.writeOnRetry(len);
        this.currentPosition += len;
    }

    @VisibleForTesting
    public ByteBufferStreamOutput getByteBufStreamOutput() {
        return this.byteBufferStreamOutput;
    }

    public BlockID getBlockID() {
        return this.blockID;
    }

    public String getKey() {
        return this.key;
    }

    public XceiverClientFactory getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(long curPosition) {
        this.currentPosition = curPosition;
    }

    public static class Builder {
        private BlockID blockID;
        private String key;
        private XceiverClientFactory xceiverClientManager;
        private Pipeline pipeline;
        private long length;
        private Token<OzoneBlockTokenIdentifier> token;
        private OzoneClientConfig config;
        private List<StreamBuffer> bufferList;

        public Builder setBlockID(BlockID bID) {
            this.blockID = bID;
            return this;
        }

        public Builder setKey(String keys) {
            this.key = keys;
            return this;
        }

        public Builder setXceiverClientManager(XceiverClientFactory xClientManager) {
            this.xceiverClientManager = xClientManager;
            return this;
        }

        public Builder setPipeline(Pipeline ppln) {
            this.pipeline = ppln;
            return this;
        }

        public Builder setLength(long len) {
            this.length = len;
            return this;
        }

        public Builder setConfig(OzoneClientConfig clientConfig) {
            this.config = clientConfig;
            return this;
        }

        public Builder setToken(Token<OzoneBlockTokenIdentifier> bToken) {
            this.token = bToken;
            return this;
        }

        public Builder setBufferList(List<StreamBuffer> bList) {
            this.bufferList = bList;
            return this;
        }

        public BlockDataStreamOutputEntry build() {
            return new BlockDataStreamOutputEntry(this.blockID, this.key, this.xceiverClientManager, this.pipeline, this.length, this.token, this.config, this.bufferList);
        }
    }
}

