/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.cli.datanode.DecommissionSubCommand;
import org.apache.hadoop.hdds.scm.cli.datanode.HostNameParameters;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="recommission", description={"Return a datanode to service"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class RecommissionSubCommand
extends ScmSubcommand {
    @CommandLine.Mixin
    private HostNameParameters hostNameParams;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        List<String> hosts = this.hostNameParams.getHostNames();
        List errors = scmClient.recommissionNodes(hosts);
        System.out.println("Started recommissioning datanode(s):\n" + String.join((CharSequence)"\n", hosts));
        DecommissionSubCommand.showErrors(errors, "Some nodes could be recommissioned");
    }
}

