/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.DeleteBlockResult;

public class DeleteBlockGroupResult {
    private String objectKey;
    private List<DeleteBlockResult> blockResultList;

    public DeleteBlockGroupResult(String objectKey, List<DeleteBlockResult> blockResultList) {
        this.objectKey = objectKey;
        this.blockResultList = blockResultList;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public List<DeleteBlockResult> getBlockResultList() {
        return this.blockResultList;
    }

    public List<ScmBlockLocationProtocolProtos.DeleteScmBlockResult> getBlockResultProtoList() {
        ArrayList<ScmBlockLocationProtocolProtos.DeleteScmBlockResult> resultProtoList = new ArrayList<ScmBlockLocationProtocolProtos.DeleteScmBlockResult>(this.blockResultList.size());
        for (DeleteBlockResult result : this.blockResultList) {
            ScmBlockLocationProtocolProtos.DeleteScmBlockResult proto = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.newBuilder().setBlockID(result.getBlockID().getProtobuf()).setResult(result.getResult()).build();
            resultProtoList.add(proto);
        }
        return resultProtoList;
    }

    public static List<DeleteBlockResult> convertBlockResultProto(List<ScmBlockLocationProtocolProtos.DeleteScmBlockResult> results) {
        ArrayList<DeleteBlockResult> protoResults = new ArrayList<DeleteBlockResult>(results.size());
        for (ScmBlockLocationProtocolProtos.DeleteScmBlockResult result : results) {
            protoResults.add(new DeleteBlockResult(BlockID.getFromProtobuf((HddsProtos.BlockID)result.getBlockID()), result.getResult()));
        }
        return protoResults;
    }

    public boolean isSuccess() {
        for (DeleteBlockResult result : this.blockResultList) {
            if (result.getResult() == ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.success) continue;
            return false;
        }
        return true;
    }

    public List<BlockID> getFailedBlocks() {
        List<BlockID> failedBlocks = this.blockResultList.stream().filter(result -> result.getResult() != ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.success).map(DeleteBlockResult::getBlockID).collect(Collectors.toList());
        return failedBlocks;
    }
}

