/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.cache;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.utils.db.cache.CacheStats;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;

class CacheStatsRecorder {
    private final AtomicLong cacheHits = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    private final AtomicLong iterationTimes = new AtomicLong(0L);

    CacheStatsRecorder() {
    }

    public void recordHit() {
        this.cacheHits.incrementAndGet();
    }

    public void recordMiss() {
        this.cacheMisses.incrementAndGet();
    }

    public void recordValue(CacheValue<?> value) {
        if (value == null) {
            this.recordMiss();
        } else {
            this.recordHit();
        }
    }

    public void recordIteration() {
        this.iterationTimes.incrementAndGet();
    }

    public CacheStats snapshot() {
        return new CacheStats(this.cacheHits.get(), this.cacheMisses.get(), this.iterationTimes.get());
    }
}

